function [u,w] = policy(E,x)

% POLICY computes the current policy u given the state x and the trajectory
% library in E. w is the index of the locally linear controller nearest to x.

xi          = E.int(x);
Nx          = E.scale*angle_expand(xi,E.angles);

if isfield(E,'kdtree')
   [w, dum, E.kdtree] = kdtreeidx([], Nx', E.kdtree);
else
   Ndiff       = Nx(:,ones(1,size(E.Nlocs,2))) - E.Nlocs;
   dist        = sum(Ndiff.^2);
   [dum, idx]  = sort(dist);
   w           = idx(1);
end

diff              = xi - E.Locs(:,w);
diff(E.angles,:)  = mod(diff(E.angles,:)+pi,2*pi)-pi;
u                 = E.Gains(:,:,w)*[1; diff];