function no_error=draw_swimmer(E,x,x_rel,w)
% DRAW_SWIMMER updates the swimmer graphics
if isempty(findobj(0,'Tag','SwimmerWindow'))
   no_error = 0;
   kdtreeidx([],[],E.kdtree);
   return;
else
   no_error = 1;
end

th =  x(3:2+E.d);
T  =  [cos(th) sin(th)];
R  =  E.P*T;
R1 =  R-0.5*E.L*T;
R2 =  R+0.5*E.L*T;
Rx =  [R1(:,1) R2(:,1)]+x(1);
Ry =  [R1(:,2) R2(:,2)]+x(2);

for i=1:E.d
   set(E.Glines(i),'Xdata',Rx(i,:),'Ydata',Ry(i,:));
end

XY = get(E.Gnose,'user');
set(E.Gnose,'Xdata',XY{1}+Rx(E.nose,1),'Ydata',XY{2}+Ry(E.nose,1),'Zdata',XY{3});
xi       = E.int(x_rel);
Nxi      = E.scale*angle_expand(xi,E.angles)-E.TJcm;
if ~isnan(w)
   [xg,yg,zg]= sphere(6);
   set(E.Gstate,'Xdata',E.v1*Nxi+E.gs*xg,'Ydata',E.v2*Nxi+E.gs*yg,'Zdata',E.v3*Nxi+E.gs*zg);   
   gw       = E.Nlocs(:,w) - E.TJcm;
   set(E.Gwinner,'Xdata',E.v1*gw+E.gs*xg,'Ydata',E.v2*gw+E.gs*yg,'Zdata',E.v3*gw+E.gs*zg);
end



