/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.MarioActions;
import engine.helper.SpriteType;
import engine.helper.TileFeature;
import engine.sprites.BulletBill;
import engine.sprites.Enemy;
import engine.sprites.Fireball;
import engine.sprites.Shell;
import java.awt.Graphics;

public class Mario
extends MarioSprite {
    public boolean isLarge = false;
    public boolean isFire = false;
    public boolean onGround;
    public boolean wasOnGround;
    public boolean isDucking;
    public boolean canShoot;
    public boolean mayJump;
    public boolean[] actions = null;
    public int jumpTime = 0;
    private float xJumpSpeed;
    private float yJumpSpeed = 0.0f;
    private int invulnerableTime = 0;
    private float marioFrameSpeed = 0.0f;
    private boolean oldLarge = false;
    private boolean oldFire = false;
    private MarioImage graphics = null;
    private float xJumpStart = -100.0f;
    private final float GROUND_INERTIA = 0.89f;
    private final float AIR_INERTIA = 0.89f;
    private final int POWERUP_TIME = 3;

    public Mario(boolean bl, float f, float f2) {
        super(f + 8.0f, f2 + 15.0f, SpriteType.MARIO);
        this.width = 4;
        this.height = 24;
        if (bl) {
            this.graphics = new MarioImage(Assets.smallMario, 0);
        }
    }

    @Override
    public MarioSprite clone() {
        Mario mario = new Mario(false, this.x - 8.0f, this.y - 15.0f);
        mario.xa = this.xa;
        mario.ya = this.ya;
        mario.initialCode = this.initialCode;
        mario.width = this.width;
        mario.height = this.height;
        mario.facing = this.facing;
        mario.isLarge = this.isLarge;
        mario.isFire = this.isFire;
        mario.wasOnGround = this.wasOnGround;
        mario.onGround = this.onGround;
        mario.isDucking = this.isDucking;
        mario.canShoot = this.canShoot;
        mario.mayJump = this.mayJump;
        mario.actions = new boolean[this.actions.length];
        for (int i = 0; i < this.actions.length; ++i) {
            mario.actions[i] = this.actions[i];
        }
        mario.xJumpSpeed = this.xJumpSpeed;
        mario.yJumpSpeed = this.yJumpSpeed;
        mario.invulnerableTime = this.invulnerableTime;
        mario.jumpTime = this.jumpTime;
        mario.xJumpStart = this.xJumpStart;
        return mario;
    }

    private boolean move(float f, float f2) {
        while (f > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            f -= 8.0f;
        }
        while (f < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            f += 8.0f;
        }
        while (f2 > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            f2 -= 8.0f;
        }
        while (f2 < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            f2 += 8.0f;
        }
        boolean bl = false;
        if (f2 > 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            }
        }
        if (f2 < 0.0f) {
            if (this.isBlocking(this.x + f, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
        }
        if (f > 0.0f) {
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
        }
        if (f < 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
        }
        if (bl) {
            if (f < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (f > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (f2 < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.jumpTime = 0;
                this.ya = 0.0f;
            }
            if (f2 > 0.0f) {
                this.y = (int)((this.y - 1.0f) / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += f;
        this.y += f2;
        return true;
    }

    private boolean isBlocking(float f, float f2, float f3, float f4) {
        int n = (int)(f / 16.0f);
        int n2 = (int)(f2 / 16.0f);
        if (n == (int)(this.x / 16.0f) && n2 == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean bl = this.world.level.isBlocking(n, n2, f3, f4);
        int n3 = this.world.level.getBlock(n, n2);
        if (TileFeature.getTileType(n3).contains((Object)TileFeature.PICKABLE)) {
            this.world.addEvent(EventType.COLLECT, n3);
            this.collectCoin();
            this.world.level.setBlock(n, n2, 0);
        }
        if (bl && f4 < 0.0f) {
            this.world.bump(n, n2, this.isLarge);
        }
        return bl;
    }

    public void updateGraphics() {
        boolean bl;
        boolean bl2;
        if (!this.alive) {
            return;
        }
        if (this.world.pauseTimer > 0) {
            bl2 = this.world.pauseTimer / 2 % 2 == 0 ? this.oldLarge : this.isLarge;
            bl = this.world.pauseTimer / 2 % 2 == 0 ? this.oldFire : this.isFire;
        } else {
            bl2 = this.isLarge;
            bl = this.isFire;
        }
        if (bl2) {
            this.graphics.sheet = Assets.mario;
            if (bl) {
                this.graphics.sheet = Assets.fireMario;
            }
            this.graphics.originX = 16;
            this.graphics.originY = 31;
            this.graphics.height = 32;
            this.graphics.width = 32;
        } else {
            this.graphics.sheet = Assets.smallMario;
            this.graphics.originX = 8;
            this.graphics.originY = 15;
            this.graphics.height = 16;
            this.graphics.width = 16;
        }
        this.marioFrameSpeed += Math.abs(this.xa) + 5.0f;
        if (Math.abs(this.xa) < 0.5f) {
            this.marioFrameSpeed = 0.0f;
        }
        this.graphics.visible = (this.invulnerableTime / 2 & 1) == 0;
        this.graphics.flipX = this.facing == -1;
        int n = 0;
        if (bl2) {
            n = (int)(this.marioFrameSpeed / 20.0f) % 4;
            if (n == 3) {
                n = 1;
            }
            if (Math.abs(this.xa) > 10.0f) {
                n += 3;
            }
            if (!this.onGround) {
                n = Math.abs(this.xa) > 10.0f ? 6 : 5;
            }
        } else {
            n = (int)(this.marioFrameSpeed / 20.0f) % 2;
            if (Math.abs(this.xa) > 10.0f) {
                n += 2;
            }
            if (!this.onGround) {
                n = Math.abs(this.xa) > 10.0f ? 5 : 4;
            }
        }
        if (this.onGround && (this.facing == -1 && this.xa > 0.0f || this.facing == 1 && this.xa < 0.0f) && (this.xa > 1.0f || this.xa < -1.0f)) {
            int n2 = n = bl2 ? 8 : 7;
        }
        if (bl2 && this.isDucking) {
            n = 13;
        }
        this.graphics.index = n;
    }

    @Override
    public void update() {
        float f;
        if (!this.alive) {
            return;
        }
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        this.wasOnGround = this.onGround;
        float f2 = f = this.actions[MarioActions.SPEED.getValue()] ? 1.2f : 0.6f;
        if (this.onGround) {
            boolean bl = this.isDucking = this.actions[MarioActions.DOWN.getValue()] && this.isLarge;
        }
        this.height = this.isLarge ? (this.isDucking ? 12 : 24) : 12;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        if (this.actions[MarioActions.JUMP.getValue()] || this.jumpTime < 0 && !this.onGround) {
            if (this.jumpTime < 0) {
                this.xa = this.xJumpSpeed;
                this.ya = (float)(-this.jumpTime) * this.yJumpSpeed;
                ++this.jumpTime;
            } else if (this.onGround && this.mayJump) {
                this.xJumpSpeed = 0.0f;
                this.yJumpSpeed = -1.9f;
                this.jumpTime = 7;
                this.ya = (float)this.jumpTime * this.yJumpSpeed;
                this.onGround = false;
                if (!(this.isBlocking(this.x, this.y - 4.0f - (float)this.height, 0.0f, -4.0f) || this.isBlocking(this.x - (float)this.width, this.y - 4.0f - (float)this.height, 0.0f, -4.0f) || this.isBlocking(this.x + (float)this.width, this.y - 4.0f - (float)this.height, 0.0f, -4.0f))) {
                    this.xJumpStart = this.x;
                    this.world.addEvent(EventType.JUMP, 0);
                }
            } else if (this.jumpTime > 0) {
                this.xa += this.xJumpSpeed;
                this.ya = (float)this.jumpTime * this.yJumpSpeed;
                --this.jumpTime;
            }
        } else {
            this.jumpTime = 0;
        }
        if (this.actions[MarioActions.LEFT.getValue()] && !this.isDucking) {
            this.xa -= f;
            if (this.jumpTime >= 0) {
                this.facing = -1;
            }
        }
        if (this.actions[MarioActions.RIGHT.getValue()] && !this.isDucking) {
            this.xa += f;
            if (this.jumpTime >= 0) {
                this.facing = 1;
            }
        }
        if (this.actions[MarioActions.SPEED.getValue()] && this.canShoot && this.isFire && this.world.fireballsOnScreen < 2) {
            this.world.addSprite(new Fireball(this.graphics != null, this.x + (float)(this.facing * 6), this.y - 20.0f, this.facing));
        }
        this.canShoot = !this.actions[MarioActions.SPEED.getValue()];
        boolean bl = this.mayJump = this.onGround && !this.actions[MarioActions.JUMP.getValue()];
        if (Math.abs(this.xa) < 0.5f) {
            this.xa = 0.0f;
        }
        this.onGround = false;
        this.move(this.xa, 0.0f);
        this.move(0.0f, this.ya);
        if (!this.wasOnGround && this.onGround && this.xJumpStart >= 0.0f) {
            this.world.addEvent(EventType.LAND, 0);
            this.xJumpStart = -100.0f;
        }
        if (this.x < 0.0f) {
            this.x = 0.0f;
            this.xa = 0.0f;
        }
        if (this.x > (float)(this.world.level.exitTileX * 16)) {
            this.x = this.world.level.exitTileX * 16;
            this.xa = 0.0f;
            this.world.win();
        }
        this.ya *= 0.85f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya += 3.0f;
        }
        if (this.graphics != null) {
            this.updateGraphics();
        }
    }

    public void stomp(Enemy enemy) {
        if (!this.alive) {
            return;
        }
        float f = enemy.y - (float)(enemy.height / 2);
        this.move(0.0f, f - this.y);
        this.xJumpSpeed = 0.0f;
        this.yJumpSpeed = -1.9f;
        this.jumpTime = 8;
        this.ya = (float)this.jumpTime * this.yJumpSpeed;
        this.onGround = false;
        this.invulnerableTime = 1;
    }

    public void stomp(Shell shell) {
        if (!this.alive) {
            return;
        }
        float f = shell.y - (float)(shell.height / 2);
        this.move(0.0f, f - this.y);
        this.xJumpSpeed = 0.0f;
        this.yJumpSpeed = -1.9f;
        this.jumpTime = 8;
        this.ya = (float)this.jumpTime * this.yJumpSpeed;
        this.onGround = false;
        this.invulnerableTime = 1;
    }

    public void getHurt() {
        if (this.invulnerableTime > 0 || !this.alive) {
            return;
        }
        if (this.isLarge) {
            this.world.pauseTimer = 9;
            this.oldLarge = this.isLarge;
            this.oldFire = this.isFire;
            if (this.isFire) {
                this.isFire = false;
            } else {
                this.isLarge = false;
            }
            this.invulnerableTime = 32;
        } else if (this.world != null) {
            this.world.lose();
        }
    }

    public void getFlower() {
        if (!this.alive) {
            return;
        }
        if (!this.isFire) {
            this.world.pauseTimer = 9;
            this.oldFire = this.isFire;
            this.oldLarge = this.isLarge;
            this.isFire = true;
            this.isLarge = true;
        } else {
            this.collectCoin();
        }
    }

    public void getMushroom() {
        if (!this.alive) {
            return;
        }
        if (!this.isLarge) {
            this.world.pauseTimer = 9;
            this.oldFire = this.isFire;
            this.oldLarge = this.isLarge;
            this.isLarge = true;
        } else {
            this.collectCoin();
        }
    }

    public void kick(Shell shell) {
        if (!this.alive) {
            return;
        }
        this.invulnerableTime = 1;
    }

    public void stomp(BulletBill bulletBill) {
        if (!this.alive) {
            return;
        }
        float f = bulletBill.y - (float)(bulletBill.height / 2);
        this.move(0.0f, f - this.y);
        this.xJumpSpeed = 0.0f;
        this.yJumpSpeed = -1.9f;
        this.jumpTime = 8;
        this.ya = (float)this.jumpTime * this.yJumpSpeed;
        this.onGround = false;
        this.invulnerableTime = 1;
    }

    public String getMarioType() {
        if (this.isFire) {
            return "fire";
        }
        if (this.isLarge) {
            return "large";
        }
        return "small";
    }

    public void collect1Up() {
        if (!this.alive) {
            return;
        }
        ++this.world.lives;
    }

    public void collectCoin() {
        if (!this.alive) {
            return;
        }
        ++this.world.coins;
        if (this.world.coins % 100 == 0) {
            this.collect1Up();
        }
    }

    @Override
    public void render(Graphics graphics) {
        super.render(graphics);
        this.graphics.render(graphics, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }
}

