/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.SpriteState;
import agents.andySloane.WorldState;

public class ShellState
extends SpriteState {
    public boolean carried = false;
    public boolean onGround = false;
    public boolean flyDeath = false;
    public static final float width = 4.0f;
    public static final float height = 12.0f;

    @Override
    public final float height() {
        return 12.0f;
    }

    @Override
    public SpriteState clone() {
        ShellState shellState = new ShellState(this.x, this.y, false);
        shellState.xa = this.xa;
        shellState.ya = this.ya;
        shellState.facing = this.facing;
        shellState.deadTime = this.deadTime;
        shellState.carried = this.carried;
        shellState.onGround = this.onGround;
        shellState.flyDeath = this.flyDeath;
        return shellState;
    }

    @Override
    public final boolean dead() {
        return this.deadTime != 0;
    }

    ShellState(float f, float f2, boolean bl) {
        this.x = f;
        this.y = f2;
        this.type = 13;
        this.xa = 0.0f;
        this.ya = bl ? -5.0f : -2.25f;
        this.facing = 0;
    }

    @Override
    public boolean move(WorldState worldState) {
        if (this.carried) {
            worldState.checkShellCollide(this);
            return false;
        }
        if (this.deadTime > 0) {
            --this.deadTime;
            if (this.deadTime == 0) {
                this.deadTime = 1;
                return false;
            }
            if (this.flyDeath) {
                this.x += this.xa;
                this.y += this.ya;
                this.ya = (float)((double)this.ya * 0.95);
                this.ya += 1.0f;
            }
            return true;
        }
        if (this.xa > 2.0f) {
            this.facing = 1;
        } else if (this.xa < -2.0f) {
            this.facing = -1;
        }
        if (this.facing != 0) {
            worldState.checkShellCollide(this);
        }
        if (!this.move(this.xa, 0.0f, worldState)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya, worldState);
        this.ya *= 0.85f;
        this.xa *= 0.89f;
        if (!this.onGround) {
            this.ya += 2.0f;
        }
        return true;
    }

    @Override
    public void resync(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.xa = f - f3;
        this.facing = this.xa == 0.0f ? 0 : (this.xa < 0.0f ? -1 : 1);
        this.ya = (f2 - f4) * 0.85f;
        if (!this.onGround) {
            this.ya += 2.0f;
        }
    }

    private boolean move(float f, float f2, WorldState worldState) {
        while (f > 8.0f) {
            if (!this.move(8.0f, 0.0f, worldState)) {
                return false;
            }
            f -= 8.0f;
        }
        while (f < -8.0f) {
            if (!this.move(-8.0f, 0.0f, worldState)) {
                return false;
            }
            f += 8.0f;
        }
        while (f2 > 8.0f) {
            if (!this.move(0.0f, 8.0f, worldState)) {
                return false;
            }
            f2 -= 8.0f;
        }
        while (f2 < -8.0f) {
            if (!this.move(0.0f, -8.0f, worldState)) {
                return false;
            }
            f2 += 8.0f;
        }
        boolean bl = false;
        if (f2 > 0.0f) {
            if (this.isBlocking(this.x + f - 4.0f, this.y + f2, f, 0.0f, worldState)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + 4.0f, this.y + f2, f, 0.0f, worldState)) {
                bl = true;
            } else if (this.isBlocking(this.x + f - 4.0f, this.y + f2 + 1.0f, f, f2, worldState)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + 4.0f, this.y + f2 + 1.0f, f, f2, worldState)) {
                bl = true;
            }
        }
        if (f2 < 0.0f) {
            if (this.isBlocking(this.x + f, this.y + f2 - 12.0f, f, f2, worldState)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f - 4.0f, this.y + f2 - 12.0f, f, f2, worldState)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f + 4.0f, this.y + f2 - 12.0f, f, f2, worldState)) {
                bl = true;
            }
        }
        if (f > 0.0f) {
            if (this.isBlocking(this.x + f + 4.0f, this.y + f2 - 12.0f, f, f2, worldState)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + 4.0f, this.y + f2 - 6.0f, f, f2, worldState)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + 4.0f, this.y + f2, f, f2, worldState)) {
                bl = true;
            }
        }
        if (f < 0.0f) {
            if (this.isBlocking(this.x + f - 4.0f, this.y + f2 - 12.0f, f, f2, worldState)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - 4.0f, this.y + f2 - 6.0f, f, f2, worldState)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - 4.0f, this.y + f2, f, f2, worldState)) {
                bl = true;
            }
        }
        if (bl) {
            if (f < 0.0f) {
                this.x = (float)((int)((this.x - 4.0f) / 16.0f) * 16) + 4.0f;
                this.xa = 0.0f;
            }
            if (f > 0.0f) {
                this.x = (float)((int)((this.x + 4.0f) / 16.0f + 1.0f) * 16) - 4.0f - 1.0f;
                this.xa = 0.0f;
            }
            if (f2 < 0.0f) {
                this.y = (float)((int)((this.y - 12.0f) / 16.0f) * 16) + 12.0f;
                this.ya = 0.0f;
            }
            if (f2 > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += f;
        this.y += f2;
        return true;
    }

    private boolean isBlocking(float f, float f2, float f3, float f4, WorldState worldState) {
        int n = (int)(f / 16.0f);
        int n2 = (int)(f2 / 16.0f);
        if (n == (int)(this.x / 16.0f) && n2 == (int)(this.y / 16.0f)) {
            return false;
        }
        return worldState.isBlocking(n, n2, f3, f4);
    }

    @Override
    public SpriteState stomp(WorldState worldState, MarioState marioState) {
        ShellState shellState = (ShellState)this.clone();
        if (this.facing != 0) {
            shellState.facing = 0;
            shellState.xa = 0.0f;
        } else {
            shellState.facing = marioState.facing;
        }
        return shellState;
    }

    @Override
    public WorldState collideCheck(WorldState worldState, MarioState marioState) {
        if (this.deadTime != 0) {
            return worldState;
        }
        float f = marioState.x - this.x;
        float f2 = marioState.y - this.y;
        float f3 = this.height();
        if (f > -12.0f && f < 12.0f && f2 > -f3 && f2 < marioState.height()) {
            if (!(this.spiky() || !(marioState.ya > 0.0f) || !(f2 <= 0.0f) || marioState.onGround && marioState.wasOnGround)) {
                worldState = worldState.stomp(this, marioState);
            } else if (this.facing != 0) {
                marioState.getHurt();
            } else {
                worldState.kick(this);
                this.facing = marioState.facing;
            }
        }
        return worldState;
    }
}

