cd ../../src

# ELECTRA
# Script for training all models on MRPC, COLA, SST2-10% and CoNLL-2003 for mixup
# train - MSD loss, no SN
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.1 mixup.lam2\=0.006 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=11 mixup.omega\=0.5 training.per_device_train_batch_size\=8 mixup.self_ensembling\=True +training.weight_decay\=0.01 +ue.use_paper_version\=True' task_configs=mrpc_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/mrpc
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.1 mixup.lam2\=0.006 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=7 mixup.omega\=0.55 training.per_device_train_batch_size\=64 mixup.self_ensembling\=True +training.weight_decay\=0.01 +ue.use_paper_version\=True' task_configs=cola_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/cola
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.1 mixup.lam2\=0.006 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=7 mixup.omega\=0.55 training.per_device_train_batch_size\=64 mixup.self_ensembling\=True +training.weight_decay\=0.01 +ue.use_paper_version\=True' task_configs=sst2_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/sst2
# CoNLL
# To reproduce paper results, run conll with torch 1.7.1 with following args
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py script=run_conll2003.py task_configs=conll2003_mixup.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False mixup.lam1\=0.008 mixup.lam2\=0.008 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=13 mixup.omega\=0.75 training.per_device_train_batch_size\=8 mixup.self_ensembling\=True +training.weight_decay\=0.1 +ue.use_paper_version\=True' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[0,1,2,3,4,5] output_dir='../workdir/run_train_models/mixup_electra_fix_repro_fix/conll'


# MC maha
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False +ue.use_paper_version\=True' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last +ue.use_paper_version\=True' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False +ue.use_paper_version\=True' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last +ue.use_paper_version\=True' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False +ue.use_paper_version\=True' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last +ue.use_paper_version\=True' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/sst2/msd/last'

# To reproduce paper results, run conll with torch 1.7.1 with following args
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py script=run_conll2003.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra_fix_repro_fix/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=last data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False +ue.use_paper_version\=True' cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra_fix_repro_fix/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py script=run_conll2003.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra_fix_repro_fix/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False +ue.use_paper_version\=True' cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra_fix_repro_fix/conll/mixup/all'



# Finally, calc metrics
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/mrpc/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/mrpc/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/cola/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/cola/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/sst2/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/sst2/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra_fix_repro_fix/conll/mixup/last' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra_fix_repro_fix/conll/mixup/all' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/conll/mixup/all'







