## Images uncertainty

Experiments on CIFAR-100/Imagenet (see `experiments`)

Following approaches:
- Maximum probability / entropy
- Dropout 
- Test-time augmentation (TTA)
- Deterministic data uncertainty (DDU)
- Data uncertainty quantification (DUQ)
- Ensemble
- Non-parametric kernel based uncertainty estimation (NUQ)

### CIFAR-100 
You need pre-trained model for both CIFAR-100 and ImageNet. You can train them 
```sh
python experiments/cifar_train.py --data-seed=42 --net=resnet50_spectral
```
For cifar we trained models with three different train/val splits (data-seed 42, 43 and 44).

To test we used three OOD datasets (lsun, svhn and smooth). There are experiments with different approaches in `experiment` folder. For each you should set data-seed and ood-name

```shell
python experiments/cifar_nuq.py --gpu --ood-name=svhn --data-seed=42 --net=resnet50_spectral
```

### ImageNet
To train model for imagenet you need downloaded train and val datasets in <imagenet_path>. Then you could launch the training with spectral normalization
```shell
python image_uncertainty/imagenet/train.py <imagenet_path> --arch=spectral
```

After you have a model, you could benchmark different OOD methods with code from `experiments` folder. We use imagenet-o and imagenet-r as ood datasets, you need to download them manually to some <ood_path>. We precalculate embeddings in some experiments to re-use them.

```shell
python experiments/imagenet_embeddings.py --ood-name='imagenet_o' --ood-folder=<ood_path> --x-type='logits' --net='spectral'
python experiments/imagenet_nuq.py --ood-name=imagenet_o 
```

