(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    340842,       6501]
NotebookOptionsPosition[    287132,       5520]
NotebookOutlinePosition[    331627,       6359]
CellTagsIndexPosition[    331584,       6356]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["We reconstruct our three-state example:", "Text",
 CellChangeTimes->{{3.848632720901607*^9, 3.848632738020585*^9}, {
  3.8486340159286547`*^9, 3.848634057462323*^9}, {3.8489104946422167`*^9, 
  3.8489105216064568`*^9}, {3.851480403366922*^9, 3.851480408057653*^9}, {
  3.851481743926244*^9, 3.851481752203232*^9}, {3.8514817857825737`*^9, 
  3.851481788347879*^9}, {3.8514819225717382`*^9, 
  3.851481929700445*^9}},ExpressionUUID->"051258ff-3da9-473b-961b-\
d8991c9fcfd8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", "0.25", ",", " ", "0.5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0.25", ",", " ", "0.25", ",", " ", "0.5"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"P", " ", "//", "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{"pi", "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"Eigenvectors", "[", 
      RowBox[{"P", "\[Transpose]"}], "]"}], "]"}], "/", 
    RowBox[{"Total", "[", 
     RowBox[{"First", "[", 
      RowBox[{"Eigenvectors", "[", 
       RowBox[{"P", "\[Transpose]"}], "]"}], "]"}], "]"}]}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"epsilon", "=", "0.00"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dm", " ", "=", " ", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "/", "2"}], ",", " ", 
      RowBox[{"p", "/", "2"}], ",", " ", 
      RowBox[{"1", "-", "p"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", " ", ",", "1"}], "}"}], "\[Transpose]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.848910053020782*^9, 3.848910152351247*^9}, {
   3.848910308449559*^9, 3.84891030984326*^9}, 3.851936569863081*^9, {
   3.852099989705491*^9, 3.852099993113016*^9}, {3.852100180773879*^9, 
   3.852100184750564*^9}, {3.8521047252967367`*^9, 3.852104730304134*^9}, {
   3.8521059769413137`*^9, 3.8521059804914007`*^9}, {3.8521565985481377`*^9, 
   3.85215660216363*^9}, {3.8521589837608356`*^9, 3.852159008414275*^9}, {
   3.852161506680114*^9, 3.852161510315401*^9}, {3.852161601831725*^9, 
   3.852161605763768*^9}, {3.852169596324563*^9, 3.8521695997861156`*^9}, {
   3.852176065934104*^9, 3.852176069373691*^9}, {3.852176637105061*^9, 
   3.8521766402586803`*^9}, {3.8591327277422256`*^9, 
   3.8591327438894787`*^9}, {3.859132774554153*^9, 3.8591328052769833`*^9}, {
   3.8591331191435947`*^9, 3.859133129811833*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.25`", "0.25`", "0.5`"},
     {"0.25`", "0.25`", "0.5`"},
     {"0.25`", "0.25`", "0.5`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.859133130855592*^9},
 CellLabel->
  "Out[2]//TraditionalForm=",ExpressionUUID->"feef8f54-291c-4e49-be5c-\
fd6eadac3dee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.25`", ",", "0.2499999999999999`", ",", "0.5`"}], "}"}]], "Output",\

 CellChangeTimes->{3.859133130865406*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"dd7a6186-7cdc-47a0-ab85-f31fc07604e9"]
}, Open  ]],

Cell["\<\
We compute the reference emphasis, that is, the emphasis values that must be \
expressible as a linear function of Phi. (The value at convergence is going \
to be proportional to this.)
On-policy, this must be exactly 1. Off-policy, it should be equal to whatever \
reweighting necessary to become 1:\
\>", "Text",
 CellChangeTimes->{{3.852168697059846*^9, 3.8521687127777348`*^9}, {
  3.852168745125463*^9, 3.852168751341105*^9}, {3.852169390675466*^9, 
  3.852169435156282*^9}, {3.852175336710228*^9, 3.85217536727772*^9}, {
  3.859132863613144*^9, 
  3.859132889724229*^9}},ExpressionUUID->"f00c6723-8a59-4ce8-b39a-\
8a30f27313b1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"refEmph", "=", 
   RowBox[{"pi", ".", 
    RowBox[{"Inverse", "[", "Dm", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"offpolicy", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"refEmph", " ", "/.", 
   RowBox[{"{", 
    RowBox[{"p", "->", "offpolicy"}], "}"}]}], " ", "//", 
  "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"refEmph", " ", "/.", 
   RowBox[{"{", 
    RowBox[{"p", "->", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], " ", "//", 
  "TraditionalForm"}]}], "Input",
 CellChangeTimes->{{3.852168847597501*^9, 3.852168863779334*^9}, {
   3.8521694427735777`*^9, 3.852169443547037*^9}, 3.8521695218198547`*^9, {
   3.852169632059041*^9, 3.852169632746798*^9}, {3.852175488000198*^9, 
   3.852175511207342*^9}, {3.852175877502344*^9, 3.852175879358439*^9}, {
   3.852176116241047*^9, 3.852176117168385*^9}, {3.852178096008903*^9, 
   3.852178104974264*^9}, {3.852178155324128*^9, 3.852178158817079*^9}, {
   3.85217832389223*^9, 3.852178332726877*^9}, {3.852178404593416*^9, 
   3.852178416941484*^9}, {3.8521788004111233`*^9, 3.852178810485631*^9}, {
   3.852178905278187*^9, 3.8521789063192053`*^9}, {3.852181813576111*^9, 
   3.852181813898203*^9}, {3.859132845189004*^9, 3.859132856363162*^9}, 
   3.859132897638698*^9},
 CellLabel->"In[10]:=",ExpressionUUID->"1ff5a37c-b6be-49fa-8a49-fb819b60f456"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "1.2499999999999998`", ",", "1.2499999999999991`", ",", 
    "0.8333333333333333`"}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.852168865287053*^9, 3.8521694440365334`*^9, 3.852169522486887*^9, {
   3.852169604024392*^9, 3.852169633243826*^9}, 3.852169677750341*^9, 
   3.852170048099779*^9, {3.8521700969278593`*^9, 3.852170119883254*^9}, {
   3.852175489018203*^9, 3.852175512131504*^9}, 3.8521758802504187`*^9, 
   3.8521759328273*^9, {3.8521760911280737`*^9, 3.852176117554398*^9}, 
   3.852176538988818*^9, 3.8521766596514378`*^9, 3.852177702053561*^9, 
   3.852177931545439*^9, 3.852178105486562*^9, {3.852178155849531*^9, 
   3.852178159256562*^9}, 3.852178243032391*^9, {3.8521783254819927`*^9, 
   3.852178333178473*^9}, 3.852178417415824*^9, 3.852178482960429*^9, {
   3.852178802991468*^9, 3.852178838720818*^9}, {3.852178907061088*^9, 
   3.852178922149086*^9}, 3.852181449394849*^9, 3.85218151235174*^9, {
   3.8521817364819593`*^9, 3.8521817529505367`*^9}, 3.8521818142748117`*^9, 
   3.8521819051575413`*^9, 3.85218966234301*^9, 3.852353740580661*^9, 
   3.859133133646286*^9},
 CellLabel->
  "Out[12]//TraditionalForm=",ExpressionUUID->"d2174db2-3461-4ac7-8ead-\
c3e64f1187e1"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"1.`", ",", "0.9999999999999996`", ",", "1.`"}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.852168865287053*^9, 3.8521694440365334`*^9, 3.852169522486887*^9, {
   3.852169604024392*^9, 3.852169633243826*^9}, 3.852169677750341*^9, 
   3.852170048099779*^9, {3.8521700969278593`*^9, 3.852170119883254*^9}, {
   3.852175489018203*^9, 3.852175512131504*^9}, 3.8521758802504187`*^9, 
   3.8521759328273*^9, {3.8521760911280737`*^9, 3.852176117554398*^9}, 
   3.852176538988818*^9, 3.8521766596514378`*^9, 3.852177702053561*^9, 
   3.852177931545439*^9, 3.852178105486562*^9, {3.852178155849531*^9, 
   3.852178159256562*^9}, 3.852178243032391*^9, {3.8521783254819927`*^9, 
   3.852178333178473*^9}, 3.852178417415824*^9, 3.852178482960429*^9, {
   3.852178802991468*^9, 3.852178838720818*^9}, {3.852178907061088*^9, 
   3.852178922149086*^9}, 3.852181449394849*^9, 3.85218151235174*^9, {
   3.8521817364819593`*^9, 3.8521817529505367`*^9}, 3.8521818142748117`*^9, 
   3.8521819051575413`*^9, 3.85218966234301*^9, 3.852353740580661*^9, 
   3.859133133662595*^9},
 CellLabel->
  "Out[13]//TraditionalForm=",ExpressionUUID->"7853423b-1664-46e0-bdf5-\
aabd01602fbd"]
}, Open  ]],

Cell["\<\
We wish to learn the value function when fed TD updates at the off-policy \
distribution {0.2, 0.2, 0.6} (p=0.4). For reference, the on-policy \
distribution is {1/4,1/4,1/2} (p-0.4).
At p=.4, the emphasis model will converge to {5/4,5/4,5/6}. To ensure this \
value is representable, we choose Phi:\
\>", "Text",
 CellChangeTimes->{{3.8519941280485687`*^9, 3.851994218220345*^9}, {
  3.852176683276722*^9, 3.852176698309019*^9}, {3.8521767405952387`*^9, 
  3.85217675383286*^9}, {3.852176908556479*^9, 3.852176949722599*^9}, {
  3.852177015613921*^9, 3.8521770606217003`*^9}, {3.8521771307714567`*^9, 
  3.8521771465165453`*^9}, {3.852177195761397*^9, 3.8521772868467197`*^9}, {
  3.8591329625608664`*^9, 
  3.8591330758293877`*^9}},ExpressionUUID->"8f0e7ec0-96c9-4ff0-981f-\
a9c6d167f773"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Phi", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"5", "/", "4"}], ",", " ", "0"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", " ", 
      RowBox[{
       RowBox[{"-", ".01"}], "*", 
       RowBox[{"5", "/", "4"}]}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"5", "/", "6"}], "/", "2"}], "+", "epsilon"}], ",", " ", 
      RowBox[{
       RowBox[{"-", "0.01"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"5", "/", "6"}], "/", "2"}], "-", "epsilon"}], ")"}]}]}], 
     "}"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"k", "=", "2"}]}], "Input",
 CellChangeTimes->{{3.848910671037572*^9, 3.848910791077985*^9}, {
   3.8489755879527397`*^9, 3.848975590878828*^9}, {3.8489772280066433`*^9, 
   3.848977230512291*^9}, {3.851499273450891*^9, 3.851499275818809*^9}, {
   3.851992161036668*^9, 3.8519921661456127`*^9}, {3.851994075089569*^9, 
   3.851994078995597*^9}, {3.851994346652245*^9, 3.851994351606996*^9}, {
   3.852156607087414*^9, 3.852156611130437*^9}, {3.852169656325008*^9, 
   3.8521696684434423`*^9}, {3.852170038396236*^9, 3.852170040547649*^9}, {
   3.852170111730172*^9, 3.85217011365606*^9}, {3.8521758925669727`*^9, 
   3.852175902988044*^9}, {3.852177526177519*^9, 3.852177528633943*^9}, 
   3.8521776559217463`*^9, {3.8521781871415167`*^9, 3.852178195209134*^9}, {
   3.852178373537251*^9, 3.852178388058112*^9}, {3.8521788285339813`*^9, 
   3.852178830345829*^9}, {3.852178915154496*^9, 3.852178917370994*^9}, {
   3.85218123759792*^9, 3.852181243340987*^9}, {3.8521813055404577`*^9, 
   3.852181323776546*^9}, {3.852181433570129*^9, 3.8521814412305927`*^9}, {
   3.852181503721355*^9, 3.8521815073219757`*^9}, {3.852181844550397*^9, 
   3.852181894944234*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"258ff660-f673-4e34-9427-29cf1827dcd4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["5", "4"], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "0.0125`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4166666666666667`", ",", 
     RowBox[{"-", "0.004166666666666667`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.851992134107095*^9, 3.85199216756069*^9, {3.851994080517061*^9, 
   3.851994104862863*^9}, {3.8519943383208103`*^9, 3.851994366719943*^9}, {
   3.851994467660931*^9, 3.851994471668935*^9}, 3.851994694726617*^9, 
   3.851998179482315*^9, 3.8520071885820217`*^9, 3.8520072269331303`*^9, 
   3.852007925117104*^9, 3.8520079584381323`*^9, 3.8520090904935637`*^9, 
   3.8521001891800137`*^9, {3.8521047194625874`*^9, 3.8521047379532423`*^9}, {
   3.8521057994897633`*^9, 3.852105843107996*^9}, 3.852105985586934*^9, {
   3.852156611585186*^9, 3.852156616442457*^9}, 3.852158451564645*^9, 
   3.852159462506012*^9, 3.852160761597577*^9, 3.852161543846841*^9, 
   3.85216172988922*^9, {3.8521666990666103`*^9, 3.852166712068419*^9}, 
   3.8521671049666557`*^9, 3.852167351803091*^9, 3.852168664990546*^9, 
   3.852169604087973*^9, {3.852169664027492*^9, 3.852169677789369*^9}, {
   3.852170040927327*^9, 3.852170048136475*^9}, {3.852170096966385*^9, 
   3.8521701199253263`*^9}, 3.852175630656745*^9, {3.85217590364117*^9, 
   3.852175932880921*^9}, 3.8521761276138687`*^9, 3.852176539041114*^9, 
   3.852177533040729*^9, 3.852177658082288*^9, 3.852177702111815*^9, 
   3.8521779316023808`*^9, 3.852178197182514*^9, 3.8521782430923023`*^9, {
   3.8521783782521887`*^9, 3.852178388388134*^9}, 3.852178483023118*^9, {
   3.852178830860132*^9, 3.852178838788102*^9}, {3.852178917805725*^9, 
   3.852178922217135*^9}, {3.852181286162985*^9, 3.852181326230797*^9}, {
   3.8521814419915867`*^9, 3.852181449450941*^9}, {3.852181508002157*^9, 
   3.8521815124063377`*^9}, {3.8521817365318537`*^9, 3.852181753002719*^9}, {
   3.852181870294919*^9, 3.852181905215433*^9}, 3.8521896624062653`*^9, 
   3.852352753551504*^9, 3.8523537406184607`*^9, 3.8591331361855993`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"53e5048b-0071-46f7-8423-0900a5e579d9"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{
  3.851992134107095*^9, 3.85199216756069*^9, {3.851994080517061*^9, 
   3.851994104862863*^9}, {3.8519943383208103`*^9, 3.851994366719943*^9}, {
   3.851994467660931*^9, 3.851994471668935*^9}, 3.851994694726617*^9, 
   3.851998179482315*^9, 3.8520071885820217`*^9, 3.8520072269331303`*^9, 
   3.852007925117104*^9, 3.8520079584381323`*^9, 3.8520090904935637`*^9, 
   3.8521001891800137`*^9, {3.8521047194625874`*^9, 3.8521047379532423`*^9}, {
   3.8521057994897633`*^9, 3.852105843107996*^9}, 3.852105985586934*^9, {
   3.852156611585186*^9, 3.852156616442457*^9}, 3.852158451564645*^9, 
   3.852159462506012*^9, 3.852160761597577*^9, 3.852161543846841*^9, 
   3.85216172988922*^9, {3.8521666990666103`*^9, 3.852166712068419*^9}, 
   3.8521671049666557`*^9, 3.852167351803091*^9, 3.852168664990546*^9, 
   3.852169604087973*^9, {3.852169664027492*^9, 3.852169677789369*^9}, {
   3.852170040927327*^9, 3.852170048136475*^9}, {3.852170096966385*^9, 
   3.8521701199253263`*^9}, 3.852175630656745*^9, {3.85217590364117*^9, 
   3.852175932880921*^9}, 3.8521761276138687`*^9, 3.852176539041114*^9, 
   3.852177533040729*^9, 3.852177658082288*^9, 3.852177702111815*^9, 
   3.8521779316023808`*^9, 3.852178197182514*^9, 3.8521782430923023`*^9, {
   3.8521783782521887`*^9, 3.852178388388134*^9}, 3.852178483023118*^9, {
   3.852178830860132*^9, 3.852178838788102*^9}, {3.852178917805725*^9, 
   3.852178922217135*^9}, {3.852181286162985*^9, 3.852181326230797*^9}, {
   3.8521814419915867`*^9, 3.852181449450941*^9}, {3.852181508002157*^9, 
   3.8521815124063377`*^9}, {3.8521817365318537`*^9, 3.852181753002719*^9}, {
   3.852181870294919*^9, 3.852181905215433*^9}, 3.8521896624062653`*^9, 
   3.852352753551504*^9, 3.8523537406184607`*^9, 3.859133136193534*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"bc1f926c-d3df-427e-8cd9-f43e083e5ad5"]
}, Open  ]],

Cell["We verify that the representation error is small:", "Text",
 CellChangeTimes->{{3.852177538906336*^9, 
  3.852177549570195*^9}},ExpressionUUID->"75b8c72f-2d74-4617-8089-\
b0f54a5a3590"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Phi", ".", 
   RowBox[{"LeastSquares", "[", 
    RowBox[{"Phi", ",", "refEmph"}], "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{"p", "->", "offpolicy"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.852177551554237*^9, 3.852177622766098*^9}, {
   3.852177671914974*^9, 3.8521776749230423`*^9}, {3.852178208395112*^9, 
   3.8521782247413282`*^9}, 3.8521784242785273`*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"ff4ec1e0-552c-42d3-8901-660991effba0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2499999999999998`", ",", "1.2499999999999998`", ",", 
   "0.833333333333333`"}], "}"}]], "Output",
 CellChangeTimes->{{3.8521775733813267`*^9, 3.8521776237989283`*^9}, {
   3.85217766008213*^9, 3.8521777021630907`*^9}, 3.852177931649749*^9, {
   3.852178201363284*^9, 3.85217824312969*^9}, 3.852178393144815*^9, 
   3.85217842469221*^9, 3.852178483070527*^9, {3.852178833210894*^9, 
   3.852178838842688*^9}, 3.852178922280787*^9, {3.852181295053602*^9, 
   3.852181312192605*^9}, {3.852181445198039*^9, 3.852181449498269*^9}, 
   3.8521815124521427`*^9, {3.852181736574128*^9, 3.852181753025519*^9}, {
   3.852181876378553*^9, 3.852181905261245*^9}, 3.852189662462989*^9, 
   3.852353740656726*^9, 3.859133137786845*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"662f0c57-ed97-42cc-a529-286e287b1e28"]
}, Open  ]],

Cell["\<\
We can represent this correctly! The value of the emphasis function at the \
on-policy distribution is:\
\>", "Text",
 CellChangeTimes->{{3.852177679451488*^9, 3.852177688713854*^9}, {
  3.859133148922172*^9, 
  3.859133160196782*^9}},ExpressionUUID->"6f12a90b-2c19-4a0a-b8b2-\
949bc36f43b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", " ", 
  RowBox[{"i", "/", 
   RowBox[{"(", 
    RowBox[{"1", "-", "gamma"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.852008080973694*^9, 3.852008092881859*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"1e352f5e-57ab-49fe-a1f7-cd950e290ff8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "99.99999999999991`", ",", "99.99999999999991`", ",", 
   "99.99999999999991`"}], "}"}]], "Output",
 CellChangeTimes->{{3.852008084554575*^9, 3.852008093159506*^9}, 
   3.8520090907613163`*^9, 3.8521001893098497`*^9, {3.852104719633233*^9, 
   3.8521047381030483`*^9}, {3.8521057996576777`*^9, 3.8521058432687674`*^9}, 
   3.852105985753976*^9, 3.852156616609021*^9, 3.852158451745554*^9, 
   3.852159462723132*^9, 3.852160761743033*^9, 3.8521615440299683`*^9, 
   3.852161730048801*^9, {3.852166699223589*^9, 3.852166712228801*^9}, 
   3.852167105163372*^9, 3.852167352002964*^9, 3.8521696042481728`*^9, 
   3.85216967794578*^9, 3.852170048292815*^9, {3.852170097076271*^9, 
   3.852170120009592*^9}, 3.8521759329976673`*^9, 3.8521765391791677`*^9, 
   3.852177702294581*^9, 3.85217793178413*^9, 3.852178243240076*^9, 
   3.8521784831822147`*^9, 3.852178838975314*^9, 3.852178922416009*^9, 
   3.852181449601584*^9, 3.8521815125553417`*^9, {3.852181736664468*^9, 
   3.852181753128578*^9}, 3.852181905362215*^9, 3.8521896625931664`*^9, 
   3.8523537407641068`*^9, 3.859133143223159*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"f8b7c506-8c6b-434a-84c3-82b192987fdf"]
}, Open  ]],

Cell["(For checking) We compute the value of the follow-on trace:", "Text",
 CellChangeTimes->{{3.852164972463965*^9, 3.852164988464596*^9}, {
  3.852165206997373*^9, 3.852165210246171*^9}, {3.852165280385973*^9, 
  3.852165281100329*^9}, {3.859133166868449*^9, 
  3.859133170299049*^9}},ExpressionUUID->"a91e696a-ae82-4d6c-98d2-\
7746c33acde2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", 
    RowBox[{"gamma", "*", "P"}]}], "]"}], ".", "i"}]], "Input",
 CellChangeTimes->{{3.852165211436019*^9, 3.8521652383759537`*^9}, {
  3.852165305649651*^9, 3.852165311294758*^9}, {3.852165690882169*^9, 
  3.852165713844268*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"9280df20-363a-4471-be59-cab979016558"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "99.9999999999998`", ",", "99.9999999999998`", ",", "99.9999999999998`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852165238920216*^9, {3.85216528332176*^9, 3.852165311698906*^9}, {
   3.852165693239012*^9, 3.852165714540681*^9}, {3.8521666992512712`*^9, 
   3.852166712260893*^9}, 3.852167105193941*^9, 3.852167352036171*^9, 
   3.852169604281901*^9, 3.852169677978894*^9, 3.852170048324935*^9, {
   3.852170097109516*^9, 3.8521701200495*^9}, 3.8521759330378036`*^9, 
   3.85217653922878*^9, 3.85217770234452*^9, 3.8521779318265944`*^9, 
   3.852178243274303*^9, 3.852178483225998*^9, 3.85217883901858*^9, 
   3.852178922459797*^9, 3.8521814496364*^9, 3.852181512588356*^9, {
   3.8521817366963053`*^9, 3.852181753162003*^9}, 3.8521819053970957`*^9, 
   3.852189662634797*^9, 3.852353740828998*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"26c30dff-2ced-4365-92f5-4f473eea1a0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part 1: GEM", "Section",
 CellChangeTimes->{{3.850702730932063*^9, 3.850702746241844*^9}, 
   3.851481918666051*^9, {3.851492131817268*^9, 3.851492132208036*^9}, {
   3.851497614917158*^9, 
   3.8514976152825317`*^9}},ExpressionUUID->"24d22338-4f57-408e-9bc5-\
fd8119da790b"],

Cell["We first use the GEM method to find the emphasis model:", "Text",
 CellChangeTimes->{{3.849223622968721*^9, 3.849223658368297*^9}, {
  3.8514819545065823`*^9, 3.851481962543515*^9}, {3.851497620666313*^9, 
  3.8514976312396584`*^9}, {3.852165848725697*^9, 
  3.8521658492164507`*^9}},ExpressionUUID->"3fd1be11-f9e6-48ba-b827-\
bfb37d630993"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", 
      RowBox[{"gamma", "*", 
       RowBox[{"P", "\[Transpose]"}]}]}], ")"}], ".", "Dm", ".", "Phi"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Cm", " ", "=", " ", 
   RowBox[{
    RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "Phi"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eta", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", " ", "=", " ", 
   RowBox[{"ArrayFlatten", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Cm", ",", " ", "A"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"A", "\[Transpose]"}]}], ",", " ", 
        RowBox[{"eta", "*", 
         RowBox[{"IdentityMatrix", "[", "k", "]"}]}]}], "}"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hbar", " ", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "i"}], ",", " ", "0", 
      ",", " ", "0", ",", " ", "0"}], "}"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8514820039399233`*^9, 3.851482029586948*^9}, {
   3.851482088491589*^9, 3.851482138429265*^9}, 3.852007916243298*^9, {
   3.852007948526436*^9, 3.8520079497442617`*^9}, {3.859133187229753*^9, 
   3.8591332414901247`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"d462b47b-84de-4678-a6a6-c6a743e09edc"],

Cell["Set up the G and h matrices:", "Text",
 CellChangeTimes->{{3.8514824400644817`*^9, 3.851482469440653*^9}, 
   3.851936587744082*^9, 
   3.852159975741766*^9},ExpressionUUID->"fed368d0-9bab-44b5-8f04-\
445405001d9e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"G", "//", "TraditionalForm"}], "\[IndentingNewLine]", 
 RowBox[{"hbar", " ", "//", " ", "TraditionalForm"}]}], "Input",
 CellChangeTimes->{{3.8521607310469933`*^9, 3.85216073462501*^9}, {
  3.859133219867495*^9, 3.859133239599299*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"f6efe44e-2ff4-44be-842d-59d4a9eb6e29"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"0.17361111111111113`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "+", 
       RowBox[{
        FractionBox["5", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"5", " ", "p"}], "8"], "+", "0.`"}], ")"}]}], "+", "0.`"}], 
      RowBox[{"0.`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.0017361111111111112`", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}]}], 
      RowBox[{
       RowBox[{"0.4166666666666667`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.09895833333333334`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["5", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.36718749999999994`", " ", "p"}], "+", "0.`"}], ")"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.004166666666666667`"}], " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.09895833333333334`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"0.0125`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.2578125`", " ", "p"}]}], ")"}]}]}]},
     {
      RowBox[{
       RowBox[{"0.4166666666666667`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.004166666666666667`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}], "+", "0.`"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.004166666666666667`"}], " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.004166666666666667`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"0.0125`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.00625`", " ", "p"}]}], ")"}]}], "+", "0.`"}], 
      RowBox[{
       RowBox[{"0.4166666666666667`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.0009895833333333336`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}], "+", "0.`"}], ")"}]}], "+", 
       RowBox[{
        FractionBox["5", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.002578125`", " ", "p"}], "+", "0.`"}], ")"}]}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.0125`"}], " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.003671875`", " ", "p"}]}], ")"}]}], "-", 
       RowBox[{"0.004166666666666667`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.0009895833333333336`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}], "+", "0.`"}], ")"}]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.4166666666666667`"}], " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.09895833333333334`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{
        FractionBox["5", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.36718749999999994`", " ", "p"}], "+", "0.`"}], ")"}]}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"0.4166666666666667`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"0.0009895833333333336`", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}]}], "+", "0.`"}], ")"}]}]}], "-", 
       RowBox[{
        FractionBox["5", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.002578125`", " ", "p"}], "+", "0.`"}], ")"}]}]}], "eta", 
      "0"},
     {
      RowBox[{
       RowBox[{"0.004166666666666667`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.09895833333333334`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"0.0125`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.2578125`", " ", "p"}]}], ")"}]}]}], 
      RowBox[{
       RowBox[{"0.0125`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "-", 
          RowBox[{"0.003671875`", " ", "p"}]}], ")"}]}], "+", 
       RowBox[{"0.004166666666666667`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0.0009895833333333336`", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "p"}], ")"}]}], "+", "0.`"}], ")"}]}]}], "0", 
      "eta"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.8591332556849327`*^9},
 CellLabel->
  "Out[23]//TraditionalForm=",ExpressionUUID->"1ed536d6-b964-4fba-986d-\
428d51ba8e21"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"0.4166666666666667`", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "p"}], ")"}]}], "+", 
     FractionBox[
      RowBox[{"5", " ", "p"}], "8"], "+", "0.`"}], ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"0.004166666666666667`", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}]}]}], "-", 
     RowBox[{"0.00625`", " ", "p"}], "+", "0.`"}], ",", "0", ",", "0", ",", 
    "0"}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.8591332556940413`*^9},
 CellLabel->
  "Out[24]//TraditionalForm=",ExpressionUUID->"1ca9096e-7c10-4592-9ae9-\
b093aa4dffc2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Checking that our example satisfies the preconditions of Lemma 3:\
\>", "Subtitle",
 CellChangeTimes->{{3.85913328925711*^9, 
  3.859133330988936*^9}},ExpressionUUID->"ce2dda6f-157c-4adf-ad25-\
bbda63fc0773"],

Cell["Check the determinant of the G-matrix as a function of p:", "Text",
 CellChangeTimes->{{3.851483586293323*^9, 3.8514835904772587`*^9}, {
  3.8514836830361557`*^9, 
  3.8514836892381563`*^9}},ExpressionUUID->"79e268f3-be7e-4c40-bc27-\
1a621f7aee7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", "G", "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{"eta", " ", "->", "0"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851483692571827*^9, 3.851483839769257*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"271d4ff2-af80-43b5-bfd1-bcbfe286af55"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVl3c0V/8fxz9oSEIoo5KVlA/1NUv35SXJiMoehZAUDSPZZUtJVFYiksoK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       "]]},
     Annotation[#, "Charting`Private`Tag$219788#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 8.142728274359543*^-11}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.851487833509137*^9, 3.851499574605172*^9, 3.8519117714276047`*^9, 
   3.851911811985467*^9, 3.851936603963008*^9, 3.85199410520131*^9, 
   3.851994367028429*^9, 3.85199447197834*^9, 3.851994695062167*^9, 
   3.851998179977001*^9, 3.85200718891151*^9, 3.8520072272414093`*^9, 
   3.852007925505164*^9, 3.852007958809031*^9, 3.852009091589016*^9, 
   3.8521001894634*^9, {3.8521047226513853`*^9, 3.852104738276569*^9}, {
   3.852105799917136*^9, 3.8521058440773373`*^9}, 3.852105986577483*^9, 
   3.852156617378007*^9, 3.852158452513124*^9, 3.852159463770587*^9, 
   3.852160762533433*^9, 3.852161544834339*^9, 3.852161730886551*^9, {
   3.852166699553945*^9, 3.852166712527013*^9}, 3.8521671061123343`*^9, 
   3.852167353024333*^9, 3.852169605162249*^9, 3.85216967886246*^9, 
   3.852170049225852*^9, {3.852170097407843*^9, 3.852170120290758*^9}, 
   3.852175933314488*^9, 3.85217653952956*^9, 3.8521777026742773`*^9, 
   3.8521779321651697`*^9, 3.852178243585531*^9, 3.8521784835502977`*^9, 
   3.8521788393984747`*^9, 3.852178922754834*^9, 3.852181449919826*^9, 
   3.852181512881166*^9, {3.852181736926352*^9, 3.85218175340339*^9}, 
   3.852181905702479*^9, 3.852189662950305*^9, 3.8523537418886623`*^9, 
   3.859133260097348*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"2cdcc6e6-a64a-45ab-9929-a811c7af2d96"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", "G", "]"}], "/.", " ", 
    RowBox[{"{", 
     RowBox[{"eta", "->", "0"}], "}"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"p", ",", " ", "0.66"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851483926738565*^9, 3.851484009452477*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"b503d023-292e-4203-b3dd-aa527fa12835"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0284788451260984`*^-11", ",", 
   RowBox[{"{", 
    RowBox[{"p", "\[Rule]", "0.66`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.851483985451313*^9, 3.851484009810966*^9}, 
   3.851484427263144*^9, 3.8514995771619253`*^9, 3.851911773965579*^9, 
   3.851911814445949*^9, 3.851936607201846*^9, 3.851994105219092*^9, 
   3.8519943670448008`*^9, 3.8519944719954853`*^9, 3.851994695082567*^9, 
   3.851998180013371*^9, 3.852007188931644*^9, 3.852007227262315*^9, 
   3.8520079255300817`*^9, 3.852007958828989*^9, 3.852009091666733*^9, 
   3.8521001894787197`*^9, {3.852104722674616*^9, 3.852104738292007*^9}, {
   3.85210579997714*^9, 3.852105844116847*^9}, 3.852105986612945*^9, 
   3.8521566174265127`*^9, 3.852158452548003*^9, 3.852159463881959*^9, 
   3.852160762570793*^9, 3.852161544869708*^9, 3.852161730948559*^9, {
   3.852166699622807*^9, 3.852166712545395*^9}, 3.85216710617139*^9, 
   3.852167353123143*^9, 3.852169605226472*^9, 3.85216967896189*^9, 
   3.852170049299365*^9, {3.852170097509635*^9, 3.852170120310557*^9}, 
   3.852175933353771*^9, 3.8521765395566683`*^9, 3.852177702720235*^9, 
   3.852177932192329*^9, 3.852178243624082*^9, 3.8521784835930843`*^9, 
   3.852178839444745*^9, 3.852178922846238*^9, 3.852181449957995*^9, 
   3.852181512920774*^9, {3.852181736958703*^9, 3.852181753437175*^9}, 
   3.8521819057244062`*^9, 3.852189662979041*^9, 3.852353741942192*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"91438c07-dad1-459a-adb6-ed5b3c6022bb"]
}, Open  ]],

Cell["\<\
As expected, adding any eta moves the determinant plot upwards:\
\>", "Text",
 CellChangeTimes->{{3.851487869665288*^9, 3.851487873208165*^9}, {
  3.851487929197938*^9, 3.851487950651429*^9}, {3.851487999426952*^9, 
  3.8514880046070843`*^9}},ExpressionUUID->"f84e4aa6-fc91-47f3-a991-\
38fc37726de5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", "G", "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{"eta", " ", "->", "0.01"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.851484392071267*^9, 3.8514843967460814`*^9}, {
   3.851487445692684*^9, 3.851487467739622*^9}, 3.851487845504175*^9, {
   3.8514879555803757`*^9, 3.8514879556614943`*^9}, {3.8514879875620317`*^9, 
   3.851487993264605*^9}, {3.851911826638483*^9, 3.851911830830246*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"785d40cd-ae2d-41a6-b3ff-27146cf133d2"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVjGk4lAsbgG3VJJG1pkgYUZak0vo+T6WvsZUsWUqSdnUsaUEhMXPsppok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       "]]},
     Annotation[#, "Charting`Private`Tag$16565#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 2.519623094732326*^-7}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8519942831318502`*^9, 3.851994367093254*^9, 3.851994472036265*^9, 
   3.8519946951276417`*^9, 3.851998180057077*^9, 3.85200718901508*^9, 
   3.852007227306768*^9, 3.852007925595207*^9, 3.852007958874658*^9, 
   3.852009091781478*^9, 3.8521001895197277`*^9, {3.852104722744233*^9, 
   3.8521047383362417`*^9}, {3.852105800064006*^9, 3.8521058443036413`*^9}, 
   3.852105986829884*^9, 3.852156617663395*^9, 3.852158452735652*^9, 
   3.852159464068061*^9, 3.852160762756393*^9, 3.852161545043935*^9, 
   3.852161731145432*^9, {3.852166699686471*^9, 3.852166712587376*^9}, 
   3.852167106410576*^9, 3.852167353361582*^9, 3.8521696054064007`*^9, 
   3.852169679173689*^9, 3.852170049478071*^9, {3.852170097598487*^9, 
   3.85217012034439*^9}, 3.8521759334140453`*^9, 3.8521765396202803`*^9, 
   3.8521777027917023`*^9, 3.852177932264892*^9, 3.852178243714847*^9, 
   3.852178483691251*^9, 3.852178839564425*^9, 3.85217892292187*^9, 
   3.852181450020803*^9, 3.852181512980311*^9, {3.852181737011979*^9, 
   3.85218175348897*^9}, 3.852181905776539*^9, 3.852189663045788*^9, 
   3.85235374220827*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"2a942c4f-6f0b-47fa-a826-3b21bb93ced3"]
}, Open  ]],

Cell["\<\
It never crosses zero, and so the matrix is always invertible. This satisfies \
the non-singular matrix requirement in Lemma 3. Assumptions 1 and 2 are \
satisfied by construction of our counterexample. Now we check the quality of \
the solution:\
\>", "Text",
 CellChangeTimes->{{3.851484026915346*^9, 3.8514840484355297`*^9}, {
  3.851484080554365*^9, 3.851484099850119*^9}, {3.85149030142765*^9, 
  3.8514903396997957`*^9}, {3.85149037499236*^9, 3.851490434071846*^9}, {
  3.859133318939171*^9, 
  3.859133339111637*^9}},ExpressionUUID->"f30feaa7-a8c6-47db-ad28-\
2f4583c8d1f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the quality of the solution:", "Subtitle",
 CellChangeTimes->{{3.859133340038662*^9, 
  3.859133350695943*^9}},ExpressionUUID->"e7986c6e-67fb-492e-9bab-\
5fff47f5842a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wstar", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"A", "\[Transpose]"}], ".", 
        RowBox[{"Inverse", "[", "Cm", "]"}], ".", "A"}], " ", "+", " ", 
       RowBox[{"eta", "*", 
        RowBox[{"IdentityMatrix", "[", "k", "]"}]}]}], "]"}], ".", 
     RowBox[{"A", "\[Transpose]"}], ".", 
     RowBox[{"Inverse", "[", "Cm", "]"}], ".", 
     RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "i"}], " ", "//", " ", 
    "Simplify"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851484105940631*^9, 3.851484352329088*^9}, {
   3.851484499727886*^9, 3.8514845169910717`*^9}, 3.851484607335533*^9, 
   3.851484642651285*^9, {3.851485235994341*^9, 3.851485238702242*^9}, 
   3.8514856488110847`*^9, {3.8514918814187937`*^9, 3.851491885408805*^9}, 
   3.8514995110630503`*^9, {3.851499594055295*^9, 3.8514995941881027`*^9}, {
   3.859133364383051*^9, 3.859133404222518*^9}, {3.859133499591085*^9, 
   3.8591335021024933`*^9}, {3.859133543974181*^9, 3.859133575054811*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"657c17a8-2e27-4eea-9450-29788aada741"],

Cell["We plot the learned emphasis as a function both p and eta:", "Text",
 CellChangeTimes->{{3.85148536371875*^9, 3.8514853668677807`*^9}, {
  3.851487702145576*^9, 3.851487712041506*^9}, {3.851488231716909*^9, 
  3.851488237163027*^9}, {3.8514886270204678`*^9, 3.851488628334056*^9}, {
  3.851498001814698*^9, 3.851498014175939*^9}, {3.85149959882533*^9, 
  3.851499601020708*^9}},ExpressionUUID->"d412a640-b98e-4ed7-b3bc-\
60e38c2b05d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{"Phi", ".", "wstar"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"p", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"eta", ",", "0", ",", ".2"}], "}"}]}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.851485223179323*^9, 3.851485303979011*^9}, 
   3.851485339241962*^9, {3.8514881649746532`*^9, 3.8514882035977287`*^9}, {
   3.851488513474225*^9, 3.85148856100097*^9}, {3.8514886325092583`*^9, 
   3.85148864075771*^9}, 3.8514994825851994`*^9, 3.852161073192892*^9, 
   3.859133578546936*^9},
 CellLabel->"In[45]:=",ExpressionUUID->"c1d58809-422a-4460-8893-63b2e361ce01"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyUvXdcz9///1+hrIpKZgmRFCorUY8ilBlCKkVWqKwyklkI0SQVStJOe++9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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxFnHccltP7x5/7ee5p75GR9I1QSYqmkZQKEZFVmSEihUoqo0WprIiWFr5l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            "]], Polygon3DBox[CompressedData["
1:eJw1mwf8V9P/x+/9fM4dH2WVTSjSNJJIUztCdlFGirIqs1K0hGSFrEpGKmRV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            "]], 
           Polygon3DBox[CompressedData["
1:eJwt13m8jmUex/GHc5xzEC2iSb2aVBQlUZYs06RQlkwLBk1iKG0kM6VSijiW
LGVrsYRSyZJ935dD9iU7oaFsDSPJEvP+ve7zx/f1XL/P9f1d13Xf97U9JVq1
f6xd3lQqtYjy0UOZqdTL6anUPuosXpORSm3ISqV6iv9IS6UmYIcyEh71+/ED
dJJniQZm5Eml6vPVo8XizPyp1Bi/q+hmHU2Vt5BekrtT3i76r9wy+i2LjZKX
xTtUfAhfoT6HGqobJG80PaXcEFtDP/M05Z+m38ZyG9EpfBFfO77dynvoBF8N
bbZR3pGe9B/j2IoPERekhdgZ7HJjvt9vTRpjzFfIO6g8XH0Vv/dSYZ5LfnOw
YXLvMYYL2vqFtoq3pSf9T+H5HhssLkALsN+ww9ha8br05HniuS5hVbVTjbZh
hfVbnVrzbKcXsQV8/fmWG1dl5Sx6TlyAVnoHO+SWo7Xy2mPZfJfzVKcPxbfj
5bR1Fc8D/GPF+T3LFPExas5/EnuD/zr9pWHp9Lvcln7nyqnqHd9LF7VzA+9t
ft9QN1vdBfGNVFzuQJ638evl5tPHEOWD1EAfx3gu4lXE1+prZExCbEZ8J+1N
kVsL6q1uYswnbb/g9/noW/16vrf9nhKP5NvBtw57C/sfNgLbjm3BBmH5aT52
GjuObRF/nzsPJmObsYHiLJqH/YqVNp47lD/TXoZxDhF/x/cKz09Yf3Vr+b7N
SL5NU3wTHeU5FO/FmN+U1zkWluc/h9+hXJa+hn6Udx67S7yL7ot3j/XDlirf
o5yP2oiP0Hptb6AWcsdkJOOO8TfDNtMxno3US/mi8U1U9xNPJWyksdTWxwdU
UVzIeIqpuyZ3DsdcXo2/LvcXuf/iX+EZRuHNlUvIWx3PzTMRa4ndgj2pfKW2
Kkcf4ra0RF0V8TD5VZQvw6bK/THmKLWLsj7aq1vMM4KqKhfim67uPzzfxp6g
/AnfAO/iFXF7vg7il+kJ/sniF2gl33Vy/4ZNEp/NTPahnlg25c2fzPOY70XE
c/gPau9Z7CVtvZg7v8aLU/h85QF8/WPuy92MV1Buly9ZYwV5HsfejW8td5C0
Pd7Do1gX7DD2IbYLe493pvHfpHxKfjPxVCrPN5avIl8XdXn000P9GfxGfXwY
74WvOU8zuj7GhPXESvPfRnO120s8Oda1vE/5SsW642tGQ7E8sZaws/zT+CqI
v+SrhL2D9Yk56fd2mq+992O90F/ENWgVNlicQ8/Efh37OtZXvIo6YIfSkvka
83YtdY7zIC3Zo2KveirWjPI5z3erNnuIxxlfHc9UFJvH31rcnD5SzktTje8c
7wfRt9wL2iskfln8JN/HPGk0je88XjfeC9/aOAuogPe5n6+GcvFYl3wHxAXp
Hr5N+An8dIwP+1y5MC3lKxDt4+v4isTc0v5b4ifwrrHOjGUw3178MuxBvn3a
O6nuN7419Eaca3z/9owreRphTfiOxNqnLOMrgw1VX1Pch0rH96G+sTfnS/bQ
8uJ6sRbkrsNmUUG5pbDuyqf1U4SvpLgW/ZkvBx9GGXzVYr0qP0Id9bXcWNLw
frEu6E7scGay78T+sxM7HvuqvH/gY5QL0ZLYwsQ5mcneEHvEz3gX8Wp6FTuB
HcG6iSfJv1W5b1ryjMVjf81K5lMmfoX+Ooi38b6jPj32Heod74q6KR+XO0S/
P/A+wltN7lbjK0Nno63M5P3Gez7M/654A72JncOOYdnixtQnvjU2WntHtNcE
ez++FzYGO4r9HeuLncE+x45hTbF+2O/YF9hxbH2cj/o4ix1V1108IPdMjnlf
IO4e4uKZybfJxjoZczHsoroV2KcxP+hX7LF4B8pH+AbGnYVnB/4ZVozWxt2M
Z3vsseKicffB0rFt2Ajx1bQ6zmtsSpwp4i/Skr0n9qDl9HSceTEn+Wbro3dW
suaXx1lufC3Fy6gF35Y4A/hm8VXVZpOYA7EXYROw7Kxk/5mLnZf7tLghX6e4
D2LZfFviu2GvYfuxHthmrEHMl7hjYt2xTVi9mFfYXqwbtgGrH98X+wF7D9sY
d6/4nthirCk2PtY+1jHueVhXbD1WMs5u7AJdi3XCSsUdM+6x6cnaej3uorGu
xavktsG+xhbE/o6txFpjX8XeGN8p7qLYP7EvscWxF2EbsQ7YdGwe9ii2AmuF
jcUWYY2w77BnsHExB+I+hW3FXsXmxH6O1Y17KNYY+wSbhdWJOwn2ODY0Ixl3
jD8u7HnizIj7QuxjcQ/g66hqZkayR8deXV45L7WKO3qs69gP+V7hm4HPxh6K
+1Gcq9hH2Bzs4bivxp0a+xjbhPXGLmGTsJ+xOnGGxn035ji2Mu7NWNvcPmIs
S7HKWH1sBlYXGx73EqweNh17OO7RWAXsPuzruOdhfbG9+v0GKxHnD3YVz544
Q+KspJ3YlXHXoAbimXGeYyPk/sA3HruJdmNFeLpjs72Xb/l+9/5aiO/G/8oz
DqvK10/udLw6Nhl7EOuFzYyzMc4nrDbWB9sW52j8L4r7Udw/s5K7RNwp4u66
DGsb5w7dr/wNVo2/v7yKWE1sPFYdGxBniv15oXFtiLti3N95dmvzK74bYs7w
FcL2YRPEN8fcx66Os4iez12/sc6Xa6829mLuXHsNy8EewJ7LnS+xzpdh92PP
5s7nmBtLsGpYq9hvsOeweVituHfl7iUxd1dgu4xlNPYnWh9XeZ6d2CjxNbQO
y8DujPcgHiG3DNZN7v44o7BbYv1jRXkOYJPEJWP9Y8Ww8lQ5PfmPGP8Ve8i9
C6uUntzR467eHSuHVcRGYrdj72Flsbux4VhprGtG8g7jXX6JV/au/9Dn/wFP
/RC1
            "]]},
          Annotation[#, "Charting`Private`Tag$221758#1"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, {}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtlltsVVUQhvfZp2fvcwpCi6VKQSggGHzQBOSUF4VoYmoUL/UW9cHYAEYU
iKgkPhiD91urVinVSmJQExICrTURX3jyxYAmFPCuGFtibQEVlHrB2/f3n4c5
M3utWWvNzPrnX2du+4a29WmSJB8hRWQyPyfQRxkcLiTJTGSY7ytqkmQl+gPm
G+TI+Ag+I+gW5EeG2gseX4vqZG6pfLDfyT2/rZwky9jnMuxd7LGC+ePYFyGj
2JcXfPZbudc1478T+yT2avQe5Az2RnQ/Mo69Dn1/liS/ct7V6PuQv7BXojcg
czjnJvS9yN+MX4tei/yLfR36nsyJX4/ezHkHiGEhMY6ljnMScz9jP4x9Nvbx
1HWYgt2HPQf7IdbORlTH4RL5sP579nkM+ySDzzA+veh6XoLU811fco7v43u4
5PEKOsNvCuPfsC7Fnoz9FXZtyffQj/+Nmeu5B7sGn7Owv8bnVnya2OcU47/z
zWdyCP0J0oFUkcaSa74XnyWp70lxfFvwfb1GPY/EnfZiN1CTc7E7c+crH+V8
Ieeu4XsBugdpjlzmYm/B5xz0k8i0iLmHffbjvxU9vWxcvciejYx1yR95peD4
VccBft5FWpBlqf1mMPcHmmXJp6ljfpR8dlccn+LU/h9HztXQ+tZcR3zL7sav
jn0epJZXZs5XeS+IvC6I+x1KXJMnir63QyXvMxCxyac//KphL0bWBG6F3/WB
VWG2EnetuL9Ljfkm9r45871vxX4BIbwJDE/Fvg2fOvSzyKsF41mxVpHXc/eU
7lR3ewsywPimkus3EPmqfxXPrJKxVI18hcPlgVXh/kCsfYqz+JzoKXGB+rKW
sTtz41DYUF2EB9XgruhZ9W579Lv6/unM/a343iapvOiYtXYocCccCA/zy77L
RTUen8f3WIz3xrmKuSH6dHNgaRD7uYrx/17B39dkxsnznNeauf7NzJeLzn0W
+ofUfFJfNJeJu6ZhD9Z4XHzTlrm/uhm/IXM/bsFujLuYj+5CJiXmkE5sQpng
mZewaxPzTG3w6ijn7CTmBzKfI2zsQ3dXjJkPsV+umGfFM5objL5Qfo3RD6Ja
5XQ7xh2J420P7l1RMpefijtvUz3Qb3DuL6zdVTaGWwK34h/ZwnZ/9M1Q9GBH
4Ec8sST4rhrj8lkacxpXbKuin+cRgKj1cPSf1qjfjnJGa2qelJ9s9b7eA/Gt
8l+IPVXYYG479sXBV8LQVfheGrwmfpvN/MHUWB1Hj+fmnBm5azYQfCKOXhz9
upv8H2ddb9nxyEd9Iwyp1lrbHXwl3lIOyqW5aFz9yfc69Gep+/RMamwUmb87
cx+JK8QZO1LnqFy/SI2H/9BfpsZMoWiMlcQ76M9T4+ef1JywiPHV6NO599Te
eitbC65LNfimLt4kYeZYcGVj1FYcMxr+qqHqp75sjfdWdT+Ptcf4/i01H4zE
mz4zOPx0ao7UuLhe/a6+fiT2GY29hOkTgfG+zNjUe92V+Vy948Kh3sR9jL2Z
GZt6x88v+yzd4abcb+7ezNykmLbn7k+B/6fUPKOcNL4/cla+4ijF2JOba4fj
P8wO9t/Ifgcr8b8m3uJV8b6op3SW3m799zgS62rjTZ84q+ge6Yu6qx7LoyZj
gbem4C7trXsTn03Ew9r/Aa2lIIM=
           "]], Polygon3DBox[CompressedData["
1:eJwtlUeMTmEUhr97/3/u/UcfvWeUKBsW6kYJiRJGGS1YiJEZ0aNEYiFCSMSC
aEOUECVRYrQEGys7LIze2yijJkRLbDyv9y5O7nu+U77v1NulYln50jiEsBLK
Q+MSf29zuBy8Lw1hYBRCIRfCsUIIu/g2Qh7znYH8A3pf4Eeg8wK8H/1B4FLO
5oC/yjl8BfQKvB4f5/m2hW8Jvsxl9cE2o/DXBr+7wZiGP/KHzmbwN3CNMPIi
+N/w09GfBDWEfwS/ALwa4S3s20DTwW3RvwjmE76jswcfN2LLt3JJLwQn4TEN
XcENoaHBMTUC98jb5wX0f6I/GsVZ4F/Ix4C74+8TfCd0j4N/xOZ1p+4+gk1f
dPvgZwN+aopDWMe3P/K9qXOi3PxF5x34DD5a5RzzAfB37Noj3wkNx+429lO4
txidE8hPQo3Bk5Fv57wbeFfkmBTbFqgS3J3vvMQ1i3LOmWpZiv17cEmR36d4
N+ZcI9Vqgu5C/gB+EfgT37Lg+3RvNcLSIudjKfHsxeYmOs3gqwt+7wrs2qF7
EP4U1Aw8E/tDnF/lvs/oDoc/wvnq1P3SEnyo4J54jr/62L1yDqpDpQM6m9Ap
Q45auI98ceL6qrf0Br1lO/d35H3f0KnK6vdSPQvV4msifANkD+EXgi/lnY8B
qg/+W2M7JnJPDEZ2FZ2FwW/UW4+n7n3VuCL1+5oHz0wDbM/gY2zkGGX/HFwX
OybFppgV+6vIPaL7NTvDItdE+ZFvvUFvUY2Ve8Wk2JRD5VI1UC3Uk29jx6hY
r+C/PHL8I/F1B72S4P67C26X+r3K5Rbsizl7rXmMLVevPot8JpnsJVN/qE/U
w3pv77x7WzXWPKtHVXv1XGnO86VeXAvoFzvHc1P3pfpTM98F3BOqgm+KvAe4
TvmHPwF1xnYJdC/2fhgPng89jr2TJoNXQiU5z5Pqqx2gWZePN+CjqfPdJ7v/
//6JPU96cxX0BL4x8vLE92uFaf5lX8nZUw6acDYt8Xxqt2jeZ2gOUmPtAO0G
1Uu98zH2rHYruHdVg64F93gLHKwJ7ifVU/P1OfasVHI2JLiHTqeuu+pfltVz
auJ5b42PZYl7Vr2rmqkmqo9qXZft4xWpc6MePpt4h/6KvfO1W1dpViPvyOrs
fvXOeGhH4h5RryiGVsiXpJ792dDh7H+R5rIej7z/1Mv12Xyo32qz/ahcbUu9
32ozf9pHmgXVSLXSjlb9bmX/C92nt6inz6Xu+et550O5U34/RvYp39rZqp3O
lG/Fr7dqh19OvbN/xp4B1Utnkml21D+asWt511C17JjzbEu/A/gfcrTcHQ==

           "]], 
          Polygon3DBox[{{1620, 799, 798, 5, 905}, {1615, 766, 765, 9, 912}, {
           917, 13, 772, 771, 1617}, {1611, 755, 754, 3, 902}, {1614, 764, 
           763, 8, 910}, {2205, 793, 794, 322, 1957}, {919, 614, 810, 809, 
           1621}, {1616, 768, 767, 10, 914}, {918, 14, 774, 773, 1618}, {1963,
            329, 941, 1219, 1894}, {1738, 121, 751, 752, 2204}, {1312, 345, 
           783, 741, 1608}, {1968, 338, 952, 1226, 1902}}], 
          Polygon3DBox[{{1613, 762, 761, 1612, 907, 908}}]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0kszlnEcxvE/T86RSqFE6GjRIps2zXgBrVrUwq6iITIVCwurZkqHaRqH
LCxqoZkwHd6AN9BSdBIxOik6i5B8/rX4zve6fvd9/57nPpSeaDp6NimE8Ain
kkOI+RAXCs2pIeTqB/UWuUSulNvkA/JlPswdfITvcDU/5Hoe4lZ+zO3cmx7C
xUQID/ibPVvk+/JX+Qs267f1PH6vb+LPPIV32KhfsGvQOXP6JN5ig3kuBsxn
9Rz5E2dzv9lHOUtejzdyJs/wa2yTC3He3nvOzZA/mE9gGml6n3k6F2E75s3v
mu2Qf8oF/J1/4Jw9w/wLx+QFfoJi55SgyWwrl2MfyjDi+E4+6dguLkU+Fs1H
0Wj+m5fQID/lZazgjP6M/2AV9fpz/otgR53+Ir5X+biczC/103JCXocxvVZP
kVPxSq/R98sV2I292IPx+LytruUePUe+xdncHZ8xd3FW/C44k29yBt9gjy1c
52tIi9f4zmrsuhp/W++Xu8yu6Cl6e/yPfCnx73ZClWGn4/H2iuM7EzqS/n+7
ax1NU/k=
        "]], Line3DBox[CompressedData["
1:eJwl08lvTWEcxvGfsVixk9BSw4qaa7xaVEvNaq6iWtNtuTWrue2ChMSwYdco
UQu6kLCzI2IplJrb2os/QCQ+byy++T7Pe875nfecc29hXVNVbkBEvEaJUMAt
wyIeD4xo16cMipiKIkzDdMzAvqERM3kWZmOnPoeLMRfV+jyej0PyAl6IvfIi
zmAxavUSLsUS7NGX8jKUYbe+nMuxQ67gFViJSqxCzvpqXoO1WIf12IA6xzZy
FTZhM45a28JbsUvextvT/LTv9Czo9A5q0vG0h7QvPLJWm54hzUV9eg8YOdz1
5uyXD+BgemZk0YBGHMYRdJiR46a0DxzDfWvH+QRO4hROY5S5NeaekZtxFudw
HhdwEU9ce4kvowX39FZuwwP5p+941zftN6eTf/Nz/suvuC8v4rrvnHXee72C
r+ljBkd068X6WPmDXC7nyx/lAu7hzJCIG85vcOyTnm/uQ/mmtS7+bK3M2lt5
nGu+6OP5KxfyN57A33ki/+BJ3MuTuY9L3eO2eY1m9Ov1/FQfbe/v9BH8kv+4
zzP+lfbAvXyHu/kqv+FmfsFZ7uJqbk+/H77FGb7CRdyR9/8/8Q/hWFvd
        "]]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1670, 1841, 2335, 1669, 1840, 2334, 1668, 1839, 2333, 1667, 
        1838, 2332, 1666, 1837, 2331, 1665, 2379, 2228, 1664, 2378, 2227, 
        1663, 2490, 2226, 2180, 2138, 2491, 2139, 2141, 2140, 2051, 1961, 
        2484, 2309, 2028, 2131, 2130, 1962, 1892, 2430, 1662, 1836, 1960, 
        2330, 2277, 1958, 1835, 2447, 1959, 1891, 1956, 2081, 2320}], 
       Line3DBox[{1680, 1845, 2339, 1679, 1844, 2338, 1678, 1843, 2337, 1677, 
        1842, 2336, 1676, 2382, 2231, 1675, 2381, 2230, 1674, 2380, 2229, 
        1673, 2492, 623, 1527, 624, 335, 1352, 417, 240, 2431, 1672, 239, 
        1305, 332, 1304, 238, 330, 1303, 873}], 
       Line3DBox[{1694, 1848, 2342, 1693, 1847, 2341, 1692, 1846, 2340, 1691, 
        2386, 2235, 1690, 2385, 2234, 1689, 2384, 2233, 1688, 2383, 2232, 
        1687, 2493, 2143, 2181, 2142, 2182, 2508, 1686, 2163, 1973, 2052, 
        1972, 2452, 2310, 2117, 2116, 1900, 1967, 1899, 2432, 1685, 1898, 
        1966, 2448, 2278, 1684, 1221, 1965, 1897, 1683, 2450, 1896, 1964, 
        1895, 2209}], 
       Line3DBox[{1709, 1850, 2344, 1708, 1849, 2343, 1707, 2393, 2240, 1706, 
        2392, 2239, 1705, 2391, 2238, 1704, 2390, 2237, 1703, 2389, 2236, 
        1702, 2494, 2144, 2183, 2185, 2184, 2509, 1701, 2164, 2165, 2053, 
        2104, 2103, 2485, 1700, 2118, 2119, 1974, 2453, 2282, 1699, 1905, 
        1971, 2451, 2281, 1698, 2280, 2388, 1970, 1904, 1697, 2279, 2387, 
        1969, 1903, 2210}], 
       Line3DBox[{1724, 1851, 2345, 1723, 2401, 2246, 1722, 2400, 2245, 1721, 
        2399, 2244, 1720, 2398, 2243, 1719, 2397, 2242, 1718, 2396, 2241, 
        1717, 2495, 2145, 2186, 2188, 2187, 2510, 1716, 2166, 2167, 2054, 
        2105, 2471, 2311, 1715, 2120, 2121, 1979, 2456, 2286, 1714, 1909, 
        1978, 2455, 2285, 1713, 2284, 2395, 1977, 1908, 1712, 2283, 2394, 
        1976, 1907, 1710, 2321}], 
       Line3DBox[{120, 983, 119, 982, 118, 981, 117, 980, 116, 979, 115, 978, 
        114, 977, 113, 976, 703, 1582, 112, 452, 1386, 111, 359, 1318, 110, 
        357, 1317, 109, 975, 356, 108, 974, 355, 107, 973, 889}], 
       Line3DBox[{1736, 1863, 2354, 1735, 1862, 2353, 1734, 1861, 2352, 1733, 
        1860, 2351, 1732, 1859, 2350, 1731, 1858, 2349, 1730, 1857, 2348, 
        1729, 2496, 2247, 2189, 2146, 2497, 2147, 1856, 2148, 2055, 2106, 
        2486, 2312, 2133, 1855, 2132, 2029, 2347, 2288, 1728, 1854, 1984, 
        2346, 2287, 1727, 1853, 2458, 1983, 1912, 1726, 1852, 2457, 1982, 
        1911, 1980, 1123, 1981, 2220}], 
       Line3DBox[{1748, 1871, 2362, 1747, 1870, 2361, 1746, 1869, 2360, 1745, 
        1868, 2359, 1744, 1867, 2358, 1743, 1866, 2357, 1742, 2402, 2250, 
        1741, 2498, 2249, 2190, 2149, 2499, 2150, 2152, 2151, 2057, 1989, 
        2107, 2466, 2030, 2135, 2134, 2056, 2356, 2297, 2126, 2125, 1865, 
        1988, 2355, 2289, 1740, 1864, 2459, 1987, 1914, 1739, 1135, 1986, 
        1913, 1737, 2433, 2248, 1985, 2208}], 
       Line3DBox[{1759, 1877, 2368, 1758, 1876, 2367, 1757, 1875, 2366, 1756, 
        1874, 2365, 1755, 1873, 2364, 1754, 2404, 2255, 1753, 2403, 2254, 
        1752, 2500, 2253, 2191, 2153, 2501, 2154, 2156, 2155, 2060, 1998, 
        2487, 2313, 2033, 2137, 2136, 2058, 1997, 2489, 2128, 2127, 1872, 
        2031, 2363, 2290, 1751, 1147, 1994, 1917, 1750, 2435, 2252, 1992, 
        1916, 1749, 2434, 2251, 1990, 1915, 2211}], 
       Line3DBox[{1761, 1918, 1991, 1919, 2436, 1760, 1920, 1993, 1921, 2437, 
        1762, 1922, 1995, 1923, 2438, 1763, 2298, 2467, 2032, 1996, 1764, 
        2460, 2003, 2059, 2004, 2108, 2122, 2314, 2461, 2005, 2061, 2006, 
        2169, 1765, 2318, 2503, 2157, 2192, 2158, 2502, 1766, 2256, 2405, 
        1767, 2257, 2406, 1768, 2258, 2407, 1769, 2369, 1878, 1770, 2370, 
        1879, 1771, 2371, 1880, 1772, 2372, 1881, 1773}], 
       Line3DBox[{1775, 1924, 1999, 1925, 2439, 1774, 1926, 2000, 1927, 2440, 
        1776, 1928, 2001, 2408, 2291, 1777, 2299, 2468, 2034, 2002, 1778, 
        1333, 2062, 2010, 2109, 2123, 2315, 2462, 2011, 2063, 2012, 2170, 
        1779, 2511, 2194, 2159, 2193, 2160, 2504, 1780, 2259, 2409, 1781, 
        2260, 2410, 1782, 2261, 2411, 1783, 2262, 2412, 1784, 2373, 1882, 
        1785, 2374, 1883, 1786, 2375, 1884, 1787}], 
       Line3DBox[{1789, 1929, 2007, 1930, 2441, 1788, 1931, 2008, 2413, 2292, 
        1790, 2009, 2035, 2414, 2300, 1791, 2317, 2506, 2168, 2179, 2178, 
        1792, 2302, 2472, 2064, 2111, 2110, 1793, 1467, 2112, 2065, 2172, 
        2171, 1794, 2512, 2196, 2197, 2195, 2161, 2505, 1795, 2263, 2415, 
        1796, 2264, 2416, 1797, 2265, 2417, 1798, 2266, 2418, 1799, 2267, 
        2419, 1800, 2376, 1885, 1801, 2377, 1886, 1802}], 
       Line3DBox[{1816, 2018, 2017, 2463, 1815, 2429, 2274, 1814, 2428, 2273, 
        1813, 2427, 2272, 1812, 2426, 2271, 1811, 2425, 2270, 1810, 2424, 
        2269, 1809, 2507, 2173, 2201, 2202, 2513, 2319, 1808, 2174, 2175, 
        2067, 2115, 2474, 2316, 1807, 2113, 2114, 2066, 2473, 2303, 1806, 
        2423, 2268, 1805, 2301, 2422, 2036, 2015, 1804, 2294, 2421, 2014, 
        1933, 1803, 2293, 2420, 2013, 1932, 2016}], 
       Line3DBox[{1953, 1834, 1943, 2446, 1660, 1833, 1942, 2445, 1659, 1832, 
        2329, 2296, 1658, 1831, 2328, 2295, 1657, 1830, 2327, 1941, 1656, 
        1829, 2326, 1940, 1655, 2444, 2225, 1939, 1654, 2443, 2224, 2162, 657,
         2488, 2124, 561, 2050, 496, 1493, 570, 569, 1952, 2325, 2276, 1950, 
        480, 1951, 2324, 2275, 1948, 479, 2479, 1949, 1888, 2215}], 
       Line3DBox[CompressedData["
1:eJwV0Ekyg1EYheHvRxWmVCGNJrqIJnr7SKpswALYgiVgAYoBE1HRLEnPAgSJ
5LmDt95zzuDeW7d0cFQ/zCJiH8dDEfODETX+4j3exfVwRMZztmn+5B1+tA8g
5FnbFH9wv+0B23pXL2FSfudR+5a8iX99BkX51v4mb8jr6KS7cJnOx6tcta+h
ne7Chb2gv8irvII/uWFvynk868tcwZX9N70FOf2Jl/je3oef9BZM2M44s92h
rLf0AsblUx6xL8oL+NbzGJNv7Cfyefo39AAOPCcj
        "]]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1051, 1189, 1490, 1264, 2420, 1039, 1178, 2441, 1262, 1028, 
        1167, 2439, 1259, 1017, 1156, 2436, 1256, 1006, 1145, 2434, 1251, 995,
         1134, 2433, 1246, 984, 1123, 1319, 1610, 973, 1112, 1316, 1628}], 
       Line3DBox[{1052, 1190, 1504, 1265, 2421, 1040, 1179, 1263, 2413, 1029, 
        1168, 2440, 1260, 1018, 1157, 2437, 1257, 1007, 1146, 2435, 1252, 996,
         1135, 1247, 985, 2457, 1124, 1240, 974, 1113, 1234, 2394, 963, 1102, 
        1313, 1227, 2387, 953, 1092, 1309, 2450, 1220, 942, 1081, 1303, 1609, 
        931, 482, 1624}], 
       Line3DBox[{1053, 1191, 1335, 2422, 1041, 1180, 1332, 2414, 1030, 1169, 
        1498, 1261, 2408, 1019, 1158, 2438, 1258, 1008, 1147, 1253, 997, 2459,
         1136, 1248, 986, 2458, 1125, 1241, 975, 1114, 1235, 2395, 964, 1103, 
        1228, 2388, 954, 1093, 1221, 943, 1082, 1304, 1214, 932, 2447, 1071, 
        1298, 1208, 921, 1409, 2479, 1408, 1291, 1201, 903, 1400, 2475, 1399, 
        1368, 1629}], 
       Line3DBox[{1054, 1192, 2423, 1042, 1559, 1558, 2506, 1560, 1329, 1499, 
        1328, 2468, 1361, 1325, 1324, 2467, 1359, 2363, 1255, 1254, 1323, 
        2355, 1250, 1249, 1320, 2346, 1243, 1242, 1317, 1237, 1236, 2455, 
        1314, 1230, 1229, 2451, 1310, 1223, 1222, 2448, 1306, 1216, 1305, 
        1215, 1300, 2330, 1210, 1299, 1209, 1294, 2324, 1203, 1292, 1202, 
        1411, 1269, 1413, 2322, 1268, 1369, 1267, 1648}], 
       Line3DBox[{1055, 1193, 2507, 1563, 1043, 1181, 2505, 1552, 1031, 1170, 
        2504, 1549, 1020, 1159, 2502, 1546, 1009, 1148, 2500, 1543, 998, 1137,
         2498, 1540, 987, 1126, 2496, 1537, 976, 1115, 2495, 1534, 965, 1104, 
        2494, 1531, 955, 1094, 2493, 1528, 944, 1083, 2492, 1525, 933, 1072, 
        2490, 1522, 922, 1066, 2443, 1274, 909, 1063, 2476, 1401, 1373, 
        1630}], Line3DBox[{1056, 1194, 2424, 1044, 1182, 2415, 1032, 1171, 
        2409, 1021, 1160, 2405, 1010, 1149, 2403, 999, 1138, 2402, 988, 2348, 
        1127, 977, 1116, 2396, 966, 1105, 2389, 956, 1095, 2383, 945, 1084, 
        2380, 934, 1073, 2378, 923, 1067, 2444, 1275, 911, 2464, 1064, 1402, 
        1374, 1631}], 
       Line3DBox[{1057, 1195, 2425, 1045, 1183, 2416, 1033, 1172, 2410, 1022, 
        1161, 2406, 1011, 1150, 2404, 1000, 2357, 1139, 989, 2349, 1128, 978, 
        1117, 2397, 967, 1106, 2390, 957, 1096, 2384, 946, 1085, 2381, 935, 
        1074, 2379, 924, 2326, 1068, 1276, 913, 2465, 1404, 1403, 1375, 
        1632}], Line3DBox[{1058, 1196, 2426, 1046, 1184, 2417, 1034, 1173, 
        2411, 1023, 1162, 2407, 1012, 2364, 1151, 1001, 2358, 1140, 990, 2350,
         1129, 979, 1118, 2398, 968, 1107, 2391, 958, 1097, 2385, 947, 1086, 
        2382, 936, 2331, 1075, 925, 2327, 1069, 1277, 915, 1406, 2477, 1405, 
        1376, 1633}], 
       Line3DBox[{1059, 1197, 2427, 1047, 1185, 2418, 1035, 1174, 2412, 1024, 
        2369, 1163, 1013, 2365, 1152, 1002, 2359, 1141, 991, 2351, 1130, 980, 
        1119, 2399, 969, 1108, 2392, 959, 1098, 2386, 948, 2336, 1087, 937, 
        2332, 1076, 926, 2328, 1281, 1280, 1347, 1421, 2323, 1279, 1377, 1278,
         1640}], 
       Line3DBox[{1060, 1198, 2428, 1048, 1186, 2419, 1036, 2373, 1175, 1025, 
        2370, 1164, 1014, 2366, 1153, 1003, 2360, 1142, 992, 2352, 1131, 981, 
        1120, 2400, 970, 1109, 2393, 960, 2340, 1099, 949, 2337, 1088, 938, 
        2333, 1077, 927, 2329, 1284, 1283, 1348, 2482, 1422, 1282, 1378, 
        1626}], Line3DBox[{1061, 1199, 2429, 1049, 2376, 1187, 1037, 2374, 
        1176, 1026, 2371, 1165, 1015, 2367, 1154, 1004, 2361, 1143, 993, 2353,
         1132, 982, 1121, 2401, 971, 2343, 1110, 961, 2341, 1100, 950, 2338, 
        1089, 939, 2334, 1078, 928, 1286, 2445, 1285, 1349, 2483, 1423, 1424, 
        1379, 1627}], 
       Line3DBox[{1340, 1339, 1338, 2473, 1396, 1562, 1337, 1561, 1336, 2472, 
        1394, 1503, 1334, 1502, 1333, 1392, 1501, 1331, 1500, 2460, 1330, 
        1390, 1497, 1327, 2489, 1496, 1326, 1388, 1495, 2356, 1322, 1494, 
        1321, 1357, 2347, 1245, 1244, 1318, 1239, 1238, 2456, 1315, 1232, 
        1231, 2453, 1311, 1225, 2432, 1224, 1307, 1218, 2431, 1217, 1301, 
        1212, 2430, 1211, 1296, 2325, 1205, 1293, 1204, 1412, 1272, 2480, 
        1414, 1271, 1370, 1270, 1634}], 
       Line3DBox[{1343, 1342, 2463, 1341, 1050, 2377, 1188, 1038, 2375, 1177, 
        1027, 2372, 1166, 1016, 2368, 1155, 1005, 2362, 1144, 994, 2354, 1133,
         983, 2345, 1122, 972, 2344, 1111, 962, 2342, 1101, 951, 2339, 1090, 
        940, 2335, 1079, 929, 1288, 2446, 1287, 1350, 1425, 2470, 1426, 1380, 
        1569, 1636}], Line3DBox[CompressedData["
1:eJwV0TdOXkEUBtChMBKVV+CCpVABtoUQoaJDIss/QoiGDRBacgYDtsk555xD
wwJAAgw2YHbgM8XRV9z53ujOSy2szEkkhRBq+ZQcwu2HEP5xRz7bXLPFaEoI
NXKDNzbJY50r1qhmhVdWyaVXb1leskQVC7ywSA49zszLC+aoZIa/zMaeebac
5pwpvjHBH76bT8osxjljjIp4h9mIfI478JVfnPKTcoZ54gdfGOKEwXhGv0wO
8DvexWf6OY67mPfJ0rgHj3FnMmk265ZHdFFCBw90kkE7h7RRTAv3tDKvnx6/
wwFNFNHADY18ZJ939kiLb6dXJ+spYJcdEv7xf9J7UZU=
        "]], 
       Line3DBox[CompressedData["
1:eJwV0EsuQ1EAx+GjtNEQQmvWhFLPPmg9S1VRGxATiVEXwELYRvcgMWoaMSlq
LRVSIfp18OV37v/cwc1NN+4ub0dCCFecx0Koc0GKM075iIdQ0xlmOaFrq+ox
U0xT4d1+pIdMMMmLrawH7DPOsy2ue+yyQ5S2PabblCgSoWUf1S02KfAf9dGa
5819TrP82v/YcH61r+safdsPq84d+4ou82X7JuO8xCI9z0/e+dQFz/MkSPJo
nxv+F3f9Mf9J72naH/SGa/cD4J0i+g==
        "]]}, {}, {}}},
    VertexNormals->CompressedData["
1:eJzse/dfju//fikJRZmlRDQUGWlRHBIqaWiQVBoS0RJpEZGMFqVplspKS0Pr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     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{349.08195370105835`, 304.2561314781902},
  ImageSizeRaw->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{0, 1}, {0, 0.2}, {0., 0.8723933971271995}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-0.7817739753652304, 2.2950866204115905`, 2.3603827774853623`},
  ViewVertical->{0.22491799372484042`, -0.6603011795660354, 
   0.7165293073995612}]], "Output",
 CellChangeTimes->{{3.8514852273726053`*^9, 3.851485304311325*^9}, 
   3.851485344359592*^9, {3.851488190643895*^9, 3.851488204031867*^9}, {
   3.851488516021064*^9, 3.851488561756112*^9}, 3.851488632896062*^9, 
   3.851498016326313*^9, 3.85149948339008*^9, 3.8514996023285093`*^9, 
   3.851911840300581*^9, 3.85193662298389*^9, 3.851994105414427*^9, 
   3.851994367267551*^9, 3.851994472170936*^9, 3.8519946952525053`*^9, 
   3.851998180310996*^9, 3.852007189143911*^9, 3.852007227432393*^9, 
   3.852007925787221*^9, 3.852007959001874*^9, 3.852009092469328*^9, 
   3.852100189630845*^9, {3.8521047231689672`*^9, 3.852104738447611*^9}, {
   3.852105800257221*^9, 3.85210584455905*^9}, 3.852105987150607*^9, 
   3.852156617952523*^9, 3.852158452997818*^9, 3.852159464425519*^9, 
   3.852160763022937*^9, 3.852161073737116*^9, 3.852161731593564*^9, {
   3.852166699902281*^9, 3.85216671271208*^9}, 3.8521671067179956`*^9, 
   3.8521673537803183`*^9, 3.8521696056656*^9, 3.8521696795134897`*^9, 
   3.85217004979241*^9, {3.85217009782845*^9, 3.852170120464506*^9}, 
   3.8521759336388063`*^9, 3.85217653984486*^9, 3.852177703092306*^9, 
   3.852177932551338*^9, 3.8521782439908037`*^9, 3.852178483945836*^9, 
   3.8521788398903303`*^9, 3.852178923183833*^9, 3.852181450233013*^9, 
   3.852181513389696*^9, {3.8521817373797293`*^9, 3.8521817538640413`*^9}, 
   3.852181906019833*^9, 3.852189663320271*^9, 3.852353742739222*^9, 
   3.859133585901148*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"67acdcc9-3b52-4fba-8b96-e32512388afc"]
}, Open  ]],

Cell[TextData[{
 "We compute the error in the follow-on trace, using the theoretical value of \
1/(1-gamma) as the on-policy value of this trace.\nSince (Phi.wstar) is \
supposed to reweigh samples to follow the true distribution, we multiply it \
by the off-policy sampling distribution (and divide it by the on-policy value \
of the trace to normalize it).\nThe result is the ",
 StyleBox["apparent",
  FontSlant->"Italic"],
 " distribution, that is the distribution that is seen by the TD updates. "
}], "Text",
 CellChangeTimes->{{3.851488242749215*^9, 3.8514882647341137`*^9}, {
  3.851488692848681*^9, 3.851488698324482*^9}, {3.851488732692107*^9, 
  3.851488766928207*^9}, {3.851498127743741*^9, 3.851498132733142*^9}, {
  3.851937242800733*^9, 3.851937278285675*^9}, {3.8519415898700533`*^9, 
  3.8519416204811363`*^9}, {3.852008158016267*^9, 3.852008220394726*^9}, {
  3.852166047911051*^9, 3.852166098024633*^9}, {3.8521661284219627`*^9, 
  3.85216622861458*^9}, {3.8521662818756113`*^9, 3.852166308506377*^9}, {
  3.859133605290098*^9, 
  3.8591336293781233`*^9}},ExpressionUUID->"81d8ae8e-5370-4e57-8c66-\
f524d5af319b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"apparentD", "=", 
   RowBox[{
    RowBox[{"Phi", ".", "wstar", ".", "Dm"}], "/", "V"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nAD", " ", "=", " ", 
   RowBox[{"apparentD", "/", 
    RowBox[{"Norm", "[", 
     RowBox[{"apparentD", ",", "1"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"nAD", " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"eta", "->", "0."}], ",", 
    RowBox[{"p", "->", "offpolicy"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"nAD", " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"eta", "->", "0.0002"}], ",", 
    RowBox[{"p", "->", "offpolicy"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.852165975650812*^9, 3.852166041142386*^9}, {
   3.852166325545641*^9, 3.852166348583336*^9}, {3.852166737005369*^9, 
   3.8521667371336937`*^9}, {3.8521668757293863`*^9, 3.852166900096663*^9}, {
   3.852167011926711*^9, 3.8521670231221113`*^9}, {3.852167059962893*^9, 
   3.852167072327662*^9}, {3.8521672154582987`*^9, 3.852167217954884*^9}, {
   3.852167372073556*^9, 3.852167419425049*^9}, {3.852167455597311*^9, 
   3.852167459972459*^9}, {3.852167747668044*^9, 3.852167752602901*^9}, {
   3.852169824257613*^9, 3.852169827301983*^9}, {3.852170260359078*^9, 
   3.8521702980087442`*^9}, {3.852170333460124*^9, 3.85217038883531*^9}, 
   3.85217592678379*^9, {3.8521777230072823`*^9, 3.85217772308436*^9}, {
   3.852178235726676*^9, 3.8521782377213078`*^9}, 3.852178466417164*^9, {
   3.8521794438989897`*^9, 3.852179461557176*^9}, {3.852181560253789*^9, 
   3.852181592197201*^9}, {3.8521816719326677`*^9, 3.852181680780239*^9}, 
   3.852181711457244*^9, 3.8521817459278193`*^9, 3.852186957978798*^9, {
   3.8521897812954283`*^9, 3.852189781360677*^9}, {3.85913392418379*^9, 
   3.85913394069905*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"a7d38b07-ea7d-4200-9578-0f1dd51517b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.25000000000000006`", ",", "0.25`", ",", "0.5`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.852181723118094*^9, 3.852181753942841*^9}, 
   3.852181906049317*^9, 3.8521896633549547`*^9, 3.852189781952664*^9, 
   3.852353742854425*^9, 3.8591336362970448`*^9, 3.8591339410892344`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"4a1e08e8-693c-425c-a2f6-1cfcbeaf27ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4404426329422522`", ",", "0.05955736705774778`", ",", "0.5`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.852181723118094*^9, 3.852181753942841*^9}, 
   3.852181906049317*^9, 3.8521896633549547`*^9, 3.852189781952664*^9, 
   3.852353742854425*^9, 3.8591336362970448`*^9, 3.859133941097871*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"8a173909-0f44-4e7a-8689-2d152036856c"]
}, Open  ]],

Cell["Here are the plots from the paper appendix. Error vs P:", "Text",
 CellChangeTimes->{{3.859133778627515*^9, 
  3.859133798703055*^9}},ExpressionUUID->"7c61ea9c-bf1c-4012-a3ce-\
78710141b920"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{"nAD", "-", "pi"}], "]"}], "/.", " ", 
    RowBox[{"{", 
     RowBox[{"eta", "->", "0."}], "}"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"p", ",", " ", "0", " ", ",", " ", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"nAD", "-", "pi"}], "]"}], "/.", " ", 
     RowBox[{"{", 
      RowBox[{"eta", "->", "0.0001"}], "}"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"p", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}], 
  " "}]}], "Input",
 CellChangeTimes->{{3.851487639888674*^9, 3.851487664513064*^9}, 
   3.851488716225412*^9, 3.851494115600397*^9, {3.851937265253853*^9, 
   3.8519372663676043`*^9}, {3.851994717420147*^9, 3.851994727137498*^9}, {
   3.8519947631059637`*^9, 3.8519947829740257`*^9}, {3.8519948183998528`*^9, 
   3.851994818732892*^9}, {3.851998159214282*^9, 3.851998189389578*^9}, {
   3.85199884464557*^9, 3.851998845903398*^9}, {3.8520011505866947`*^9, 
   3.852001172256115*^9}, {3.8520081032628593`*^9, 3.8520081136548634`*^9}, {
   3.852008651101778*^9, 3.852008654634961*^9}, {3.852105999695528*^9, 
   3.852106021783943*^9}, {3.852106249019187*^9, 3.852106250646105*^9}, 
   3.852161055269835*^9, {3.852161101289441*^9, 3.852161124609459*^9}, {
   3.852161710401119*^9, 3.8521617136286297`*^9}, {3.852163738748233*^9, 
   3.852163807763783*^9}, {3.852165944496408*^9, 3.852165957408732*^9}, 
   3.852166319387075*^9, {3.852166352530735*^9, 3.852166376812295*^9}, {
   3.852166930296461*^9, 3.8521669309176188`*^9}, {3.852167428913406*^9, 
   3.852167479265954*^9}, {3.8521701663501596`*^9, 3.852170170261685*^9}, 
   3.85217388386629*^9, 3.852175077719235*^9, {3.852175680009076*^9, 
   3.852175696384325*^9}, {3.8521778213623238`*^9, 3.8521778355653067`*^9}, {
   3.852178254042807*^9, 3.852178257482605*^9}, {3.852178476444899*^9, 
   3.8521784781177673`*^9}, 3.852181462952746*^9, {3.852181539491508*^9, 
   3.8521815396247597`*^9}, {3.852181771045998*^9, 3.8521817718795643`*^9}, {
   3.8591337409257507`*^9, 3.859133773217073*^9}, {3.85913394770887*^9, 
   3.859133949285323*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"b3c7ec55-73ad-4c66-876f-8a4077a707bc"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV0nk41IkfB3DXrqQIlVglOkmywkSrt7BFoVxRjqzU1nQQoiwWIZt7CZtz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       "]]},
     Annotation[#, "Charting`Private`Tag$225555#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0., 1.5411034759124356`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8521696057639027`*^9, 3.8521696796288157`*^9, 3.852170049943742*^9, {
   3.852170098291389*^9, 3.852170120557465*^9}, {3.85217016719526*^9, 
   3.8521701705893803`*^9}, 3.852175712875698*^9, 3.852175933862671*^9, 
   3.8521765400372057`*^9, 3.852177703222046*^9, 3.852177780371024*^9, 
   3.852177836166589*^9, 3.8521779327555857`*^9, {3.852178244192472*^9, 
   3.852178257990745*^9}, {3.852178470346795*^9, 3.852178484123302*^9}, 
   3.85217884009359*^9, 3.852178923343727*^9, 3.85218145045572*^9, {
   3.852181513557036*^9, 3.852181540064152*^9}, {3.8521817375925293`*^9, 
   3.85218177231499*^9}, 3.85218190623164*^9, 3.852189663510098*^9, 
   3.8523537457359867`*^9, 3.859133638908757*^9, {3.859133748479783*^9, 
   3.859133774318427*^9}, 3.8591339509680147`*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"127972bd-db3e-405e-9284-3a10d2a93912"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVlHlUzYsWxzW8V88UlaEUSpOK3FRo8C1c0USTigaSLu6l4TZoutStI5RC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       "]]},
     Annotation[#, "Charting`Private`Tag$225607#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.21370955749717702`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0.21370955749717654`, 1.5411034759124356`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8521696057639027`*^9, 3.8521696796288157`*^9, 3.852170049943742*^9, {
   3.852170098291389*^9, 3.852170120557465*^9}, {3.85217016719526*^9, 
   3.8521701705893803`*^9}, 3.852175712875698*^9, 3.852175933862671*^9, 
   3.8521765400372057`*^9, 3.852177703222046*^9, 3.852177780371024*^9, 
   3.852177836166589*^9, 3.8521779327555857`*^9, {3.852178244192472*^9, 
   3.852178257990745*^9}, {3.852178470346795*^9, 3.852178484123302*^9}, 
   3.85217884009359*^9, 3.852178923343727*^9, 3.85218145045572*^9, {
   3.852181513557036*^9, 3.852181540064152*^9}, {3.8521817375925293`*^9, 
   3.85218177231499*^9}, 3.85218190623164*^9, 3.852189663510098*^9, 
   3.8523537457359867`*^9, 3.859133638908757*^9, {3.859133748479783*^9, 
   3.859133774318427*^9}, 3.8591339511136827`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"60bec7e6-7e96-44e2-9547-d38e7e1d5a24"]
}, Open  ]],

Cell["\<\
This value, even on the on-policy measure, tends to be very sensitive to eta:\
\
\>", "Text",
 CellChangeTimes->{{3.8514929145319023`*^9, 3.8514929468976393`*^9}, {
  3.851494125186507*^9, 3.851494127906431*^9}, {3.8514981507578583`*^9, 
  3.851498188157116*^9}, {3.851498227073159*^9, 3.851498237481896*^9}, {
  3.851937299205062*^9, 3.851937306999751*^9}, {3.8519374583137217`*^9, 
  3.8519374999449577`*^9}, {3.8520082647018414`*^9, 3.85200828211259*^9}, {
  3.852008365386923*^9, 3.8520083680785*^9}, {3.8520087634672527`*^9, 
  3.852008774848666*^9}, {3.852008970741968*^9, 
  3.8520089761375*^9}},ExpressionUUID->"14035182-a51c-404b-9900-34742a9b2e9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{"nAD", "-", "pi"}], "]"}], "/.", " ", 
    RowBox[{"{", 
     RowBox[{"p", "->", "offpolicy"}], "}"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"eta", ",", " ", "0.00000001", ",", " ", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.851492948301422*^9, 3.851492949732585*^9}, {
   3.851494092238603*^9, 3.851494119609436*^9}, 3.851499663453274*^9, {
   3.851937312542314*^9, 3.8519374286143513`*^9}, {3.851994486122987*^9, 
   3.851994492255863*^9}, {3.8520082306524982`*^9, 3.852008242876754*^9}, {
   3.852008375252351*^9, 3.852008376345004*^9}, {3.8520084276387587`*^9, 
   3.852008434196617*^9}, {3.852008481241707*^9, 3.852008489116461*^9}, {
   3.852008524269862*^9, 3.852008553162719*^9}, {3.8520085911264963`*^9, 
   3.8520086314782257`*^9}, {3.852008890414384*^9, 3.8520089025039883`*^9}, {
   3.852008935617709*^9, 3.852008937818438*^9}, {3.852161744581058*^9, 
   3.8521617475237617`*^9}, {3.852166391634604*^9, 3.852166397402437*^9}, {
   3.8521664414967623`*^9, 3.852166507263562*^9}, 3.852166539770563*^9, {
   3.852167496068698*^9, 3.852167497204014*^9}, {3.85217594732428*^9, 
   3.852175947421858*^9}, {3.852176583696725*^9, 3.852176593586707*^9}, {
   3.8521782975543823`*^9, 3.852178300195984*^9}, 3.852178492504909*^9, {
   3.8521785905096407`*^9, 3.8521785997715816`*^9}, 3.859133812158499*^9, 
   3.859133961766568*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"3d468050-6690-4733-a2d4-f1761432501e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nc41e8bB/Bj772OfRwKZY8Gom8R2lYhCkmLNGSEX9qi0CY0bImSkaz7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       "]]},
     Annotation[#, "Charting`Private`Tag$225978#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-18.420680743952367`, -9.780317145908302},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{-18.420680743952367`, 0}, {-9.780317145908302, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0], 
     Charting`ScaledTicks[
     "Log", {Log, Exp}, "Nice", WorkingPrecision -> MachinePrecision, 
      RotateLabel -> 0]}, {{{-16.11809565095832, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.001\"", ShowStringCharacters -> False], 0.001, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-20.82862635260424, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-20.72326583694641, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-18.420680743952367`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.3513752571634776`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.3978952727983707`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}, {{-9.210340371976182, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.001\"", ShowStringCharacters -> False], 0.001, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox[
          StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
          AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-13.122363377404328`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.716898269296165`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.429216196844383`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.206072645530174`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-12.02375108873622, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.86960040890896, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.736069016284437`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.618285980628055`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.819778284410283`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.41431317630212, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-10.126631103850338`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.903487552536127, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.721165995742174, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.567015315914915, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.433483923290392, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-9.315700887634009, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.517193191416238, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.111728083308073, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.824046010856292, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.298317366548036, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.70805020110221, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{
  3.852166408079893*^9, {3.8521664506551*^9, 3.852166474568595*^9}, 
   3.8521665077195272`*^9, 3.8521665402346067`*^9, {3.852166700424934*^9, 
   3.852166713278528*^9}, 3.852167107523221*^9, 3.852167354564534*^9, 
   3.852167497907387*^9, 3.852169606338427*^9, 3.852169680261423*^9, 
   3.8521700505835037`*^9, {3.852170098654195*^9, 3.852170120800316*^9}, {
   3.8521759342349463`*^9, 3.8521759486324453`*^9}, 3.852176540448824*^9, {
   3.852176584426634*^9, 3.852176594291375*^9}, 3.852177703581436*^9, 
   3.852177933172556*^9, 3.8521782446573877`*^9, 3.8521783009016647`*^9, {
   3.852178484714613*^9, 3.852178493194291*^9}, {3.852178591425041*^9, 
   3.852178600617373*^9}, 3.852178840893704*^9, 3.85217892392951*^9, 
   3.852181450870564*^9, 3.85218151428058*^9, {3.852181738270567*^9, 
   3.8521817547514277`*^9}, 3.852181906660844*^9, 3.852189663928802*^9, 
   3.8523537485015593`*^9, 3.8591336457555447`*^9, 3.859133827188223*^9, 
   3.8591339636728888`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"b255bbb7-8209-4520-80f3-e889f0ce7f5f"]
}, Open  ]],

Cell["Dump it to disk:", "Text",
 CellChangeTimes->{{3.8591371552967854`*^9, 3.8591371595976152`*^9}, {
  3.859137227143734*^9, 
  3.859137231762519*^9}},ExpressionUUID->"7d69df47-b274-42a1-a509-\
99d70ecea140"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tbl", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"nAD", "-", "pi"}], "]"}], " ", "/.", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", "->", "offpolicy"}], ",", 
        RowBox[{"eta", "->", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{"etarun", "/", "10"}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"etarun", ",", 
       RowBox[{
        RowBox[{"-", "10"}], " ", "*", "10"}], ",", 
       RowBox[{"0", "*", "10"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<emphasis_nAD_etaemph\>\"", ",", "\"\<.dat\>\""}], "]"}], ",",
    "tbl"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.859137230107882*^9, {3.859137319025043*^9, 3.859137401525629*^9}, {
   3.8591380387515373`*^9, 3.859138040019751*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"1250353d-c313-453a-abd6-854636a3d760"],

Cell[BoxData["\<\"emphasis_nAD_etaemph.dat\"\>"], "Output",
 CellChangeTimes->{3.8591374047861757`*^9, 3.8591380478302402`*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"e8f4184c-26b6-418a-bfae-d11e39ba8302"]
}, Open  ]],

Cell["\<\
Reduce[FullSimplify[Norm[apparentD - pi] /. {p -> 1/3}, eta \[Element] Reals \
&& eta >= 0] < 0.5, eta]\
\>", "Text",
 CellChangeTimes->{{3.852167543560986*^9, 3.852167561443119*^9}, 
   3.852167650695629*^9},
 CellLabel->"In[61]:=",ExpressionUUID->"c92ed012-fe59-4bbb-9e7d-b4c48a329970"],

Cell["\<\
To get better than 50% error, you need to select eta < 10^-4. (The above \
equation doesn\[CloseCurlyQuote]t sol bve quickly.)\
\>", "Text",
 CellChangeTimes->{{3.85200947474175*^9, 3.852009490432707*^9}, {
  3.852167658764056*^9, 3.852167660476303*^9}, {3.852168508108543*^9, 
  3.8521685247521753`*^9}, {3.8591400580188837`*^9, 
  3.859140058019742*^9}},ExpressionUUID->"b3c6e8ef-526e-44c3-805d-\
57184843dee7"],

Cell[CellGroupData[{

Cell["Part 2: Assumption 4", "Section",
 CellChangeTimes->{{3.850702730932063*^9, 3.850702746241844*^9}, 
   3.851481918666051*^9, {3.851492131817268*^9, 3.851492132208036*^9}, {
   3.851497614917158*^9, 3.8514976152825317`*^9}, {3.851499406187736*^9, 
   3.851499411561515*^9}, {3.851499972852186*^9, 3.8514999877599573`*^9}, {
   3.851913804823016*^9, 
   3.851913810669477*^9}},ExpressionUUID->"f6631038-6e0d-4fa0-9fc3-\
a22e10e7e4dc"],

Cell["\<\
We need to check convergence properties for a few parts of this. From \
Assumption 4(a), we check that some specified matrix is positive semidefinite \
using Sylvester\[CloseCurlyQuote]s criterion:\
\>", "Text",
 CellChangeTimes->{{3.851499689058364*^9, 3.8514997021967163`*^9}, {
  3.8514997751012897`*^9, 3.851499776150014*^9}, {3.851499932837554*^9, 
  3.851499936642516*^9}, {3.8515001587762547`*^9, 3.8515001832659607`*^9}, {
  3.851917386085287*^9, 3.8519173869754333`*^9}, {3.851917443664357*^9, 
  3.851917447178466*^9}},ExpressionUUID->"781e69ff-ae2e-47c2-a9b8-\
803b543c56f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Fmat", " ", "=", 
   RowBox[{"ArrayFlatten", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "Phi"}], ",", " ", 
        RowBox[{
         RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "P", ".", "Phi"}]}],
        "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Phi", "\[Transpose]"}], ".", 
         RowBox[{"P", "\[Transpose]"}], ".", "Dm", ".", "Phi"}], ",", 
        RowBox[{
         RowBox[{"Phi", "\[Transpose]"}], ".", "Dm", ".", "Phi"}]}], " ", 
       "}"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851499937755701*^9, 3.851499939525991*^9}, {
   3.851499971402421*^9, 3.851500118725119*^9}, {3.851500270167347*^9, 
   3.8515003049389677`*^9}, {3.8515006796428013`*^9, 3.8515006986363707`*^9}, 
   3.85167570087422*^9, 3.851911865586385*^9, {3.851912056645945*^9, 
   3.851912073600946*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"91a7a380-e38c-406f-ab1a-c56973896108"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Det", "[", 
      RowBox[{"Fmat", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{";;", "1"}], ",", 
         RowBox[{";;", "1"}]}], "]"}], "]"}], "]"}], ">=", "0"}], "&&", 
    RowBox[{
     RowBox[{"Det", "[", 
      RowBox[{"Fmat", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{";;", "2"}], ",", 
         RowBox[{";;", "2"}]}], "]"}], "]"}], "]"}], ">=", "0"}], "&&", 
    RowBox[{
     RowBox[{"Det", "[", 
      RowBox[{"Fmat", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{";;", "3"}], ",", 
         RowBox[{";;", "3"}]}], "]"}], "]"}], "]"}], ">=", "0"}], "&&", 
    RowBox[{
     RowBox[{"Det", "[", 
      RowBox[{"Fmat", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{";;", "4"}], ",", 
         RowBox[{";;", "4"}]}], "]"}], "]"}], "]"}], ">=", "0"}]}], ",", 
   "p"}], "]"}]], "Input",
 CellChangeTimes->{
  3.851500711193376*^9, {3.851912077863325*^9, 3.851912185880451*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"9d903d60-fb8a-44c1-8699-9bc85347d342"],

Cell[BoxData[
 TemplateBox[{
  "Reduce", "ratnz", 
   "\"Reduce was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"", 2, 41, 1, 34133470843809192981, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.851912186812026*^9, 3.851937183615603*^9, 3.8519941055406523`*^9, 
   3.851994367386586*^9, 3.851994472327124*^9, 3.851994695427094*^9, 
   3.851998180645597*^9, 3.852007189259481*^9, 3.8520072276379747`*^9, 
   3.852007959136633*^9, 3.8520090999003077`*^9, 3.852100195300877*^9, {
   3.852104727373674*^9, 3.85210474121068*^9}, {3.852105800697754*^9, 
   3.852105816095676*^9}, 3.852105847943267*^9, 3.8521059894686832`*^9, 
   3.8521566216652193`*^9, 3.8521584565109377`*^9, 3.852159467857772*^9, 
   3.8521607665430737`*^9, 3.852161735099176*^9, 3.852166700561252*^9, 
   3.852167354764638*^9, 3.852169606472329*^9, 3.85216968041477*^9, 
   3.852170050679864*^9, {3.852170098827467*^9, 3.8521701208687572`*^9}, 
   3.8521759343248243`*^9, 3.852176540554414*^9, 3.852177703699505*^9, 
   3.852177888595632*^9, 3.852177933356851*^9, 3.852178244760116*^9, 
   3.852178484881837*^9, 3.85217851512848*^9, 3.852178841080235*^9, 
   3.852178924064039*^9, 3.852181450965176*^9, 3.8521815144540243`*^9, {
   3.8521817383604603`*^9, 3.852181754842301*^9}, 3.852181906766212*^9, 
   3.8521896640446033`*^9, 3.852353748885318*^9},
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"10721ccd-1614-453e-8b37-8c4d6feada1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "0", "\[LessEqual]", "p", "\[LessEqual]", "3.469446951953614`*^-17"}], "||", 
  RowBox[{"p", "\[GreaterEqual]", "0.4000000000000002`"}]}]], "Output",
 CellChangeTimes->{
  3.851912186834569*^9, 3.851937183627887*^9, 3.851994105550417*^9, 
   3.851994367396887*^9, 3.851994472337264*^9, 3.85199469543954*^9, 
   3.851998180667796*^9, 3.8520071892715054`*^9, 3.8520072276498327`*^9, 
   3.852007959146069*^9, 3.852009099910627*^9, 3.852100195308055*^9, {
   3.8521047273789463`*^9, 3.852104741216147*^9}, {3.852105800704088*^9, 
   3.852105816104164*^9}, 3.852105847949068*^9, 3.852105989474818*^9, 
   3.852156621671133*^9, 3.852158456518703*^9, 3.852159467864688*^9, 
   3.852160766549982*^9, 3.852161735103785*^9, 3.8521667005672693`*^9, 
   3.8521673547849207`*^9, 3.852169606484326*^9, 3.852169680427087*^9, 
   3.852170050691944*^9, {3.852170098837358*^9, 3.852170120880042*^9}, 
   3.852175934337625*^9, 3.852176540573926*^9, 3.852177703719129*^9, 
   3.8521778886203136`*^9, 3.8521779333735437`*^9, 3.8521782447742863`*^9, 
   3.852178484896888*^9, 3.852178515147818*^9, 3.852178841094994*^9, 
   3.852178924080474*^9, 3.852181450978373*^9, 3.8521815144672937`*^9, {
   3.8521817383749247`*^9, 3.8521817548568363`*^9}, 3.852181906780425*^9, 
   3.852189664059626*^9, 3.852353748901588*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"178d7324-3d4e-43f8-b774-b5ee7b7e7d1c"]
}, Open  ]],

Cell["\<\
It is, and it includes the minimum point and values to the right of it.\
\>", "Text",
 CellChangeTimes->{{3.8515019345476503`*^9, 3.8515019516245604`*^9}, 
   3.851911876716339*^9, {3.851912200436988*^9, 3.851912226337709*^9}, {
   3.851937194170128*^9, 3.851937210792151*^9}, {3.852177897768683*^9, 
   3.852177912950076*^9}, {3.8521779765703363`*^9, 
   3.85217799737407*^9}},ExpressionUUID->"07b0dbc9-e704-4456-858b-\
31ec8a272c18"],

Cell["\<\
We need to establish that we don\[CloseCurlyQuote]t approach a region with \
zero determinant, which is:\
\>", "Text",
 CellChangeTimes->{{3.8515007176896267`*^9, 3.851500722291724*^9}, {
   3.851500795710579*^9, 3.851500828286819*^9}, {3.8519122289627657`*^9, 
   3.851912247135356*^9}, 
   3.851934924383149*^9},ExpressionUUID->"7ec1adc8-f7b5-4878-b935-\
d505cf9288c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Det", "[", "A", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8514997234108057`*^9, 3.851499749962371*^9}, {
  3.851499924547532*^9, 3.851499927913755*^9}, {3.851934934694818*^9, 
  3.8519349382347717`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"227e5088-edcb-4bdc-8e09-badd8cc691b7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk8FfsbB3CKm4RskSSRiiJLWdM8yBZZIylJEsVVbooWJUkkSyFLtnPO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       "]]},
     Annotation[#, "Charting`Private`Tag$20068#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {-6.059869045649099*^-7, 0.00001068115177630297}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.85149975025935*^9, 3.851499928228717*^9, 3.851934939085896*^9, 
   3.851937214531952*^9, 3.8519941055904083`*^9, 3.85199436743576*^9, 
   3.8519944723757153`*^9, 3.851994695479076*^9, 3.8519981807034903`*^9, 
   3.852007189339967*^9, 3.8520072276914577`*^9, 3.8520079591864557`*^9, 
   3.852009099955821*^9, 3.852100195345562*^9, {3.8521047274161167`*^9, 
   3.85210474125478*^9}, {3.852105800749075*^9, 3.852105816194556*^9}, 
   3.852105847980432*^9, 3.852105989507514*^9, 3.852156621705689*^9, 
   3.852158456579493*^9, 3.8521594679025106`*^9, 3.8521607665856543`*^9, 
   3.852161735151743*^9, 3.852166700608762*^9, 3.852167354823143*^9, 
   3.85216960652732*^9, 3.852169680467408*^9, 3.8521700507344627`*^9, {
   3.852170098884902*^9, 3.852170120921146*^9}, 3.852175934380518*^9, 
   3.852176540695737*^9, 3.8521777037875557`*^9, 3.852177933429324*^9, 
   3.852178244828868*^9, 3.85217848496385*^9, 3.852178841184205*^9, 
   3.852178924143572*^9, 3.852181451060319*^9, 3.8521815145464907`*^9, {
   3.8521817384209948`*^9, 3.852181754900676*^9}, 3.852181906890992*^9, 
   3.8521896641687927`*^9, 3.8523537491474133`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"d09be896-2d06-4d62-8f5f-5754284ea44e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["offpolicy"], "Input",
 CellChangeTimes->{{3.852181795617276*^9, 3.852181796896989*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"8a31dad5-469b-4b6f-b640-029ffd076c44"],

Cell[BoxData["0.4`"], "Output",
 CellChangeTimes->{3.8521817973869267`*^9, 3.8521819069122133`*^9, 
  3.852189664202875*^9, 3.852353749228689*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"fd2e3329-b034-4d4f-9900-5564238320ea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writeup", "Section",
 CellChangeTimes->{{3.85191381683519*^9, 3.851913830472172*^9}, {
  3.85235375876129*^9, 
  3.8523537632639303`*^9}},ExpressionUUID->"fe3949d1-6493-4dac-834b-\
ce85d5e2f7bb"],

Cell["\<\
We prepare the various bits and bobs we need for the writeup.\
\>", "Text",
 CellChangeTimes->{{3.852353764531617*^9, 
  3.852353784874545*^9}},ExpressionUUID->"8549b696-933e-4054-bc57-\
d3026fb9ea4d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cm", " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{"p", "->", "offpolicy"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8523538065794563`*^9, 3.852353844081337*^9}, {
  3.852353930100871*^9, 3.852353931094317*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"2d06eb61-1781-450f-9076-734db10ebebf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.4166666666666667`", ",", 
     RowBox[{"-", "0.0010416666666666667`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.0010416666666666667`"}], ",", 
     "0.00004166666666666667`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8523538126564913`*^9, 3.852353844446081*^9}, 
   3.8523539314988422`*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"c7b8a68d-5d3c-4baa-ac37-02ff4fc0666c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", " ", "/.", 
  RowBox[{"{", 
   RowBox[{"p", "->", "offpolicy"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.852353934763509*^9, 3.852353942756586*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"41542878-eb14-41d3-9004-67c1faddf037"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.15885416666666663`", ",", "0.0015364583333333337`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.0015364583333333335`", ",", "0.000015885416666666665`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8523539353082027`*^9, 3.852353943048415*^9}},
 CellLabel->"Out[51]=",ExpressionUUID->"31560b48-9759-4a86-921e-a91ecc9744dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"wstar", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "->", "offpolicy"}], ",", " ", 
     RowBox[{"eta", "->", "0"}]}], "}"}]}], " ", "//", 
  "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.8523542749881268`*^9, 3.8523542814651213`*^9}, {
  3.8523543221077127`*^9, 3.852354352766927*^9}, {3.85235445964014*^9, 
  3.852354465573247*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"fde904ea-cd82-4215-b345-4762b26249c9"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"96.0000000000416`", ",", 
    RowBox[{"-", "9600.000000004156`"}]}], "}"}], TraditionalForm]], "Output",\

 CellChangeTimes->{3.852354281716653*^9, 3.852354353119875*^9, 
  3.8523544660159473`*^9},
 CellLabel->
  "Out[54]//TraditionalForm=",ExpressionUUID->"938da3b5-5221-4be7-a07c-\
2465c6f45332"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearAlgebra`Private`MatrixConditionNumber", "[", " ", 
  RowBox[{
   RowBox[{"Phi", "\[Transpose]"}], ".", "Phi"}], "]"}]], "Input",
 CellChangeTimes->{{3.8523563862637367`*^9, 3.852356403567548*^9}, {
  3.852356462647243*^9, 3.852356480775823*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"8f41a843-89bf-4800-85f3-b697677a258e"],

Cell[BoxData["10121.22222222222`"], "Output",
 CellChangeTimes->{{3.852356392321056*^9, 3.852356411315628*^9}, {
  3.852356465771215*^9, 3.8523564810805693`*^9}},
 CellLabel->"Out[60]=",ExpressionUUID->"606cf37e-f329-41ed-bcab-7f616437225c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Inverse", "[", "Cm", "]"}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{"p", "->", "offpolicy"}], "}"}]}], "//", 
  "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.852358197425727*^9, 3.8523582426137257`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"7681342d-4943-4d81-971f-b9fc49a3af7a"],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2.5599999999999996`", "63.999999999999986`"},
     {"63.999999999999986`", "25599.999999999996`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.852358199721703*^9, 3.852358242826956*^9}},
 CellLabel->
  "Out[64]//TraditionalForm=",ExpressionUUID->"a49c8c21-248b-4c78-8bfa-\
b470bfdbbd84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"nAD", "/.", 
    RowBox[{"{", 
     RowBox[{"p", "->", "offpolicy"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Rest", "[", 
    RowBox[{"Rest", "[", "tmp", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", ",", " ", "0", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"First", "[", "tmp", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"eta", ",", " ", "0", ",", "1"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"First", "[", "tmp", "]"}]}], "Input",
 CellChangeTimes->{{3.859134903994698*^9, 3.859134904382381*^9}, {
  3.859135899441093*^9, 3.859135998665745*^9}, {3.8591360363324327`*^9, 
  3.859136075032764*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"0ac53d39-cee1-4081-9c21-653a48dc6996"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7ZX64uKBl6F2DGDwwH6BqH9bl2SLPSOU38ixWb1T
coo9TD4icuH6Dx+XwPnc/xtj3OXWw/mqge9eHO7eAueXn7O0n/FlJ5wvvkXw
HiPjfjh/2yPnM+dtDsH5h7LmSke+OQK3/6uaLf/a3OP2/8Hgvj3Tz9UC0qqn
4OrN/idsC153Bs4/02Jy7pjWeft/UPXyE17/XPnuAlz+9ff7964aXIKbt+TV
7lN8fZfh8nyyy98/eXIFbn9P5ta0BSrX4PLfHFY/yai/DpcvMTqyRezwDbh5
99cd6b6oeAvO/511ZbZm1W24fm1H9n9pu+/A9bsvUkzfKH4PEV6y8UoPY+7D
+TpvQrmv+z6A84X5P3Ac+fUArp9l/+z1ynMewuWzTXbf5PR+BOev9kxasO8b
gv/1tZTAs2mP4fytwe7MU1yewPn1Hq3ztzxD8BXvet1Y3PoUbp+VecsUSaNn
cP/FyJ3/yXj5GcL8U72PChqfw/kzWOJKglRewNUL39u6iOnIC7g8a21jiGXh
SzifYWXc+kdCr+D8olnre4UOIfh7tTs4BPNew/mCXkU6TXxv4Pw7uhcuV+5B
8DfMs1d5EvcWzo9dbyYo+w/Bb2hd2Hhn1Tu4+9a+kJ3N5/MeLq/UIuLBvgzB
ny7P/fX///dw9QBJTUQO
       "]]},
     Annotation[#, "Charting`Private`Tag$231201#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0.4999999999999999, 0.5000000000000001}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.859134905205562*^9, {3.85913594489012*^9, 3.8591359992926207`*^9}, 
   3.8591360429333553`*^9, 3.859136075642037*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"36755eae-c032-48a5-9dd0-aac4008f5a34"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xk41AsXB3DSfRJli6ksV7aistxul7jpSAuF7pvqUYmEIl6VeCXqlWW6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       "]]},
     Annotation[#, "Charting`Private`Tag$231253#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.49975038913310055`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0.49975038913309944`, 0.49993438566201115`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.859134905205562*^9, {3.85913594489012*^9, 3.8591359992926207`*^9}, 
   3.8591360429333553`*^9, 3.859136075687311*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"655c6f36-c8e3-4478-bb93-be9034e008c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0.010000000000000009`", " ", 
    RowBox[{"(", 
     RowBox[{"0.`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.25`", " ", 
       RowBox[{"(", 
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"0.001152000000000003`", " ", "eta"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"3.542013888888889`*^-8", "+", 
            RowBox[{"0.4`", " ", 
             RowBox[{"(", 
              RowBox[{"1.3947515978994914`*^-40", "-", 
               RowBox[{"7.415492238272908`*^-20", " ", "eta"}]}], ")"}]}], 
            "+", 
            RowBox[{"0.010240000000000006`", " ", 
             RowBox[{"(", 
              RowBox[{"4.109700520833252`*^-7", "+", 
               RowBox[{"0.4460135639105902`", " ", "eta"}]}], ")"}]}], "+", 
            RowBox[{"0.16000000000000003`", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.360130369343619`*^-24"}], "+", 
               RowBox[{"0.0062679878472222325`", " ", "eta"}], "+", 
               RowBox[{"0.6400000000000001`", " ", 
                SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
            RowBox[{"0.02560000000000001`", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.981526692708337`*^-6"}], "+", 
               RowBox[{"0.6276929713541666`", " ", "eta"}], "+", 
               RowBox[{"1.`", " ", 
                SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
            RowBox[{"0.06400000000000002`", " ", 
             RowBox[{"(", 
              RowBox[{"9.79275173611112`*^-7", "+", 
               RowBox[{"0.22454068098958324`", " ", "eta"}], "+", 
               RowBox[{"1.6`", " ", 
                SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"0.004163055386726785`", "/", 
          RowBox[{"(", 
           RowBox[{"0.0040960000000000015`", "\[VeryThinSpace]", "+", 
            RowBox[{"0.4`", " ", 
             RowBox[{"(", 
              RowBox[{"1.612896709105911`*^-35", "-", 
               RowBox[{"8.575306918825765`*^-15", " ", "eta"}]}], ")"}]}], 
            "+", 
            RowBox[{"0.010240000000000006`", " ", 
             RowBox[{"(", 
              RowBox[{"0.0475247524752466`", "\[VeryThinSpace]", "+", 
               RowBox[{"51577.19916086659`", " ", "eta"}]}], ")"}]}], "+", 
            RowBox[{"0.16000000000000003`", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.19847766879273`*^-19"}], "+", 
               RowBox[{"724.8327936476832`", " ", "eta"}], "+", 
               RowBox[{"74009.87354180966`", " ", 
                SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
            RowBox[{"0.02560000000000001`", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "0.4604254484854432`"}], "+", 
               RowBox[{"72586.6834890697`", " ", "eta"}], "+", 
               RowBox[{"115640.42740907759`", " ", 
                SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
            RowBox[{"0.06400000000000002`", " ", 
             RowBox[{"(", 
              RowBox[{"0.11324379962748764`", "\[VeryThinSpace]", "+", 
               RowBox[{"25965.98032036074`", " ", "eta"}], "+", 
               RowBox[{"185024.68385452413`", " ", 
                SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0.000025000000000000025`", " ", 
     RowBox[{"Abs", "[", 
      RowBox[{"0.`", "\[VeryThinSpace]", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.000011519999999999842`", " ", "eta"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"3.542013888888889`*^-8", "+", 
          RowBox[{"0.4`", " ", 
           RowBox[{"(", 
            RowBox[{"1.3947515978994914`*^-40", "-", 
             RowBox[{"7.415492238272908`*^-20", " ", "eta"}]}], ")"}]}], "+", 
          
          RowBox[{"0.010240000000000006`", " ", 
           RowBox[{"(", 
            RowBox[{"4.109700520833252`*^-7", "+", 
             RowBox[{"0.4460135639105902`", " ", "eta"}]}], ")"}]}], "+", 
          RowBox[{"0.16000000000000003`", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "5.360130369343619`*^-24"}], "+", 
             RowBox[{"0.0062679878472222325`", " ", "eta"}], "+", 
             RowBox[{"0.6400000000000001`", " ", 
              SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
          RowBox[{"0.02560000000000001`", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "3.981526692708337`*^-6"}], "+", 
             RowBox[{"0.6276929713541666`", " ", "eta"}], "+", 
             RowBox[{"1.`", " ", 
              SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
          RowBox[{"0.06400000000000002`", " ", 
           RowBox[{"(", 
            RowBox[{"9.79275173611112`*^-7", "+", 
             RowBox[{"0.22454068098958324`", " ", "eta"}], "+", 
             RowBox[{"1.6`", " ", 
              SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"0.4163055386726784`", "/", 
        RowBox[{"(", 
         RowBox[{"0.0040960000000000015`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.4`", " ", 
           RowBox[{"(", 
            RowBox[{"1.612896709105911`*^-35", "-", 
             RowBox[{"8.575306918825765`*^-15", " ", "eta"}]}], ")"}]}], "+", 
          
          RowBox[{"0.010240000000000006`", " ", 
           RowBox[{"(", 
            RowBox[{"0.0475247524752466`", "\[VeryThinSpace]", "+", 
             RowBox[{"51577.19916086659`", " ", "eta"}]}], ")"}]}], "+", 
          RowBox[{"0.16000000000000003`", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "6.19847766879273`*^-19"}], "+", 
             RowBox[{"724.8327936476832`", " ", "eta"}], "+", 
             RowBox[{"74009.87354180966`", " ", 
              SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
          RowBox[{"0.02560000000000001`", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "0.4604254484854432`"}], "+", 
             RowBox[{"72586.6834890697`", " ", "eta"}], "+", 
             RowBox[{"115640.42740907759`", " ", 
              SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
          RowBox[{"0.06400000000000002`", " ", 
           RowBox[{"(", 
            RowBox[{"0.11324379962748764`", "\[VeryThinSpace]", "+", 
             RowBox[{"25965.98032036074`", " ", "eta"}], "+", 
             RowBox[{"185024.68385452413`", " ", 
              SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}]}], "]"}]}], 
    "+", 
    RowBox[{"0.010000000000000009`", " ", 
     RowBox[{"Abs", "[", 
      RowBox[{"0.`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.25`", " ", 
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"0.001152000000000003`", " ", "eta"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"3.542013888888889`*^-8", "+", 
             RowBox[{"0.4`", " ", 
              RowBox[{"(", 
               RowBox[{"1.3947515978994914`*^-40", "-", 
                RowBox[{"7.415492238272908`*^-20", " ", "eta"}]}], ")"}]}], 
             "+", 
             RowBox[{"0.010240000000000006`", " ", 
              RowBox[{"(", 
               RowBox[{"4.109700520833252`*^-7", "+", 
                RowBox[{"0.4460135639105902`", " ", "eta"}]}], ")"}]}], "+", 
             RowBox[{"0.16000000000000003`", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "5.360130369343619`*^-24"}], "+", 
                RowBox[{"0.0062679878472222325`", " ", "eta"}], "+", 
                RowBox[{"0.6400000000000001`", " ", 
                 SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
             RowBox[{"0.02560000000000001`", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "3.981526692708337`*^-6"}], "+", 
                RowBox[{"0.6276929713541666`", " ", "eta"}], "+", 
                RowBox[{"1.`", " ", 
                 SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
             RowBox[{"0.06400000000000002`", " ", 
              RowBox[{"(", 
               RowBox[{"9.79275173611112`*^-7", "+", 
                RowBox[{"0.22454068098958324`", " ", "eta"}], "+", 
                RowBox[{"1.6`", " ", 
                 SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"0.004163055386726785`", "/", 
           RowBox[{"(", 
            RowBox[{"0.0040960000000000015`", "\[VeryThinSpace]", "+", 
             RowBox[{"0.4`", " ", 
              RowBox[{"(", 
               RowBox[{"1.612896709105911`*^-35", "-", 
                RowBox[{"8.575306918825765`*^-15", " ", "eta"}]}], ")"}]}], 
             "+", 
             RowBox[{"0.010240000000000006`", " ", 
              RowBox[{"(", 
               RowBox[{"0.0475247524752466`", "\[VeryThinSpace]", "+", 
                RowBox[{"51577.19916086659`", " ", "eta"}]}], ")"}]}], "+", 
             RowBox[{"0.16000000000000003`", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "6.19847766879273`*^-19"}], "+", 
                RowBox[{"724.8327936476832`", " ", "eta"}], "+", 
                RowBox[{"74009.87354180966`", " ", 
                 SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
             RowBox[{"0.02560000000000001`", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "0.4604254484854432`"}], "+", 
                RowBox[{"72586.6834890697`", " ", "eta"}], "+", 
                RowBox[{"115640.42740907759`", " ", 
                 SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
             RowBox[{"0.06400000000000002`", " ", 
              RowBox[{"(", 
               RowBox[{"0.11324379962748764`", "\[VeryThinSpace]", "+", 
                RowBox[{"25965.98032036074`", " ", "eta"}], "+", 
                RowBox[{"185024.68385452413`", " ", 
                 SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}]}], "]"}]}], "+", 
    RowBox[{"0.010000000000000009`", " ", 
     RowBox[{"Abs", "[", 
      RowBox[{"0.`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.6`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "0.004166666666666667`"}], " ", 
           RowBox[{"(", 
            RowBox[{"0.`", "\[VeryThinSpace]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"0.000011519999999999842`", " ", "eta"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"3.542013888888889`*^-8", "+", 
                RowBox[{"0.4`", " ", 
                 RowBox[{"(", 
                  RowBox[{"1.3947515978994914`*^-40", "-", 
                   RowBox[{"7.415492238272908`*^-20", " ", "eta"}]}], ")"}]}],
                 "+", 
                RowBox[{"0.010240000000000006`", " ", 
                 RowBox[{"(", 
                  RowBox[{"4.109700520833252`*^-7", "+", 
                   RowBox[{"0.4460135639105902`", " ", "eta"}]}], ")"}]}], 
                "+", 
                RowBox[{"0.16000000000000003`", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "5.360130369343619`*^-24"}], "+", 
                   RowBox[{"0.0062679878472222325`", " ", "eta"}], "+", 
                   RowBox[{"0.6400000000000001`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
                RowBox[{"0.02560000000000001`", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "3.981526692708337`*^-6"}], "+", 
                   RowBox[{"0.6276929713541666`", " ", "eta"}], "+", 
                   RowBox[{"1.`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
                RowBox[{"0.06400000000000002`", " ", 
                 RowBox[{"(", 
                  RowBox[{"9.79275173611112`*^-7", "+", 
                   RowBox[{"0.22454068098958324`", " ", "eta"}], "+", 
                   RowBox[{"1.6`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
             RowBox[{"0.4163055386726784`", "/", 
              RowBox[{"(", 
               RowBox[{"0.0040960000000000015`", "\[VeryThinSpace]", "+", 
                RowBox[{"0.4`", " ", 
                 RowBox[{"(", 
                  RowBox[{"1.612896709105911`*^-35", "-", 
                   RowBox[{"8.575306918825765`*^-15", " ", "eta"}]}], ")"}]}],
                 "+", 
                RowBox[{"0.010240000000000006`", " ", 
                 RowBox[{"(", 
                  RowBox[{"0.0475247524752466`", "\[VeryThinSpace]", "+", 
                   RowBox[{"51577.19916086659`", " ", "eta"}]}], ")"}]}], "+", 
                RowBox[{"0.16000000000000003`", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "6.19847766879273`*^-19"}], "+", 
                   RowBox[{"724.8327936476832`", " ", "eta"}], "+", 
                   RowBox[{"74009.87354180966`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
                RowBox[{"0.02560000000000001`", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "0.4604254484854432`"}], "+", 
                   RowBox[{"72586.6834890697`", " ", "eta"}], "+", 
                   RowBox[{"115640.42740907759`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
                RowBox[{"0.06400000000000002`", " ", 
                 RowBox[{"(", 
                  RowBox[{"0.11324379962748764`", "\[VeryThinSpace]", "+", 
                   RowBox[{"25965.98032036074`", " ", "eta"}], "+", 
                   RowBox[{"185024.68385452413`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"0.4166666666666667`", " ", 
           RowBox[{"(", 
            RowBox[{"0.`", "\[VeryThinSpace]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"0.001152000000000003`", " ", "eta"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"3.542013888888889`*^-8", "+", 
                RowBox[{"0.4`", " ", 
                 RowBox[{"(", 
                  RowBox[{"1.3947515978994914`*^-40", "-", 
                   RowBox[{"7.415492238272908`*^-20", " ", "eta"}]}], ")"}]}],
                 "+", 
                RowBox[{"0.010240000000000006`", " ", 
                 RowBox[{"(", 
                  RowBox[{"4.109700520833252`*^-7", "+", 
                   RowBox[{"0.4460135639105902`", " ", "eta"}]}], ")"}]}], 
                "+", 
                RowBox[{"0.16000000000000003`", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "5.360130369343619`*^-24"}], "+", 
                   RowBox[{"0.0062679878472222325`", " ", "eta"}], "+", 
                   RowBox[{"0.6400000000000001`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
                RowBox[{"0.02560000000000001`", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "3.981526692708337`*^-6"}], "+", 
                   RowBox[{"0.6276929713541666`", " ", "eta"}], "+", 
                   RowBox[{"1.`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
                RowBox[{"0.06400000000000002`", " ", 
                 RowBox[{"(", 
                  RowBox[{"9.79275173611112`*^-7", "+", 
                   RowBox[{"0.22454068098958324`", " ", "eta"}], "+", 
                   RowBox[{"1.6`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"0.004163055386726785`", "/", 
              RowBox[{"(", 
               RowBox[{"0.0040960000000000015`", "\[VeryThinSpace]", "+", 
                RowBox[{"0.4`", " ", 
                 RowBox[{"(", 
                  RowBox[{"1.612896709105911`*^-35", "-", 
                   RowBox[{"8.575306918825765`*^-15", " ", "eta"}]}], ")"}]}],
                 "+", 
                RowBox[{"0.010240000000000006`", " ", 
                 RowBox[{"(", 
                  RowBox[{"0.0475247524752466`", "\[VeryThinSpace]", "+", 
                   RowBox[{"51577.19916086659`", " ", "eta"}]}], ")"}]}], "+", 
                RowBox[{"0.16000000000000003`", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "6.19847766879273`*^-19"}], "+", 
                   RowBox[{"724.8327936476832`", " ", "eta"}], "+", 
                   RowBox[{"74009.87354180966`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
                RowBox[{"0.02560000000000001`", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "0.4604254484854432`"}], "+", 
                   RowBox[{"72586.6834890697`", " ", "eta"}], "+", 
                   RowBox[{"115640.42740907759`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}], "+", 
                RowBox[{"0.06400000000000002`", " ", 
                 RowBox[{"(", 
                  RowBox[{"0.11324379962748764`", "\[VeryThinSpace]", "+", 
                   RowBox[{"25965.98032036074`", " ", "eta"}], "+", 
                   RowBox[{"185024.68385452413`", " ", 
                    SuperscriptBox["eta", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}], "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.859134905205562*^9, {3.85913594489012*^9, 3.8591359992926207`*^9}, 
   3.8591360429333553`*^9, 3.859136075701198*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"c7b61eef-a5a0-4e85-97bc-9fa0311172eb"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{2272.2935779816517`, 910.8990825688073},
WindowMargins->{{0, Automatic}, {17.67272727272723, Automatic}},
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{LinterUIDockedCell`Private`notebook$$}, 
     GraphicsBox[{
       InsetBox[
        TemplateBox[{
          PaneBox[
           StyleBox[
           "\"Code Analysis\"", FontColor -> GrayLevel[0.4], FontFamily -> 
            "Source Sans Pro", FontWeight -> Plain, FontSize -> 13, 
            StripOnInput -> False], 
           BaselinePosition -> (Baseline -> Scaled[0.65])], 
          TemplateBox[{8}, "Spacer1"], 
          PaneBox[
           
           PaneSelectorBox[{{False, False} -> 
             TemplateBox[{0}, "Spacer1"], {True, False} -> 
             TemplateBox[{0}, "Spacer1"], {True, True} -> PaneBox[
               InterpretationBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "PercolateAnimator"][Medium]], 
                ProgressIndicator[Appearance -> "Percolate"], 
                BaseStyle -> {"Deploy"}], BaselinePosition -> Scaled[0.05]], {
              False, True} -> 
             DynamicModuleBox[{
               CodeInspector`LinterUI`Private`tracker$$ = 
                CodeInspector`LinterUI`Private`DynamicTriggers`\
dockedCellLintCounts}, 
               DynamicWrapperBox[
                DynamicBox[
                 ToBoxes[
                 CodeInspector`LinterUI`Private`tracker$$; 
                  LinterUIDockedCell`Private`dockedCellSeverityCountsButton[
                   LinterUIDockedCell`Private`notebook$$], TraditionalForm], 
                 TrackedSymbols :> {
                  CodeInspector`LinterUI`Private`tracker$$}], 
                If[
                CodeInspector`LinterUI`Private`tracker$$ =!= 
                 CodeInspector`LinterUI`Private`DynamicTriggers`\
dockedCellLintCounts, CodeInspector`LinterUI`Private`tracker$$ = 
                 CodeInspector`LinterUI`Private`DynamicTriggers`\
dockedCellLintCounts]], DynamicModuleValues :> {}]}, 
            Dynamic[FEPrivate`EvaluatorStatus["Local"]; {
               CodeInspector`LinterUI`Private`varValue[
               LinterUIDockedCell`Private`notebook$$, "AnalysisInProgressQ"], 
               
               TrueQ[
                CodeInspector`LinterUI`Private`varValue[
                LinterUIDockedCell`Private`notebook$$, 
                 "DockedCellPresentQ"]]}], ImageSize -> Automatic], 
           BaselinePosition -> Scaled[0.15]]}, "Row", 
         DisplayFunction -> (PaneBox[
           RowBox[{
             TemplateSlotSequence[1, "\[InvisibleSpace]"]}], Alignment -> 
           Baseline]& ), InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                TemplateSlotSequence[1, ","], "}"}], ",", 
              RowBox[{"Alignment", "\[Rule]", "Baseline"}]}], "]"}]& )], 
        Offset[{8, 0}, {-1, 0}], {-1, 0}], 
       InsetBox[
        PaneSelectorBox[{
         True -> DynamicModuleBox[{
            CodeInspector`LinterUI`Private`hoverQ$$ = False, 
             CodeInspector`LinterUI`Private`mouseDownQ$$ = False, 
             CodeInspector`LinterUI`Private`fontColor$$}, 
            ButtonBox[
             DynamicWrapperBox[
              TemplateBox[{
                DynamicWrapperBox[
                 StyleBox[
                  PaneBox[
                  "\"Reanalyze Notebook\"", ContentPadding -> True, 
                   FrameMargins -> None, BaselinePosition -> Baseline], 
                  FontColor -> 
                  Dynamic[CodeInspector`LinterUI`Private`fontColor$$], 
                  FontColor -> GrayLevel[0.2], FontFamily -> 
                  "Source Sans Pro", FontWeight -> Plain, FontSize -> 14, 
                  StripOnInput -> False], 
                 CodeInspector`LinterUI`Private`fontColor$$ = Which[
                   TrueQ[
                    Not[
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "ActiveQ"]]], 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "TextInactiveColor"], 
                   CodeInspector`LinterUI`Private`hoverQ$$, 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "TextHoverColor"], True, 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "TextColor"]]], ContentPadding -> False, 
                FrameMargins -> {{9, 9}, {0, 0}}, 
                Alignment -> {Center, Center}, ImageSize -> {Automatic, 19}, 
                RoundingRadius -> 3, FrameStyle -> Dynamic[
                  Directive[
                   AbsoluteThickness[0.5], 
                   Which[
                    TrueQ[
                    Not[
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "ActiveQ"]]], 
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "EdgeInactiveColor"], 
                    CodeInspector`LinterUI`Private`hoverQ$$, 
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "EdgeHoverColor"], True, 
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "EdgeColor"]]]], Background -> Dynamic[
                  Which[
                   TrueQ[
                    Not[
                    
                    OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "ActiveQ"]]], 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "BackInactiveColor"], 
                   And[
                   CodeInspector`LinterUI`Private`hoverQ$$, 
                    CodeInspector`LinterUI`Private`mouseDownQ$$], 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "BackMouseDownColor"], 
                   CodeInspector`LinterUI`Private`hoverQ$$, 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "BackHoverColor"], True, 
                   
                   OptionValue[{
                    ImageSize -> {Automatic, 19}, 
                    FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                    Baseline, Alignment -> {Center, Center}, Method -> 
                    "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                    "TextHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextHover"], "TextInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonTextInactive"], "BackColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                    "BackHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackHover"], "BackMouseDownColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackMouseDown"], "BackInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonBackInactive"], "EdgeColor" -> 
                    CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                    "EdgeHoverColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeHover"], "EdgeInactiveColor" -> 
                    CodeInspector`LinterUI`Private`colorData[
                    "ButtonEdgeInactive"]}, {Method -> "Queued"}, 
                    "BackColor"]]]}, "Highlighted"], 
              CodeInspector`LinterUI`Private`hoverQ$$ = 
               CurrentValue["MouseOver"]; 
              CodeInspector`LinterUI`Private`mouseDownQ$$ = 
               CurrentValue["MouseButtonTest"]], Appearance -> None, 
             BaselinePosition -> Baseline, ButtonFunction :> 
             If[OptionValue[{
                 ImageSize -> {Automatic, 19}, 
                  FrameMargins -> {9 {1, 1}, 0 {1, 1}}, BaselinePosition -> 
                  Baseline, Alignment -> {Center, Center}, Method -> 
                  "Preemptive", "ActiveQ" -> True, "TextColor" -> 
                  CodeInspector`LinterUI`Private`colorData["ButtonText"], 
                  "TextHoverColor" -> 
                  CodeInspector`LinterUI`Private`colorData["ButtonTextHover"],
                   "TextInactiveColor" -> 
                  CodeInspector`LinterUI`Private`colorData[
                   "ButtonTextInactive"], "BackColor" -> 
                  CodeInspector`LinterUI`Private`colorData["ButtonBack"], 
                  "BackHoverColor" -> 
                  CodeInspector`LinterUI`Private`colorData["ButtonBackHover"],
                   "BackMouseDownColor" -> 
                  CodeInspector`LinterUI`Private`colorData[
                   "ButtonBackMouseDown"], "BackInactiveColor" -> 
                  CodeInspector`LinterUI`Private`colorData[
                   "ButtonBackInactive"], "EdgeColor" -> 
                  CodeInspector`LinterUI`Private`colorData["ButtonEdge"], 
                  "EdgeHoverColor" -> 
                  CodeInspector`LinterUI`Private`colorData["ButtonEdgeHover"],
                   "EdgeInactiveColor" -> 
                  CodeInspector`LinterUI`Private`colorData[
                   "ButtonEdgeInactive"]}, {Method -> "Queued"}, "ActiveQ"] =!= 
               False, 
               CodeInspector`LinterUI`Private`attachAnalysisAction[
                EvaluationNotebook[]]], ContentPadding -> False, Evaluator -> 
             Automatic, Method -> "Queued"], DynamicModuleValues :> {}], 
          False -> ButtonBox[
            TemplateBox[{
              StyleBox[
              "\"Analyze Notebook\"", FontColor -> GrayLevel[0.2], FontFamily -> 
               "Source Sans Pro", FontWeight -> Plain, FontSize -> 14, 
               StripOnInput -> False], ImageSize -> {Automatic, 19}, 
              FrameMargins -> {{9, 9}, {0, 0}}, BaselinePosition -> Baseline, 
              Alignment -> {Center, Center}, Background -> GrayLevel[1], 
              FrameStyle -> Dynamic[
                If[
                 CurrentValue["MouseOver"], 
                 Hue[0.55, 0.82, 0.87], 
                 GrayLevel[0.8]]]}, "Highlighted"], Appearance -> False, 
            ButtonFunction :> (CurrentValue[
                EvaluationNotebook[], DockedCells] = 
              With[{LinterUIDockedCell`Private`dockedCells = CurrentValue[
                   EvaluationNotebook[], DockedCells]}, 
                Pick[LinterUIDockedCell`Private`dockedCells, 
                 Map[Quiet[
                    Options[#, CellTags]] =!= {
                   CellTags -> "CodeAnalysisDockedCell"}& , 
                  LinterUIDockedCell`Private`dockedCells]]]; 
             Needs["CodeInspector`"]; 
             CodeInspector`AttachAnalysis[
              LinterUIDockedCell`Private`notebook$$]), Evaluator -> Automatic,
             Method -> "Queued"]}, 
         Dynamic[FEPrivate`EvaluatorStatus["Local"]; TrueQ[
            CodeInspector`LinterUI`Private`varValue[
            LinterUIDockedCell`Private`notebook$$, "DockedCellPresentQ"]]], 
         ImageSize -> Automatic], 
        Offset[{-26, 0}, {1, 0}], {1, 0}], 
       TagBox[
        TagBox[
         TooltipBox[{{
            GrayLevel[0.6], 
            DiskBox[
             Offset[{-11, 0}, {1, 0}], 
             Offset[6]]}, {
            GrayLevel[0.97], 
            AbsoluteThickness[1.5], 
            CapForm["Round"], 
            LineBox[{{
               Offset[{-13, 2}, {1, 0}], 
               Offset[{-9, -2}, {1, 0}]}, {
               Offset[{-13, -2}, {1, 0}], 
               Offset[{-9, 2}, {1, 0}]}}]}}, "\"Close analysis\"", 
          TooltipDelay -> 0, TooltipStyle -> "TextStyling"], 
         Annotation[#, "Close analysis", "Tooltip"]& ], 
        EventHandlerTag[{"MouseClicked" :> (Map[NotebookDelete, 
             Flatten[
              CodeInspector`LinterUI`Private`varValue[
              LinterUIDockedCell`Private`notebook$$, All, 
               "UIAttachedCells"]]]; Map[NotebookDelete, 
             Flatten[
              CodeInspector`LinterUI`Private`varValue[
              LinterUIDockedCell`Private`notebook$$, All, 
               "CleanCellBracketMarker"]]]; CurrentValue[
              EvaluationNotebook[], DockedCells] = 
            With[{LinterUIDockedCell`Private`dockedCells = CurrentValue[
                 EvaluationNotebook[], DockedCells]}, 
              Pick[LinterUIDockedCell`Private`dockedCells, 
               Map[Quiet[
                  Options[#, CellTags]] =!= {
                 CellTags -> "CodeAnalysisDockedCell"}& , 
                LinterUIDockedCell`Private`dockedCells]]]; 
           CodeInspector`LinterUI`Private`applyToVar[Remove, {
              EvaluationNotebook[], All}]; 
           CodeInspector`LinterUI`Private`varSet[{
             LinterUIDockedCell`Private`notebook$$, "DockedCellPresentQ"}, 
             False]), Method -> "Preemptive", PassEventsDown -> Automatic, 
          PassEventsUp -> True}]]}, AspectRatio -> Full, 
      ImageSize -> {Full, 23}, PlotRange -> {{-1, 1}, {-1, 1}}], 
     Deinitialization :> 
     CodeInspector`LinterUI`Private`varSet[{
       LinterUIDockedCell`Private`notebook$$, "DockedCellPresentQ"}, False], 
     DynamicModuleValues :> {}, 
     Initialization :> ({
       LinterUIDockedCell`Private`dockedCellSeverityCountsButton[
          Pattern[LinterUIDockedCell`Private`notebook, 
           Blank[NotebookObject]]] := 
        With[{LinterUIDockedCell`Private`formatIcon = 
           Show[#, ImageSize -> {13, 9}, BaselinePosition -> Scaled[-0.2]]& }, 
          ActionMenu[
           Highlighted[
            Row[{
              CodeInspector`LinterUI`Private`lintSeverityCountsIconRow[
              LinterUIDockedCell`Private`notebook, "exclamSize" -> 12, 
               FontSize -> 14, FontWeight -> Plain], 
              Spacer[2], 
              LinterUIDockedCell`Private`formatIcon[
               CodeInspector`LinterUI`Private`iconData["DownChevron"][
                CodeInspector`LinterUI`Private`colorData["UIDark"]]]}], 
            ImageSize -> {Automatic, 19}, BaselinePosition -> Baseline, 
            Background -> White, Frame -> True, FrameStyle -> Dynamic[
              If[
               CurrentValue["MouseOver"], 
               Hue[0.55, 0.82, 0.87], 
               GrayLevel[0.8]]], FrameMargins -> {6 {1, 1}, {1, 1}}, 
            Alignment -> {Center, Baseline}], 
           Map[LinterUIDockedCell`Private`dockedCellMenuItem, 
            CodeInspector`LinterUI`Private`varValue[
            LinterUIDockedCell`Private`notebook, All, "Cell"]], Appearance -> 
           None]], LinterUIDockedCell`Private`dockedCellMenuItem[
          Pattern[LinterUIDockedCell`Private`cell, 
           Blank[CellObject]]] := With[{}, Graphics[{
             Inset[
              With[{LinterUIDockedCell`Private`expressionString = First[
                  FrontEndExecute[
                   FrontEnd`ExportPacket[
                    First[
                    CodeInspector`LinterUI`Private`varValue[
                    LinterUIDockedCell`Private`cell, "CellContents"]], 
                    "InputText"]]]}, {
               LinterUIDockedCell`Private`noLineBreaks = 
                StringReplace[
                 LinterUIDockedCell`Private`expressionString, "\n" -> " "]}, {
               LinterUIDockedCell`Private`previewString = 
                StringTake[LinterUIDockedCell`Private`noLineBreaks, {1, 
                   UpTo[LinterUIDockedCell`Private`$previewLength]}]}, 
               CodeInspector`LinterUI`Private`styleData["FixedWidth"][
                If[
                StringLength[LinterUIDockedCell`Private`expressionString] > 
                 LinterUIDockedCell`Private`$previewLength, 
                 StringDrop[LinterUIDockedCell`Private`previewString, -1] <> 
                 "\[Ellipsis]", 
                 LinterUIDockedCell`Private`previewString]]], {-1, 0}, {-1, 
              0}], 
             Inset[
              CodeInspector`LinterUI`Private`lintSeverityCountsIconRow[
              LinterUIDockedCell`Private`cell], {1, 0}, {1, 0}]}, 
            ImageSize -> {300, 25}, AspectRatio -> Full, 
            PlotRange -> {{-1, 1}, {-1, 1}}, ImagePadding -> None] :> (
           SelectionMove[LinterUIDockedCell`Private`cell, All, Cell]; 
           With[{LinterUIDockedCell`Private`nb = 
              ParentNotebook[LinterUIDockedCell`Private`cell]}, 
             FrontEndExecute[
              FrontEnd`FrontEndToken[
              LinterUIDockedCell`Private`nb, "OpenSelectionParents"]]]; 
           SelectionMove[LinterUIDockedCell`Private`cell, After, Cell])], 
        LinterUIDockedCell`Private`$previewLength = 28, 
        CodeInspector`LinterUI`Private`applyToVar[
          Pattern[CodeInspector`LinterUI`Private`function, 
           Blank[]], {
           Pattern[CodeInspector`LinterUI`Private`cell, 
            Blank[CellObject]], 
           Pattern[CodeInspector`LinterUI`Private`name, 
            Blank[String]]}, 
          Pattern[CodeInspector`LinterUI`Private`args, 
           BlankNullSequence[]]] := 
        Apply[CodeInspector`LinterUI`Private`function, 
          Join[
           ToHeldExpression[
            CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`cell, 
             CodeInspector`LinterUI`Private`name]], 
           Hold[CodeInspector`LinterUI`Private`args]]], Null, 
        CodeInspector`LinterUI`Private`applyToVar[
          Pattern[CodeInspector`LinterUI`Private`function, 
           Blank[]], {
           Condition[
            Pattern[CodeInspector`LinterUI`Private`cellOrNB, 
             Blank[]], 
            MatchQ[CodeInspector`LinterUI`Private`cellOrNB, 
             Alternatives[
              Blank[CellObject], 
              Blank[NotebookObject]]]], All}, 
          Pattern[CodeInspector`LinterUI`Private`args, 
           BlankNullSequence[]]] := 
        Map[Apply[CodeInspector`LinterUI`Private`function, 
           Join[
            ToHeldExpression[#], 
            Hold[CodeInspector`LinterUI`Private`args]]]& , 
          Names[
          CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`cellOrNB] <> "*"]], Null, 
        CodeInspector`LinterUI`Private`applyToVar[
          Pattern[CodeInspector`LinterUI`Private`function, 
           Blank[]], {
           Pattern[CodeInspector`LinterUI`Private`notebook, 
            Blank[NotebookObject]], All, 
           Pattern[CodeInspector`LinterUI`Private`name, 
            Blank[String]]}, 
          Pattern[CodeInspector`LinterUI`Private`args, 
           BlankNullSequence[]]] := 
        Map[Apply[CodeInspector`LinterUI`Private`function, 
           Join[
            ToHeldExpression[#], 
            Hold[CodeInspector`LinterUI`Private`args]]]& , 
          
          Names[(CodeInspector`LinterUI`Private`varNameString[
             CodeInspector`LinterUI`Private`notebook] <> "*") <> 
           CodeInspector`LinterUI`Private`name]], 
        CodeInspector`LinterUI`Private`varValue[
          Condition[
           Pattern[CodeInspector`LinterUI`Private`cellOrNB, 
            Blank[]], 
           MatchQ[CodeInspector`LinterUI`Private`cellOrNB, 
            Alternatives[
             Blank[CellObject], 
             Blank[NotebookObject]]]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := Symbol[
          CodeInspector`LinterUI`Private`varNameString[
          CodeInspector`LinterUI`Private`cellOrNB, 
           CodeInspector`LinterUI`Private`name]], Null, 
        CodeInspector`LinterUI`Private`varValue[
          Pattern[CodeInspector`LinterUI`Private`cell, 
           Blank[CellObject]], 
          Pattern[CodeInspector`LinterUI`Private`lint, 
           Blank[CodeInspector`InspectionObject]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := Symbol[
          CodeInspector`LinterUI`Private`varNameString[
          CodeInspector`LinterUI`Private`cell, 
           CodeInspector`LinterUI`Private`lint, 
           CodeInspector`LinterUI`Private`name]], Null, 
        CodeInspector`LinterUI`Private`varValue[
          Condition[
           Pattern[CodeInspector`LinterUI`Private`cellOrNB, 
            Blank[]], 
           MatchQ[CodeInspector`LinterUI`Private`cellOrNB, 
            Alternatives[
             Blank[CellObject], 
             Blank[NotebookObject]]]], All] := Map[Symbol, 
          Names[
          CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`cellOrNB] <> "*"]], Null, 
        CodeInspector`LinterUI`Private`varValue[
          Pattern[CodeInspector`LinterUI`Private`notebook, 
           Blank[NotebookObject]], All, 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := Map[Symbol, 
          
          Names[(CodeInspector`LinterUI`Private`varNameString[
             CodeInspector`LinterUI`Private`notebook] <> "*") <> 
           CodeInspector`LinterUI`Private`name]], 
        CodeInspector`LinterUI`Private`varSet[{
           Condition[
            Pattern[CodeInspector`LinterUI`Private`cellOrNB, 
             Blank[]], 
            MatchQ[CodeInspector`LinterUI`Private`cellOrNB, 
             Alternatives[
              Blank[CellObject], 
              Blank[NotebookObject]]]], 
           Pattern[CodeInspector`LinterUI`Private`name, 
            Blank[String]]}, 
          Pattern[CodeInspector`LinterUI`Private`value, 
           Blank[]]] := Apply[Set, 
          Append[
           ToHeldExpression[
            CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`cellOrNB, 
             CodeInspector`LinterUI`Private`name]], 
           CodeInspector`LinterUI`Private`value]], Null, 
        CodeInspector`LinterUI`Private`varSet[{
           Pattern[CodeInspector`LinterUI`Private`cell, 
            Blank[CellObject]], 
           Pattern[CodeInspector`LinterUI`Private`lint, 
            Blank[CodeInspector`InspectionObject]], 
           Pattern[CodeInspector`LinterUI`Private`name, 
            Blank[String]]}, 
          Pattern[CodeInspector`LinterUI`Private`value, 
           Blank[]]] := Apply[Set, 
          Append[
           ToHeldExpression[
            CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`cell, 
             CodeInspector`LinterUI`Private`lint, 
             CodeInspector`LinterUI`Private`name]], 
           CodeInspector`LinterUI`Private`value]], 
        CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`notebook, 
           Blank[NotebookObject]]] := ((
           "CodeInspector`LinterUI`Private`Vars`" <> "$$") <> 
          With[{CodeInspector`LinterUI`Private`nbID = 
             Last[CodeInspector`LinterUI`Private`notebook]}, 
            If[
             StringQ[CodeInspector`LinterUI`Private`nbID], 
             StringReplace[CodeInspector`LinterUI`Private`nbID, "-" -> "$"], 
             ToString[CodeInspector`LinterUI`Private`nbID]]]) <> "$$", Null, 
        CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`cell, 
           Blank[CellObject]]] := (
          CodeInspector`LinterUI`Private`varNameString[
            Replace[
             ParentNotebook[CodeInspector`LinterUI`Private`cell], $Failed -> 
             EvaluationNotebook[]]] <> 
          With[{CodeInspector`LinterUI`Private`cellID = 
             First[CodeInspector`LinterUI`Private`cell]}, 
            If[
             StringQ[CodeInspector`LinterUI`Private`cellID], 
             StringReplace[CodeInspector`LinterUI`Private`cellID, "-" -> "$"], 
             ToString[CodeInspector`LinterUI`Private`cellID]]]) <> "$$", Null,
         CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`notebook, 
           Blank[NotebookObject]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := 
        CodeInspector`LinterUI`Private`varNameString[
          CodeInspector`LinterUI`Private`notebook] <> 
         CodeInspector`LinterUI`Private`name, Null, 
        CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`cell, 
           Blank[CellObject]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := 
        CodeInspector`LinterUI`Private`varNameString[
          CodeInspector`LinterUI`Private`cell] <> 
         CodeInspector`LinterUI`Private`name, Null, 
        CodeInspector`LinterUI`Private`varNameString[
          Pattern[CodeInspector`LinterUI`Private`cell, 
           Blank[CellObject]], 
          Pattern[CodeInspector`LinterUI`Private`lint, 
           Blank[CodeInspector`InspectionObject]], 
          Pattern[CodeInspector`LinterUI`Private`name, 
           Blank[String]]] := ((
           CodeInspector`LinterUI`Private`varNameString[
            CodeInspector`LinterUI`Private`cell] <> Apply[Sequence, 
             Riffle[
              Map[StringDelete[
                ToString[#], 
                Alternatives["[", "]", "{", "}", ",", " "]]& , 
               CodeInspector`LinterUI`Private`extractFirstList[
                Last[CodeInspector`LinterUI`Private`lint][
                CodeParser`Source]]], "$"]]) <> "$$") <> 
         CodeInspector`LinterUI`Private`name, 
        CodeInspector`LinterUI`Private`extractFirstList[
          Pattern[CodeInspector`LinterUI`Private`expr, 
           Blank[]]] := FirstCase[CodeInspector`LinterUI`Private`expr, 
          Blank[List], {}, {0, Infinity}]}; 
      LinterUIDockedCell`Private`notebook$$ = EvaluationNotebook[]), 
     UnsavedVariables :> {LinterUIDockedCell`Private`notebook$$}]], 
   CellFrame -> {{0, 0}, {1, 1}}, CellFrameMargins -> {{0, 0}, {0, 0}}, 
   CellFrameColor -> GrayLevel[0.85], Background -> GrayLevel[0.97], CellTags -> 
   "CodeAnalysisDockedCell"]},
CellContext->Notebook,
Magnification:>1.4 Inherited,
FrontEndVersion->"13.0 for Linux x86 (64-bit) (February 4, 2022)",
StyleDefinitions->"ReverseColor.nb",
ExpressionUUID->"ceb4395d-c1a1-48a0-873a-513e4a6009a9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 479, 7, 44, "Text",ExpressionUUID->"051258ff-3da9-473b-961b-d8991c9fcfd8"],
Cell[CellGroupData[{
Cell[1062, 31, 2450, 58, 360, "Input",ExpressionUUID->"9200f06e-2e4b-41fc-9cec-a5e44c74ced5"],
Cell[3515, 91, 655, 18, 112, "Output",ExpressionUUID->"feef8f54-291c-4e49-be5c-fd6eadac3dee"],
Cell[4173, 111, 230, 5, 64, "Output",ExpressionUUID->"dd7a6186-7cdc-47a0-ab85-f31fc07604e9"]
}, Open  ]],
Cell[4418, 119, 644, 12, 152, "Text",ExpressionUUID->"f00c6723-8a59-4ce8-b39a-8a30f27313b1"],
Cell[CellGroupData[{
Cell[5087, 135, 1399, 29, 147, "Input",ExpressionUUID->"1ff5a37c-b6be-49fa-8a49-fb819b60f456"],
Cell[6489, 166, 1266, 23, 62, "Output",ExpressionUUID->"d2174db2-3461-4ac7-8ead-c3e64f1187e1"],
Cell[7758, 191, 1228, 22, 62, "Output",ExpressionUUID->"7853423b-1664-46e0-bdf5-aabd01602fbd"]
}, Open  ]],
Cell[9001, 216, 801, 14, 125, "Text",ExpressionUUID->"8f0e7ec0-96c9-4ff0-981f-a9c6d167f773"],
Cell[CellGroupData[{
Cell[9827, 234, 1941, 41, 89, "Input",ExpressionUUID->"258ff660-f673-4e34-9427-29cf1827dcd4"],
Cell[11771, 277, 2197, 37, 81, "Output",ExpressionUUID->"53e5048b-0071-46f7-8423-0900a5e579d9"],
Cell[13971, 316, 1883, 26, 64, "Output",ExpressionUUID->"bc1f926c-d3df-427e-8cd9-f43e083e5ad5"]
}, Open  ]],
Cell[15869, 345, 191, 3, 44, "Text",ExpressionUUID->"75b8c72f-2d74-4617-8089-b0f54a5a3590"],
Cell[CellGroupData[{
Cell[16085, 352, 477, 10, 59, "Input",ExpressionUUID->"ff4ec1e0-552c-42d3-8901-660991effba0"],
Cell[16565, 364, 845, 14, 64, "Output",ExpressionUUID->"662f0c57-ed97-42cc-a529-286e287b1e28"]
}, Open  ]],
Cell[17425, 381, 302, 7, 44, "Text",ExpressionUUID->"6f12a90b-2c19-4a0a-b8b2-949bc36f43b8"],
Cell[CellGroupData[{
Cell[17752, 392, 275, 6, 59, "Input",ExpressionUUID->"1e352f5e-57ab-49fe-a1f7-cd950e290ff8"],
Cell[18030, 400, 1208, 19, 64, "Output",ExpressionUUID->"f8b7c506-8c6b-434a-84c3-82b192987fdf"]
}, Open  ]],
Cell[19253, 422, 345, 5, 44, "Text",ExpressionUUID->"a91e696a-ae82-4d6c-98d2-7746c33acde2"],
Cell[CellGroupData[{
Cell[19623, 431, 424, 9, 41, "Input",ExpressionUUID->"9280df20-363a-4471-be59-cab979016558"],
Cell[20050, 442, 925, 16, 64, "Output",ExpressionUUID->"26c30dff-2ced-4365-92f5-4f473eea1a0d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21012, 463, 281, 5, 94, "Section",ExpressionUUID->"24d22338-4f57-408e-9bc5-fd8119da790b"],
Cell[21296, 470, 347, 5, 44, "Text",ExpressionUUID->"3fd1be11-f9e6-48ba-b827-bfb37d630993"],
Cell[21646, 477, 1586, 44, 175, "Input",ExpressionUUID->"d462b47b-84de-4678-a6a6-c6a743e09edc"],
Cell[23235, 523, 221, 4, 44, "Text",ExpressionUUID->"fed368d0-9bab-44b5-8f04-445405001d9e"],
Cell[CellGroupData[{
Cell[23481, 531, 339, 5, 89, "Input",ExpressionUUID->"f6efe44e-2ff4-44be-842d-59d4a9eb6e29"],
Cell[23823, 538, 5358, 150, 167, "Output",ExpressionUUID->"1ed536d6-b964-4fba-986d-428d51ba8e21"],
Cell[29184, 690, 665, 20, 83, "Output",ExpressionUUID->"1ca9096e-7c10-4592-9ae9-b093aa4dffc2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29898, 716, 218, 5, 74, "Subtitle",ExpressionUUID->"ce2dda6f-157c-4adf-ad25-bbda63fc0773"],
Cell[30119, 723, 254, 4, 44, "Text",ExpressionUUID->"79e268f3-be7e-4c40-bc27-1a621f7aee7c"],
Cell[CellGroupData[{
Cell[30398, 731, 420, 10, 59, "Input",ExpressionUUID->"271d4ff2-af80-43b5-bfd1-bcbfe286af55"],
Cell[30821, 743, 9943, 180, 322, "Output",ExpressionUUID->"2cdcc6e6-a64a-45ab-9929-a811c7af2d96"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40801, 928, 410, 10, 41, "Input",ExpressionUUID->"b503d023-292e-4203-b3dd-aa527fa12835"],
Cell[41214, 940, 1515, 23, 68, "Output",ExpressionUUID->"91438c07-dad1-459a-adb6-ed5b3c6022bb"]
}, Open  ]],
Cell[42744, 966, 310, 6, 44, "Text",ExpressionUUID->"f84e4aa6-fc91-47f3-a991-38fc37726de5"],
Cell[CellGroupData[{
Cell[43079, 976, 649, 13, 41, "Input",ExpressionUUID->"785d40cd-ae2d-41a6-b3ff-27146cf133d2"],
Cell[43731, 991, 5670, 110, 322, "Output",ExpressionUUID->"2a942c4f-6f0b-47fa-a826-3b21bb93ced3"]
}, Open  ]],
Cell[49416, 1104, 591, 11, 98, "Text",ExpressionUUID->"f30feaa7-a8c6-47db-ad28-2f4583c8d1f6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50044, 1120, 183, 3, 74, "Subtitle",ExpressionUUID->"e7986c6e-67fb-492e-9bab-5fff47f5842a"],
Cell[50230, 1125, 1144, 23, 59, "Input",ExpressionUUID->"657c17a8-2e27-4eea-9450-29788aada741"],
Cell[51377, 1150, 441, 6, 44, "Text",ExpressionUUID->"d412a640-b98e-4ed7-b3bc-60e38c2b05d9"],
Cell[CellGroupData[{
Cell[51843, 1160, 709, 15, 59, "Input",ExpressionUUID->"c1d58809-422a-4460-8893-63b2e361ce01"],
Cell[52555, 1177, 144499, 2369, 467, "Output",ExpressionUUID->"67acdcc9-3b52-4fba-8b96-e32512388afc"]
}, Open  ]],
Cell[197069, 3549, 1132, 19, 152, "Text",ExpressionUUID->"81d8ae8e-5370-4e57-8c66-f524d5af319b"],
Cell[CellGroupData[{
Cell[198226, 3572, 1881, 37, 147, "Input",ExpressionUUID->"a7d38b07-ea7d-4200-9578-0f1dd51517b9"],
Cell[200110, 3611, 403, 7, 64, "Output",ExpressionUUID->"4a1e08e8-693c-425c-a2f6-1cfcbeaf27ea"],
Cell[200516, 3620, 415, 7, 64, "Output",ExpressionUUID->"8a173909-0f44-4e7a-8689-2d152036856c"]
}, Open  ]],
Cell[200946, 3630, 197, 3, 44, "Text",ExpressionUUID->"7c61ea9c-bf1c-4012-a3ce-78710141b920"],
Cell[CellGroupData[{
Cell[201168, 3637, 2300, 44, 89, "Input",ExpressionUUID->"b3c7ec55-73ad-4c66-876f-8a4077a707bc"],
Cell[203471, 3683, 5636, 110, 348, "Output",ExpressionUUID->"127972bd-db3e-405e-9284-3a10d2a93912"],
Cell[209110, 3795, 5872, 113, 352, "Output",ExpressionUUID->"60bec7e6-7e96-44e2-9547-d38e7e1d5a24"]
}, Open  ]],
Cell[214997, 3911, 668, 11, 44, "Text",ExpressionUUID->"14035182-a51c-404b-9900-34742a9b2e9d"],
Cell[CellGroupData[{
Cell[215690, 3926, 1536, 27, 59, "Input",ExpressionUUID->"3d468050-6690-4733-a2d4-f1761432501e"],
Cell[217229, 3955, 20725, 451, 343, "Output",ExpressionUUID->"b255bbb7-8209-4520-80f3-e889f0ce7f5f"]
}, Open  ]],
Cell[237969, 4409, 211, 4, 44, "Text",ExpressionUUID->"7d69df47-b274-42a1-a509-99d70ecea140"],
Cell[CellGroupData[{
Cell[238205, 4417, 1028, 29, 89, "Input",ExpressionUUID->"1250353d-c313-453a-abd6-854636a3d760"],
Cell[239236, 4448, 206, 2, 64, "Output",ExpressionUUID->"e8f4184c-26b6-418a-bfae-d11e39ba8302"]
}, Open  ]],
Cell[239457, 4453, 298, 6, 44, "Text",ExpressionUUID->"c92ed012-fe59-4bbb-9e7d-b4c48a329970"],
Cell[239758, 4461, 423, 8, 44, "Text",ExpressionUUID->"b3c6e8ef-526e-44c3-805d-57184843dee7"],
Cell[CellGroupData[{
Cell[240206, 4473, 438, 7, 94, "Section",ExpressionUUID->"f6631038-6e0d-4fa0-9fc3-a22e10e7e4dc"],
Cell[240647, 4482, 596, 10, 44, "Text",ExpressionUUID->"781e69ff-ae2e-47c2-a9b8-803b543c56f9"],
Cell[241246, 4494, 1077, 26, 41, "Input",ExpressionUUID->"91a7a380-e38c-406f-ab1a-c56973896108"],
Cell[CellGroupData[{
Cell[242348, 4524, 1115, 35, 41, "Input",ExpressionUUID->"9d903d60-fb8a-44c1-8699-9bc85347d342"],
Cell[243466, 4561, 1556, 26, 39, "Message",ExpressionUUID->"10721ccd-1614-453e-8b37-8c4d6feada1d"],
Cell[245025, 4589, 1411, 22, 64, "Output",ExpressionUUID->"178d7324-3d4e-43f8-b774-b5ee7b7e7d1c"]
}, Open  ]],
Cell[246451, 4614, 445, 8, 44, "Text",ExpressionUUID->"07b0dbc9-e704-4456-858b-31ec8a272c18"],
Cell[246899, 4624, 381, 8, 44, "Text",ExpressionUUID->"7ec1adc8-f7b5-4878-b935-d505cf9288c9"],
Cell[CellGroupData[{
Cell[247305, 4636, 417, 9, 41, "Input",ExpressionUUID->"227e5088-edcb-4bdc-8e09-badd8cc691b7"],
Cell[247725, 4647, 8515, 156, 322, "Output",ExpressionUUID->"d09be896-2d06-4d62-8f5f-5754284ea44e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[256277, 4808, 180, 2, 41, "Input",ExpressionUUID->"8a31dad5-469b-4b6f-b640-029ffd076c44"],
Cell[256460, 4812, 225, 3, 64, "Output",ExpressionUUID->"fd2e3329-b034-4d4f-9900-5564238320ea"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[256734, 4821, 201, 4, 94, "Section",ExpressionUUID->"fe3949d1-6493-4dac-834b-ce85d5e2f7bb"],
Cell[256938, 4827, 211, 5, 44, "Text",ExpressionUUID->"8549b696-933e-4054-bc57-d3026fb9ea4d"],
Cell[CellGroupData[{
Cell[257174, 4836, 313, 6, 41, "Input",ExpressionUUID->"2d06eb61-1781-450f-9076-734db10ebebf"],
Cell[257490, 4844, 476, 12, 64, "Output",ExpressionUUID->"c7b8a68d-5d3c-4baa-ac37-02ff4fc0666c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[258003, 4861, 256, 5, 41, "Input",ExpressionUUID->"41542878-eb14-41d3-9004-67c1faddf037"],
Cell[258262, 4868, 411, 10, 64, "Output",ExpressionUUID->"31560b48-9759-4a86-921e-a91ecc9744dd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[258710, 4883, 476, 11, 41, "Input",ExpressionUUID->"fde904ea-cd82-4215-b345-4762b26249c9"],
Cell[259189, 4896, 350, 10, 62, "Output",ExpressionUUID->"938da3b5-5221-4be7-a07c-2465c6f45332"]
}, Open  ]],
Cell[CellGroupData[{
Cell[259576, 4911, 354, 6, 41, "Input",ExpressionUUID->"8f41a843-89bf-4800-85f3-b697677a258e"],
Cell[259933, 4919, 241, 3, 64, "Output",ExpressionUUID->"606cf37e-f329-41ed-bcab-7f616437225c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[260211, 4927, 337, 8, 41, "Input",ExpressionUUID->"7681342d-4943-4d81-971f-b9fc49a3af7a"],
Cell[260551, 4937, 687, 17, 87, "Output",ExpressionUUID->"a49c8c21-248b-4c78-8bfa-b470bfdbbd84"]
}, Open  ]],
Cell[CellGroupData[{
Cell[261275, 4959, 869, 24, 147, "Input",ExpressionUUID->"0ac53d39-cee1-4081-9c21-653a48dc6996"],
Cell[262147, 4985, 2549, 61, 348, "Output",ExpressionUUID->"36755eae-c032-48a5-9dd0-aac4008f5a34"],
Cell[264699, 5048, 4491, 92, 347, "Output",ExpressionUUID->"655c6f36-c8e3-4478-bb93-be9034e008c2"],
Cell[269193, 5142, 17899, 373, 1264, "Output",ExpressionUUID->"c7b61eef-a5a0-4e85-97bc-9fa0311172eb"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

