p_list = [0.1 0.3 0.5 0.7 0.9];

for p = p_list
    simulation3_rebuttal(50, 10, p, 20);
end

res = readtable('rebuttal_result.csv');
res = res{:,:};
[~,I] = sort(res(:, 3)); res = res(I,:);

figure;
p = res(:, 3); er_rate = res(:, 4);
plot(p, er_rate, '-o', 'LineWidth', 1, 'Color', [1 0.3 0])
hold on
p = res(:, 3); er_rate = res(:, 5);
plot(p, er_rate, '-^', 'LineWidth', 1, 'Color', [0.2 0.7 0.2])
hold on
p = res(:, 3); er_rate = res(:, 6);
plot(p, er_rate, '-x', 'LineWidth', 1, 'Color', [0 0.3 1])
hold off
xlabel('p', 'FontSize', 13); ylabel('Exact recovery rate', 'FontSize', 13); 
ylim([0, 1]); xlim([0.1, 0.9]); xticks([0.1 0.3 0.5 0.7 0.9]);

legend({'SDP', 'DTSPCA', 'ITSPCA'}, 'location', 'southeast', 'FontSize', 13);

figure;
p = res(:, 3); er_rate = res(:, 4);
plot(p, er_rate, '-o', 'LineWidth', 1, 'Color', [1 0.3 0])
hold on
p = res(:, 3); er_rate = res(:, 7);
plot(p, er_rate, '-x', 'LineWidth', 1, 'Color', [0.7 0.1 0.7])
hold off
xlabel('p', 'FontSize', 13); ylabel('Exact recovery rate', 'FontSize', 13); 
ylim([0, 1]); xlim([0.1, 0.9]); xticks([0.1 0.3 0.5 0.7 0.9]);

legend({'SDP', 'SDP with imputation'}, 'location', 'southeast', 'FontSize', 13);
