using JLD2, Plots

include("Muscada.jl")
include("Hedge.jl")
include("bimat.jl")



# standard worst-case online learning bound on regret per round
# NB: this is with knowledge of T up front
wcbd(σ, K, T) = σ*sqrt(2*log(K)/T)

# worst-case gap bound from row and column worst-case regret bounds
wcbd(T) = wcbd(maximum(σrow), log(length(σrow)), T) + wcbd(maximum(σcol), length(σcol), T)

# gap bound in the pretty-happy-case that the effective range is smaller
happy(T) = wcbd(maximum(σrow[pstar .> 1e-5]), log(length(σrow)), T) + wcbd(maximum(σcol[qstar .> 1e-5]), length(σcol), T)

#Owcbd(σ, K, T) = σ*log(K)/T; # TODO: triple double check this
# worst-case gap bound from row and column worst-case regret bounds
Owcbd(T) =  4*max(maximum(σrow), maximum(σcol))*(log(length(σrow))+log(length(σcol)))/T

Ohappy(T) = 4*max(maximum(σrow[pstar .> 1e-5]), maximum(σcol[qstar .> 1e-5]))*(log(length(σrow))+log(length(σcol)))/T




@load "games.jld2"

# make the plot

# title="Saddle Point Gap",
plot(xlabel="Rounds(t)", ylabel="Saddle Point Gap", scale=:log10, legend=:topright)


for (colid, (P, Q, pbar, qbar, itgap, avgap, tune1, optimistic, rangeadaptive, regh)) in enumerate(res)

    lbl = if regh
        "Hedge’(1/√t)"
    else
        #namea = if optimistic "O" else "P" end
        nameb = if tune1 "H₁" else "H₂" end
        namec = if rangeadaptive "A" else "N" end
        namec = if rangeadaptive "(σ)" else "(σₘₐₓ)" end
        "Tuning₃’$namec"
    end

    if !regh
        plot!(Tstep, avgap[Tstep], label="$lbl", lc=colid)
        #plot!(Tstep, itgap[Tstep], label="$lbl last", linestyle=:dot, lc=colid)
    end
end

#plot!(Tstep, wcbd, label="Classic σmax/√t bound", style=:dash)
#plot!(Tstep, happy, label="σmax(support) bound", style=:dash)

plot!(Tstep, Owcbd, label="σₘₐₓ/t bound", style=:dash, lc=1)
plot!(Tstep, Ohappy, label="σᵣₑₐₗ/t bound", style=:dash, lc=2)


plot!(ylim=(1e-6, 1e3), xticks=[1, 10^1, 10^3, 10^5, 10^7], xrange=(1,T))

plot!(size=div.((600,400).*3,5))

# export
savefig("graph_games.pdf")

# and reshow
gui()
