load('data/exp2.mat','Gap_p7','ErrX_p7')

l = 100;
t = 3e-5;
Gap_p7 = Gap_p7(:,1:l);
noise = 0:.02:.2;

col = [0,0,1];

% Figure
hf = figure(2);
hf3 = hf;
clf
ax = tight_subplot(1,1,.0,[.14,.09],[.16,.03]);
axes(ax);
% ax = gca;

% Computations
y = mean(Gap_p7<t,2)*100;
y = conv([y(1);y;y(end)],[1 1 1]/3,'valid');

% Draw plot
hold on
hPlot = plot(noise,y,'o-b','MarkerFaceColor', 'b');
hold off

% Plot properties
set(hPlot,...
    'LineStyle','--',...
    'Color',.5*col,...
    'Marker', 'o',...
    'MarkerSize',7,...
    'LineWidth',2.8,...
    'MarkerFaceColor',col,...
    'MarkerEdgeColor',.5*col)

set(ax,...
    'XLim', [-.001,.2+.001],...
    'YLim', [0,100],...
    'XTickLabel', {'0.04','0.08','0.12','0.16','0.2'},...
    'YTickLabel', {'0','20','40','60','80','100'});
hXLabel = xlabel('Noise magnitude (\sigma)');
hYLabel = ylabel('Experiments solved (%)');

hTitle = title('n = 50,   m = 28,   p = r = 7');

set(ax, ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'Xtick'       , .04:.04:.2, ...
  'YTick'       , 0:20:100, ...
  'YColor'      , [.3 .3 .3], ...
  'Layer'       ,'top', ....
  'LineWidth'   , 2.5         );

% fonts
set(ax,'FontName', 'Helvetica', 'FontSize', 22);
set([hXLabel, hYLabel], 'FontName', 'AvantGarde', 'FontSize', 24);
set( hTitle, ...
    'FontName', 'TeX Gyre Bonum Math',...
    'FontSize', 24, ...
    'FontWeight' , 'normal');

% figure properties
pause(.1)
set(hf,...
    'Color', [1,1,1],...
    'Renderer', 'painters',...
    'Units', 'inches',...
    'PaperPositionMode', 'auto')
% set(hf,'WindowStyle','normal','InnerPosition', [10 4 7 7]);

% print('exp3.png','-dpng','-r300')