%% Anti-symm SVD online by deflation, a-la GHA (Sanger 89) 
% version expressed in x, y, not chi
function [u,v]=skewGhaXYStep(x,y,u,v,eta)
    [len,kk]=size(u);
    xCumul=zeros(len,1);
    yCumul=zeros(len,1);
    for k=1:kk
        ax=u(:,k)'*x; ay=u(:,k)'*y;
        bx=v(:,k)'*x; by=v(:,k)'*y;
        z = ay*bx - ax*by;
        u(:,k) = u(:,k) + eta*( bx*(y-yCumul) - by*(x-xCumul) - z*u(:,k) );
        v(:,k) = v(:,k) - eta*( ax*(y-yCumul) - ay*(x-xCumul) + z*v(:,k) );
%         u(:,k) = u(:,k) + eta*( bx*y-by*x - z*u(:,k) - bx*yCumul + by*xCumul);
%         v(:,k) = v(:,k) - eta*( ax*y-ay*x + z*v(:,k) - ax*yCumul + ay*xCumul);
        xCumul = xCumul + ax*u(:,k) + bx*v(:,k);
        yCumul = yCumul + ay*u(:,k) + by*v(:,k);
    end
end

