#!/bin/sh


input_mesh_dir="/***/DeformingThings4D_processed/animals"
output_data_dir="/***/DeformingThings4D_processed_dataset/animals"
max_threads=12
mesh_format="obj"


temp_lst="/****/DeformingThings4D_processed_dataset/animals/template_seq_identity.lst"
filter_lst="/*/DeformingThings4D_processed_dataset/animals/train.lst"

python dataset/generate_dataset_animals_seq.py --input_mesh_dir="${input_mesh_dir}" --output_data_dir="${output_data_dir}" --max_threads=${max_threads} \
     --mesh_format "${mesh_format}" --filter_lst "${filter_lst}"

python dataset/generate_dataset_animal_flow.py --input_mesh_dir="${input_mesh_dir}" --output_data_dir="${output_data_dir}" --max_threads=${max_threads} \
     --mesh_format "${mesh_format}"  --temp_lst "${temp_lst}"

python dataset/generate_dataset_animal_surfaceflow.py --input_mesh_dir="${input_mesh_dir}" --output_data_dir="${output_data_dir}" --max_threads=${max_threads} \
     --mesh_format "${mesh_format}"  --temp_lst "${temp_lst}"
