# Exploring Figure-Ground Assignment Mechanism in Perceptual Organization

## 📋 Table of content
 1. [📎 Paper Link](#1)
 2. [📃 Requirements](#2)
 3. [📂 Toy Figure-Ground Dataset](#3)
 4. [✏️ Usage](#4)
 5. [📊 Results](#5)
 6. [✉️ Statement](#6)
 7. [🔍 Citation](#7)

## 📎 Paper Link <a name="1"></a> 
Exploring Figure-Ground Assignment Mechanism in Perceptual Organization ([link]())
> **Authors:** Wei Zhai, Yang Cao, Jing Zhang and Zheng-Jun Zha.

## 📃 Requirements <a name="2"></a>

- Python == 3.7 
- Pytorch == 1.7.0 ([pytorch.org](http://pytorch.org))
- Torchvision == 0.5.0
- Cuda ==11.0 ([cuda](https://developer.nvidia.com/zh-cn/cuda-toolkit))

## 📂 Generating Toy Figure-Ground Dataset <a name="3"></a>

Need to download:
- Pascal VOC dataset ([http://host.robots.ox.ac.uk/pascal/VOC/](http://host.robots.ox.ac.uk/pascal/VOC/))
- Describable Textures Dataset ([https://www.robots.ox.ac.uk/~vgg/data/dtd/](https://www.robots.ox.ac.uk/~vgg/data/dtd/))

Create Easy Set:
```bash
python extractor.py --level E --PascalDir ${Pascal Dir} --DTDDir ${DTD Dir} --SaveDir ${Save Dir}
```

Create Normal Set:
```bash
python extractor.py --level N --PascalDir ${Pascal Dir} --DTDDir ${DTD Dir} --SaveDir ${Save Dir}
```

Create Hard Set:
```bash
python extractor.py --level H --PascalDir ${Pascal Dir} --DTDDir ${DTD Dir} --SaveDir ${Save Dir}
```

## ✏️ Usage <a name="4"></a> 

### Training

To train a model on Easy(E)/Normal(N)/Hard(H) Set, run `Train.py` with the desired model:
```bash
python Train.py --batch_size_train 16 --accumulation_steps 1 --check_ite 6000 --lr 0.0001 --step_size 50 --begin_ite 6000 --noFG 1 --level E
```

### Testing

To test a model, run `Test.py` with the desired model on different datasets:

```bash
python Test.py --modelname ${model_name} --batchsize 4
```

## 📊 Experiment <a name="5"></a> 

See Paper

## ✉️ Statement <a name="6"></a> 

For other questions please contact wzhai056@mail.ustc.edu.cn.

## 🔍 Citation <a name="7"></a> 

None.