def GetDistributionParams(model, p):
    """
    Returns parameters for generating different data distributions
    """
    params = dict()
    params["model"] = model
    params["p"] = p
    if model == "gaussian":
        params["rho"] = 0.5
    elif model == "gmm":
        params["rho-list"] = [0.3, 0.5, 0.7]
    elif model == "mstudent":
        params["df"] = 3
        params["rho"] = 0.5
    elif model == "sparse":
        params["sparsity"] = int(0.3 * p)
    else:
        raise Exception("Unknown model generating distribution: " + model)

    return params


def GetTrainingHyperParams(model):
    """
    Returns the default hyperparameters for training deep knockoffs
    as described in the paper
    """
    params = dict()

    params["GAMMA"] = 1.0
    if model == "gaussian":
        params["LAMBDA"] = 1.0
        params["DELTA"] = 1.0
    elif model == "gmm":
        params["LAMBDA"] = 1.0
        params["DELTA"] = 1.0
    elif model == "mstudent":
        params["LAMBDA"] = 0.01
        params["DELTA"] = 0.01
    elif model == "sparse":
        params["LAMBDA"] = 0.1
        params["DELTA"] = 1.0
    else:
        raise Exception("Unknown data distribution: " + model)

    return params


def GetFDRTestParams(model):
    """
    Returns the default hyperparameters for performing controlled
    variable selection experiments as described in the paper
    """
    params = dict()
    # Test parameters for each model
    if model in ["gaussian", "gmm"]:
        params["n"] = 150
        params["elasticnet_alpha"] = 0.1
    elif model in ["mstudent"]:
        params["n"] = 200
        params["elasticnet_alpha"] = 0.0
    elif model in ["sparse"]:
        params["n"] = 200
        params["elasticnet_alpha"] = 0.0

    return params
