total_time = 1024;
d_range = [2 : 9];
error_probs1 = zeros(length(d_range), 4);
times =  zeros(length(d_range), 4);
stats = zeros(length(d_range), 5);
for ii = 1 : length(d_range)
    d = d_range(ii);
    error_prob1 = zeros(total_time, 1);
    error_prob2 = zeros(total_time, 1);
    error_prob3 = zeros(total_time, 1);
    error_prob4 = zeros(total_time, 1);
    stat = zeros(total_time, 5);
    for jj = 1 : total_time
        K = 3 ^ d;
        T = 2 * K;
        [theta, A] = sphere_data_generator(d, K);
        [delta_min, H1lin, H1, H2lin, H2] = data_stat(theta, A);
        stat(jj, :) = [delta_min, H1lin, H1, H2lin, H2];
        [~ , I] = max(theta' * A);
        tic;
        best_arm = myalgo(theta, A, T);
        times(ii, 1) = times(ii, 1) + toc;
        if I ~= best_arm
            error_prob1(jj) = 1;
        end
        tic;
        best_arm = Sequential_Halving(theta, A, T);
        times(ii, 2) = times(ii, 2) + toc;
        if I ~= best_arm
            error_prob2(jj) = 1;
        end
        tic;
        best_arm = BayesGap_Oracle(theta, A, T);
        times(ii, 3) = times(ii, 3) + toc;
        if I ~= best_arm
            error_prob3(jj) = 1;
        end
        tic;
        best_arm = BayesGap_Adaptive(theta, A, T);
        times(ii, 4) = times(ii, 4) + toc;
        if I ~= best_arm
            error_prob4(jj) = 1;
        end
        [jj, d]
    end
    error_probs1(ii, :) = sum([error_prob1, error_prob2, error_prob3, error_prob4]) / total_time;
    stats(ii, :) = mean(stat);
end

times = times / total_time
% figure;
% bar(d_range, error_probs1);
% xlabel('d');
% ylabel('Error probability');
% legend({'OD-LinBAI', 'Sequential Halving', 'BayesGap-Oracle', 'BayesGap-Adaptive'}, 'Location', 'southeastoutside');
% ylim([0 1]);

%save('c=3_time.mat','times')
