from __future__ import absolute_import
from __future__ import division
from __future__ import print_function


class MultiAgentEnv(object):

    def step(self, actions):
        """Returns reward, terminated, info."""
        raise NotImplementedError

    def get_obs(self):
        """Returns all agent observations in a list."""
        raise NotImplementedError

    def get_obs_agent(self, agent_id):
        """Returns observation for agent_id."""
        raise NotImplementedError

    def get_obs_size(self):
        """Returns the size of the observation."""
        raise NotImplementedError

    def get_state(self):
        """Returns the global state."""
        raise NotImplementedError

    def get_state_size(self):
        """Returns the size of the global state."""
        raise NotImplementedError

    def get_avail_actions(self):
        """Returns the available actions of all agents in a list."""
        raise NotImplementedError

    def get_avail_agent_actions(self, agent_id):
        """Returns the available actions for agent_id."""
        raise NotImplementedError

    def get_total_actions(self):
        """Returns the total number of actions an agent could ever take."""
        raise NotImplementedError

    def reset(self):
        """Returns initial observations and states."""
        raise NotImplementedError

    def render(self):
        raise NotImplementedError

    def close(self):
        raise NotImplementedError

    def seed(self):
        raise NotImplementedError

    def save_replay(self):
        """Save a replay."""
        raise NotImplementedError

    def get_env_info(self):
        if hasattr(self, 'env_name') and self.env_name in ['HalfCheetah_6x1', 'Hopper_3x1', 'Humanoid_17x1', 'Walker_6x1']:
            env_info = {"state_shape": self.get_state_size(),
                        "obs_shape": self.get_obs_size(),
                        "n_actions": self.get_total_actions(),
                        "n_agents": self.n_agents,
                        "episode_limit": self.episode_limit}
        elif hasattr(self, 'env_name') and self.env_name in ['Academy_3_vs_1_with_Keeper', 'Academy_Pass_and_Shoot_with_Keeper', 'Academy_Run_Pass_and_Shoot_with_Keeper']:
            env_info = {"state_shape": self.get_state_size(),
                        "obs_shape": self.get_obs_size(),
                        "n_actions": self.get_total_actions(),
                        "n_agents": self.n_agents,
                        "episode_limit": self.episode_limit,
                        "unit_dim": self.unit_dim}
        else:
            env_info = {"state_shape": self.get_state_size(),
                        "obs_shape": self.get_obs_size(),
                        "n_actions": self.get_total_actions(),
                        "n_agents": self.n_agents,
                        "episode_limit": self.episode_limit,
                        "n_self_feature": self.get_self_feature_size(),
                        "n_enemies": self.n_enemies,
                        "unit_dim": self.unit_dim}
        return env_info
