% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{COLP}
\alias{COLP}
\title{Causal Discovery for Bivariate Cateogrical Data}
\usage{
COLP(y, x, algo = "E")
}
\arguments{
\item{y}{factor, a potential effect variable}

\item{x}{factor, a potential cause variable}

\item{algo}{exhaustive search (algo="E") of category ordering or greedy search (algo="G")}
}
\value{
A list of length 3. cd = 1 if x causes y; cd = 0 otherwise. P is the optimal odering of the effect variable. epsilon is the difference in log-likelihood favoring x causes y.
}
\description{
Estimate a causal directed acyclic graph (DAG) for ordinal cateogrical data with greedy or exhaustive search.
}
\examples{
fit = COLP(CatPairs[[1]][[1]]$Diffwt,CatPairs[[1]][[1]]$Treat,algo="E")
fit$cd
}
