# using
using Dates
using Logging
using CSV

# BLAS.set_num_threads(16)
include("../src/utils.jl")
# include("../src/pd_alg_restart_sparse.jl")
include("../src/OADS_restart.jl")
include("../src/FISTA_restart.jl")
include("../src/SI_NNLS_restart.jl")

DATASET_INFO = Dict([
    ("mnist", (60000, 780, "data/mnist")),
    ("E2006test", (3308, 150360, "data/E2006test")),
    ("E2006train", (16087 , 150360, "data/E2006train")),
    ("news20", (19996, 1355191, "data/news20.binary")),
    ("real-sim", (72309, 20958, "data/real-sim")),
    # ("rcv1", (47236, 20242)),
])
# load data
# dataset = "real-sim"
# dataset = "news20"
dataset = "E2006train"
# dataset = ARGS[1]
n, d, path = DATASET_INFO[dataset]
# data =  read_libsvm(path, n, d)
C, b =  read_libsvm_into_sparse(path, n, d)
rows, columns, values = findnz(C)

# function check_negative_b(b)
#     for i in 1:length(b)
#         if b[i] < 0
#             @info "i: $(b[i])"
#         end
#     end
# end
#
# check_negative_b(b)

# b = b .+ 2
# function check_negative(values)
#     glo_t = 0
#     for v in values
#         if v < 0
#             @info "a negative value! t: $glo_t "
#             glo_t += 1
#         end
#     end
#     @info "positive values! "
# end
#
# check_negative(values)

# normalize data
# labels[:] = labels[:] .+ 2
# @info "labels: $labels"
# run our algorithm without restart

# run our algorithm with restart
# m = 60000, x < 780
#

C, C_b, non_zero_col_norm = reformulation_sparsev4(C, b)
@info "reformulated!"
m, n = size(C)
x0_ = zeros(n)
C_x0_ = C * x0_

outputdir = "./results"
# filepath = "./data/$(dataset).txt"
timestamp = Dates.format(Dates.now(), "yyyy-mm-dd_HH-MM-SS-sss")
# loggingfilename = "$records/$(dataset)-$(join(ARGS[3:end], "_"))-execution_log-$(timestamp).txt"
# io = open(loggingfilename, "w+")
# logger = SimpleLogger(io)

println("timestamp = $(timestamp)")
println("Completed initialization.")
total_time = 3600.0
num_restart = 2000
ϵ = 1e-7
# with_logger(logger) do


    begin
        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 20
        restart_ratio = 0.0
        bs = 1

        @info "SI_NNLS (bs=$bs) without Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"
        file_path = "$(outputdir)/$(dataset)_SINNLS_nonrestart_$(bs)_$(timestamp).csv"
        SI_NNLS_restart_v3(C, b, C_b, x0, C_x0, bs, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end


    begin
        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 20
        restart_ratio = 0.7
        bs = 1
        @info "SI_NNLS (bs=$bs) without Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"
        file_path = "$(outputdir)/$(dataset)_SINNLS_restart_$(bs)_$(timestamp).csv"
        SI_NNLS_restart_v3(C, b, C_b, x0, C_x0, bs, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end

    begin
        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 20
        restart_ratio = 0.7
        bs = 10
        @info "SI_NNLS (bs=$bs) with Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"
        file_path = "$(outputdir)/$(dataset)_SINNLS_restart_$(bs)_$(timestamp).csv"
        SI_NNLS_restart_v3(C, b, C_b, x0, C_x0, bs, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end


    begin

        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 20
        restart_ratio = 0.7
        bs = 50
        @info "SI_NNLS (bs=$bs) with Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"
        file_path = "$(outputdir)/$(dataset)_SINNLS_restart_$(bs)_$(timestamp).csv"
        SI_NNLS_restart_v3(C, b, C_b, x0, C_x0, bs, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end

    begin
        @info "OADS without Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"

        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 100
        restart_ratio = 0.0
        file_path = "$(outputdir)/$(dataset)_OADS_nonrestart_$(timestamp).csv"
        OADS_restart_v2(C, b, C_b, x0, C_x0, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end

    #
    # begin
    #     @info "OADS with Restart Running on $(dataset) dataset."
    #     @info "--------------------------------------------------"
    #
    #     x0 = x0_[:]
    #     C_x0 = C_x0_[:]
    #     K = 100000
    #     freq = 100
    #     restart_ratio = 0.7
    #     file_path = "$(outputdir)/$(dataset)_OADS_restart_$(timestamp).csv"
    #     OADS_restart_v2(C, b, C_b, x0, C_x0, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    # end

    # begin
    #     @info "FISTA with Restart Running on $(dataset) dataset."
    #     @info "--------------------------------------------------"
    #
    #     x0 = x0_[:]
    #     C_x0 = C_x0_[:]
    #     K = 100000
    #     # total_time = 1000.0
    #     # num_restart = 1000
    #     freq = 100
    #     restart_ratio = 0.7
    #     file_path = "$(outputdir)/$(dataset)_FISTA_restart_$(timestamp).csv"
    #     FISTA_restart_v2(C, b, C_b, x0, C_x0, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    #
    # end

    begin
        @info "FISTA without Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"

        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 100
        restart_ratio = 0.0
        file_path = "$(outputdir)/$(dataset)_FISTA_nonrestart_$(timestamp).csv"
        FISTA_restart_v2(C, b, C_b, x0, C_x0, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end

    #
    # K = 10000 * n
    # freq = 100
    #
    # blocksize = 1
    # γ = 1.0
    # primal_alg_restart(C, x0, C_x0, K, freq, γ)
    # primal_alg(C, x0, C_x0, K, freq)
    # primal_alg_restart_sparse(C, x0, C_x0, K, freq, γ, blocksize, labels)
    # pd_alg_restart_sparse(C, x0, C_x0, K, freq, γ, blocksize, labels)
    # K = 100000
    # OADS(C, labels, x0, C_x0, K, freq, 0.0)

    # primal_alg_restart_sparse_one_bs(C, x0, C_x0, K, freq, γ, blocksize, labels)
    # Nesterov_alg_restart(C, x0, C_x0, K, freq, γ, blocksize, labels)
    # run nnls package algorithm
    # t1 = time()
    # xnnls = nonneg_lsq(data.features, data.values; alg=:nnls)  # NNLS
    # nnls_optval = 0.5*norm(data.features*xnnls - data.values)^2
    #
    # print("\n\n nnls package value is ", nnls_optval, ", and time is $(time() - t1)")
    #
# end
