# using
using Dates
using Logging
using CSV
using DataFrames
# BLAS.set_num_threads(16)
include("../src/utils.jl")

include("../src/OADS_restart.jl")
include("../src/FISTA_restart.jl")

include("../src/SI_NNLS_restart_dense.jl")
include("../src/SI_NNLS_restart_densev2.jl")

DATASET_INFO = Dict([
    ("mnist", (60000, 780, "data/mnist")),
    ("E2006test", (3308, 150360, "data/E2006test")),
    ("E2006train", (16087 , 150360, "data/E2006train")),
    ("news20", (19996, 1355191, "data/news20.binary")),
    ("real-sim", (72309, 20958, "data/real-sim")),
    # ("rcv1", (47236, 20242)),
])

CSV_DATASET_INFO = Dict([
    ("bonome", (185, 22283, "data/bonome_X.csv", "data/bonome_y.csv")),
    ("TCGA", (568, 22274, "data/TCGA_X.csv", "data/TCGA_y_age.csv")),
    ("tohill", (282, 54675, "data/tothill_X.csv", "data/tothill_y_age.csv"))
])

# load data
# dataset = "bonome"
dataset = ARGS[1]
n, d, path_X, path_y = CSV_DATASET_INFO[dataset]
X_df = CSV.read(path_X, DataFrame)
y_df = CSV.read(path_y, DataFrame)
C = Matrix{Float64}(X_df)
b = Matrix{Float64}(y_df)[:]
C_b = (b' * C)'
@info "reformulated!"
m, n = size(C)
x0_ = zeros(n)
C_x0_ = C * x0_


# normalize data
# labels[:] = labels[:] .+ 2

# @info "labels: $labels"
# run our algorithm without restart

# run our algorithm with restart
# m = 60000, x < 780
#
# C, C_b, non_zero_col_norm = reformulation_sparsev2(C, b)
# @info "reformulated!"
# m, n = size(C)
# x0_ = zeros(n)
# C_x0_ = C * x0_

outputdir = "./results"
# filepath = "./data/$(dataset).txt"

timestamp = Dates.format(Dates.now(), "yyyy-mm-dd_HH-MM-SS-sss")
loggingfilename = "$/$(dataset)-$(join(ARGS[3:end], "_"))-execution_log-$(timestamp).txt"
io = open(loggingfilename, "w+")
logger = SimpleLogger(io)

println("timestamp = $(timestamp)")
println("Completed initialization.")
total_time = 3600.0
num_restart = 2000
ϵ = 1e-7
# with_logger(logger) do
    begin
        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 20
        restart_ratio = 0.7
        bs = 5
        @info "SI_NNLS (bs=$bs)  with Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"
        file_path = "$(outputdir)/$(dataset)_SINNLS_restart_$(bs)_$(timestamp).csv"
        SI_NNLS_restart_densev2(C, b, C_b, x0, C_x0, bs, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end


    begin

        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 50
        restart_ratio = 0.7
        bs = 10
        @info "SI_NNLS (bs=$bs)  with Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"
        file_path = "$(outputdir)/$(dataset)_SINNLS_restart_$(bs)_$(timestamp).csv"
        SI_NNLS_restart_densev2(C, b, C_b, x0, C_x0, bs, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end

    begin

        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 20
        restart_ratio = 0.7
        bs = 1
        @info "SI_NNLS (bs=$bs) with Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"
        file_path = "$(outputdir)/$(dataset)_SINNLS_restart_$(bs)_$(timestamp).csv"
        SI_NNLS_restart_dense(C, b, C_b, x0, C_x0, bs, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end

    begin

        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 20
        restart_ratio = 0.0
        bs = 1
        @info "SI_NNLS (bs=$bs)  without Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"
        file_path = "$(outputdir)/$(dataset)_SINNLS_nonrestart_$(bs)_$(timestamp).csv"
        SI_NNLS_restart_dense(C, b, C_b, x0, C_x0, bs, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
        # SI_NNLS_restart_dense(C, b::Vector{Float64}, C_b::Vector{Float64}, x0::Vector{Float64}, C_x0::Vector{Float64}, blocksize::Int64, K::Int64, total_time::Float64, num_restart::Int64, freq::Int64, restart_ratio::Float64, file_path::String)
    end


    begin
        @info "OADS without Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"

        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 100
        restart_ratio = 0.0
        file_path = "$(outputdir)/$(dataset)_OADS_nonrestart_$(timestamp).csv"
        OADS_restart(C, b, C_b, x0, C_x0, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end
    #
    begin
        @info "OADS with Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"

        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        freq = 100
        restart_ratio = 0.7
        file_path = "$(outputdir)/$(dataset)_OADS_restart_$(timestamp).csv"
        OADS_restart(C, b, C_b, x0, C_x0, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end

    begin
        @info "FISTA with Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"

        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 100
        restart_ratio = 0.7
        file_path = "$(outputdir)/$(dataset)_FISTA_restart_$(timestamp).csv"
        FISTA_restart(C, b, C_b, x0, C_x0, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)

    end


    begin
        @info "FISTA without Restart Running on $(dataset) dataset."
        @info "--------------------------------------------------"
        x0 = x0_[:]
        C_x0 = C_x0_[:]
        K = 100000
        # total_time = 1000.0
        # num_restart = 1000
        freq = 100
        restart_ratio = 0.0
        file_path = "$(outputdir)/$(dataset)_FISTA_nonrestart_$(timestamp).csv"
        FISTA_restart(C, b, C_b, x0, C_x0, K, total_time, num_restart, freq, restart_ratio, file_path, ϵ)
    end

    #
    # K = 10000 * n
    # freq = 100
    #
    # blocksize = 1
    # γ = 1.0
    # primal_alg_restart(C, x0, C_x0, K, freq, γ)
    # primal_alg(C, x0, C_x0, K, freq)
    # primal_alg_restart_sparse(C, x0, C_x0, K, freq, γ, blocksize, labels)
    # pd_alg_restart_sparse(C, x0, C_x0, K, freq, γ, blocksize, labels)
    # K = 100000
    # OADS(C, labels, x0, C_x0, K, freq, 0.0)

    # primal_alg_restart_sparse_one_bs(C, x0, C_x0, K, freq, γ, blocksize, labels)
    # Nesterov_alg_restart(C, x0, C_x0, K, freq, γ, blocksize, labels)
    # run nnls package algorithm
    # t1 = time()
    # xnnls = nonneg_lsq(data.features, data.values; alg=:nnls)  # NNLS
    # nnls_optval = 0.5*norm(data.features*xnnls - data.values)^2
    #
    # print("\n\n nnls package value is ", nnls_optval, ", and time is $(time() - t1)")
    #
# end
