function OADS_restart_v2(C, b::Vector{Float64}, C_b::Vector{Float64}, x0::Vector{Float64}, C_x0::Vector{Float64}, K::Int64, total_time::Float64, num_restart::Int64, freq::Int64, restart_ratio::Float64, file_path::String, ϵ)
    results = Results()
    col_norm_square = norm.(eachcol(C)).^2
    init_metric = first_order_optv3(C, b, x0, C_x0, C_b, col_norm_square)
    init_epoch = 0
    init_time = 0.0
    for t = 1:num_restart
        @info "restart!"
        x0, C_x0, init_metric, init_epoch, init_time = OADS_v2(C, b, C_b, x0, C_x0, K, total_time, freq, init_metric, results, init_epoch, init_time, restart_ratio, ϵ, col_norm_square)
        if init_time >= total_time || init_metric < ϵ
            break
        end
    end

    exportresultstoCSV(results, file_path)

end

# work on the original problem: min_{x \ge 0} 1/2||Cx - b||^2
function OADS_v2(C, b::Vector{Float64}, C_b::Vector{Float64}, x0::Vector{Float64}, C_x0::Vector{Float64},  K::Int64, total_time::Float64, freq::Int64, init_metric::Float64, results::Results,
                    init_epoch::Int64, init_time::Float64, restart_ratio, ϵ, col_norm_square)
        t0 = time()

        c, δ = 5, 0.4
        x = x0[:]
        ∇̃ = zero(x0)
        n = length(x)
        ∇ = ((C * x - b)' * C)[:]
        for k = 1:K

           ∇̃[:] .= 0.0
           for i = 1:n
               if !(x[i] == 0 && ∇[i] >0)
                   ∇̃[i] = ∇[i]
               end
           end
           C_∇̃ = C * ∇̃
           α = norm(∇̃)^2 / norm(C_∇̃)^2
           β = c / (k^δ)
           x[:] = max.(x - β * α * ∇, 0.0)

           C_x =  C * x
           ∇ = ((C_x - b)' * C)[:]
           if k % freq == 0
               # C_x = C * x
               metric = first_order_optv3(C, b, x, C_x, C_b, col_norm_square)
               func_value = 0.5 * norm(C_x - b)^2
               td = time() - t0
               @info "k: $k, time: $(td+init_time), metric: $metric,  func_value: $func_value"

               logresult!(results, k + init_epoch, td+init_time, metric, func_value)

               if metric <= restart_ratio * init_metric || td + init_time > total_time || metric < ϵ || k == K

                   return x, C_x, metric, k + init_epoch, td + init_time
               end
           end
        end

end
