
function Nesterov_alg_restart(C::SparseMatrixCSC, x0::Vector{Float64}, C_x0::Vector{Float64}, K::Int64, freq::Int64, γ::Float64, blocksize::Int64, labels::Vector{Float64})
    extra_term = 0.5 * norm(labels)^2

    tmp = 1 .- (C_x0' * C)'
    init_metric = norm(max.(tmp, 0))^2
    blocks, row_idxs, sliced_C_Ts = compute_blocks_rows_slice(C, blocksize)
    ηs = compute_Lips(C, blocks, row_idxs)
    col_norm = norm.(eachcol(C))
    ubs = 1.0 ./ (col_norm.^2)
    total_time = 0.0
    for i = 1:100

        x0, C_x0, init_metric, td = Nesterov_alg(C, x0, C_x0, K, freq, init_metric, γ, blocks, row_idxs, extra_term, ηs, ubs)
        total_time += td
        @info "restart epoch: $i, total_time: $total_time"
    end
end




# nonsparse version
function Nesterov_alg(C::SparseMatrixCSC, x0::Vector{Float64}, C_x0::Vector{Float64}, K::Int64, freq::Int64,  init_metric::Float64, γ::Float64, blocks::Array{UnitRange{Int}}, row_idxs::Array{Vector{Int}}, extra_term::Float64, ηs, ubs)

    init_time = time()
    m, n = size(C)
    prev_x = x0[:]
    x = x0[:]
    p = zero(x)
    t = 1
    η = ηs[1]
    for k = 1:K
        prev_t = t
        t = (1+sqrt(1+4*t^2))/2
        β = (prev_t-1)/t
        p = x + β * (x - prev_x)
        w = p - η * (((C*p)'*C)'.- 1)
        prev_x[:] = x[:]
        x[:] = max.(0, min.(w, ubs))

        if k % (freq) == 0

            C_x = C * x
            tmp = 1 .- (C_x' * C)'
            metric = norm(max.(tmp, 0))^2
            func_value = extra_term + 0.5 * norm(C_x)^2 - sum(x)
            td = time() - init_time
            @info "iteration: $(k), time: $(td), metric: $metric, func_value: $func_value, t: $t"

            if metric <= 0.5 * init_metric
            # if metric <= 1e-10
                @info "restart!"
                return x, C_x, metric, td
            end

        end
    end
end
