struct ScenarioNode{T}
    value::T
    children::Vector{ScenarioNode{T}}
    weights::Vector{Float64}
end

LeafNode(val) = ScenarioNode(val, ScenarioNode{typeof(val)}[], Float64[])
isleaf(node::ScenarioNode) = length(node.children) == 0
probs(node::ScenarioNode) = node.weights ./ sum(node.weights)

sample_scenario(rng::AbstractRNG, node::ScenarioNode{T}) where {T}  =
    if isleaf(node)
        node.value
    else
        idx = rand(rng, Categorical(probs(node)))
        sample_scenario(rng, node.children[idx])
    end

marginalize(node::ScenarioNode{T}) where {T} =
    if isleaf(node)
        Dict(node.value => 1.)
    else
        results = [Dict(k => prob * v for (k, v) in marginalize(child))
                   for (child, prob) in zip(node.children, probs(node))
                       if prob > 0.]
        mergewith(+, results...)
    end
