import numpy as np
from numpy.core.fromnumeric import argsort
import pandas as pd
from utils import *
import argparse, os

varying_budgets = False

try:
    parser = argparse.ArgumentParser(description='Experiment arguments')
    parser.add_argument('--seed', '-sd', type=int, default=2333)
    seed = parser.parse_args().seed
except:
    print('not parsing command line inputs. use given parameters.')
    seed = 2333

n = 100
T = n * 110
print('n = {}, seed = {}'.format(n, seed))
B = np.ones(n) / n

###################### do not change the data generation block ######################
np.random.seed(2021)
n = 100
B = np.ones(n)/n
d = np.random.uniform(low=0.0, high=2.0 ,size = n)
c = (1 - d) * 2 

# v[i](theta) = c[i]*theta + d[i]
###################### do not change the data generation block ######################

# load offline equilibrium
beta_opt = np.loadtxt(os.path.join('results', 'inf-dim', 'offline-eq', 'beta'))
u_opt = np.loadtxt(os.path.join('results', 'inf-dim', 'offline-eq', 'u'))

np.random.seed(seed)
################################################################
# experiment parameters
do_stochastic = True
budget_cap = False

delta0 = 0.05
beta = np.ones(n)
beta_ave = np.zeros(n)
g_ave = np.zeros(n)

items_all_t = np.zeros(T, dtype=np.int)
winners_all_t = np.zeros(T, dtype=np.int)
spending = np.zeros(n)
# all RELATIVE to u_opt and beta_opt (equilibrium utilities and equilibrium utility prices)
inf_norm_to_u_eq, inf_norm_to_beta_eq, inf_norm_to_B = [], [], []
ave_one_norm_to_u_eq, ave_one_norm_to_beta_eq, ave_one_norm_to_B = [], [], []

# buyer valuations (functions) 
# v[i](theta) = c[i] * theta + d[i]
for t in range(1, T+1):
    if do_stochastic:
        # sample an item
        theta = np.random.uniform(low = 0, high = 1)
        items_all_t[t-1] = theta
        # remove buyers that have depleted their budgets
        if budget_cap:
            has_budget = [spending[i] + beta[i] * (c[i]*theta+d[i]) <= B[i] * T for i in range(n)]
        else:
            has_budget = [True] * n
        # find winners for this item (just pick the lex. smallest winner, if tie)
        winner = np.argmax(beta[has_budget] * (c[has_budget]*theta + d[has_budget]))
        winners_all_t[t-1] = winner
        spending[winner] += beta[winner] * (c[winner]*theta + d[winner])
        # update the dual average
        g_ave = (t-1) * g_ave / t if t > 1 else np.ones(n) / n
        # note the m: since it is non-averaged sum over j
        g_ave[winner] += (c[winner]*theta + d[winner]) / t
    else: # find the full subgradient
        raise NotImplementedError('Full subgradient dual averaging for inf-dim is not implemented (since it is not needed for now).')
    # update beta
    beta = np.maximum((1-delta0) * B, np.minimum(1 + delta0, B / g_ave)) # spending[winner] += beta[winner] * v[winner, j] # option 2: use beta(t+1) to compute prices
    beta_ave = (t-1) * beta_ave / t + beta / t
    # logging
    inf_norm_to_u_eq.append(np.max(np.abs(g_ave - u_opt)/u_opt)) # relative to each u_opt
    inf_norm_to_beta_eq.append(np.max(np.abs(beta - beta_opt)/beta_opt))
    inf_norm_to_B.append(np.max(np.abs(B - spending/t)/B))
    ave_one_norm_to_u_eq.append(np.mean(np.abs(g_ave - u_opt)/u_opt))
    ave_one_norm_to_beta_eq.append(np.mean(np.abs(beta - beta_opt)/beta_opt))
    ave_one_norm_to_B.append(np.mean(np.abs(B - spending/t)/B))
    if t % (int(T//20)) == 0:
        # print('t = {}, dobj = {}, dgap = {:.4f}'.format(t, dobj, dgap))
        print('t = {}, max_beta_error = {:.4f}, max_u_error = {:.4f},  max_b_error = {:.4f}'.format(t, inf_norm_to_beta_eq[-1], inf_norm_to_u_eq[-1], inf_norm_to_B[-1]))
    
res = g_ave / u_opt
print('max and min of g_ave/T divided by u_opt[i]: {:.4f}, {:.4f}'.format(np.min(res), np.max(res)))

# save results
import pandas as pd
import json
fpath = os.path.join('results', 'inf-dim', 'sd-{}'.format(seed))
print('fpath = {}'.format(fpath))
os.makedirs(fpath, exist_ok=True)
# np.savetxt(os.path.join(fpath, 'duality_gap'), duality_gap, fmt='%.4e') 
np.savetxt(os.path.join(fpath, 'inf_norm_to_beta_eq.gz'), inf_norm_to_beta_eq, fmt='%.4e') 
np.savetxt(os.path.join(fpath, 'ave_one_norm_to_beta_eq.gz'), ave_one_norm_to_beta_eq, fmt='%.4e')
np.savetxt(os.path.join(fpath, 'inf_norm_to_u_eq.gz'), inf_norm_to_u_eq, fmt='%.4e')
np.savetxt(os.path.join(fpath, 'ave_one_norm_to_u_eq.gz'), ave_one_norm_to_u_eq, fmt='%.4e')
np.savetxt(os.path.join(fpath, 'inf_norm_to_B.gz'), inf_norm_to_B, fmt='%.4e')
np.savetxt(os.path.join(fpath, 'ave_one_norm_to_B.gz'), ave_one_norm_to_B, fmt='%.4e')
meta_data = {'T': T, 'dataset': 'inf-dim', 'n': n, 'm': 'infinity (i.e., the unit interval)', 'seed': seed, 'delta0': delta0, 'varying_budgets': varying_budgets}
with open(os.path.join(fpath, 'meta_data'), 'w') as mdff:
    mdff.write(json.dumps(meta_data, indent=4))