import numpy as np
from numpy.core.records import _deprecate_shape_0_as_None
import pandas as pd
from utils import *
import argparse

dataset = 'MovieLens'
# dataset = 'Household'
# dataset = 'Jokes'

for dataset in ('MovieLens', 'Household', 'Jokes'):

    if dataset == 'MovieLens':
        df = pd.read_csv("../../data/movielens_1500x1500_lr0.1_wd1e-05_dim20_rmse0.88640326.csv", header=None)
        v = df.to_numpy()
    if dataset == 'Jokes':
        df = pd.read_csv("../../data/jokes_7200.csv")
        v = df.to_numpy()
    if dataset == 'Household':
        df = pd.read_csv("../../data/household_items_understood.csv")
        v = df.to_numpy()

    print("dataset = {}".format(dataset))

# solve the instance (normalization done in the function)
n, m = v.shape
B = np.ones(n) / n
p, x = compute_me_mosek(v, B)

# save the result
import os
fpath = os.path.join('results', dataset.lower(), 'offline-eq')
os.makedirs(fpath, exist_ok=True)
np.savetxt(os.path.join(fpath, 'p'), p, fmt='%.4e')
np.savetxt(os.path.join(fpath, 'x'), x, fmt='%.4e')