# Effect of aggregation probability on the convergence rate



from algorithms import *

plot_only = True

linestyles = ['--', '-', ':', '-.',  ':', '-.', '-', '-', '-.', '--', ':', '-.', '-']
markers = ['o', 'd', '*',  'v', 'P', '1', 'p', 'X']
colors = ['tab:blue', 'tab:brown', 'tab:green', 'tab:red', 'tab:purple', 'tab:gray',
          'tab:olive', 'tab:cyan']

mu = 1e-3
experiment = "vr_acc992"


datasets = ["mushrooms", "phishing", "a1a", "duke", "madelon",  "a8a"]#["madelon",  "a8a", "mushrooms", "a1a"] #["duke", "madelon",  "a8a", "mushrooms", "phishing", "a1a"]

T_dict = {"a1a": 15, "mushrooms": 677,  "phishing": 1005, "duke": 11, "madelon": 500, "gisette_scale": 60, "a8a": 2837}


#omega_dict = {"a1a": 0.1, "mushrooms": 0.05, "w2a": 0.01, "phishing": 0.1, "duke": 0.4, "madelon": 0.02, "gisette_scale": 0.2, "a8a": 0.1}

# characterization of the problem
for dataset in datasets:
    print("#############################")
    print(dataset)
    print("#############################")



    A, b = get_data(dataset)

    n, d = A.shape
    T = n

    A = normalize_data(A)
    A, b = rearrange_data(A, "random", b)

    blocks = create_blocks(n, T)

    K = max(3*d, int(2000))
    skip_it = max(1, int(K/200))

    v = (1 + 1e-6)*np.ones(n)
    m = int(n/T)
    f, g = make_fg_logreg(A, b, mu)




    def total_loss(x): return objective(f, x, n)


    if m*T != n:
        continue


    if not plot_only:
        Lmat = np.dot(A.T,A)/n/4 + mu*np.eye(d)
        L = eigh(Lmat, eigvals = (d-1,d-1))[0][0]

        x0 =  find_xstar(g, mu, L, d, n, 1000, pre_text='', loss=total_loss)

        xstar = find_xstar(g, mu, L, d, n, K, pre_text='', loss=total_loss, x0 = x0)

        Fstar = total_loss(xstar)

    Flist = []
    Xlist = []

    labels = ["ADIANA+",
              "DIANA+",
              "DCGD+",
              "ADIANA",
              "DIANA",
              "DCGD"
              ]

    it1 = create_it(T=K, skip_it=skip_it, tau = 1)
    for i in range(len(it1)):
        it1[i] += d
    it2 = create_it(T=K, skip_it=skip_it, tau = 1)



    tau = 1
    simple_spars = False
    imp = False
#    settings = [(True, True), (False, True)]
    settings = [(True, True), (False, True), (False, False)]

    if not plot_only:
        for simple_spars in [False, True]:
            for (acc, vr) in settings:
                F, x = dist_GD(total_loss, g, blocks, A, mu, vr,  imp, K, skip_it, tau, simple_spars, acc, x0=x0, pre_text='')
                Flist.append((F - Fstar)/(F[0]-Fstar))
                Xlist.append(x)



         # save F
        for backup in [True, False]:
            filename = createfilename(experiment, dataset, T,  mu, backup)
            pickle_out = open(filename, "wb")
            pickle.dump((Flist, Xlist), pickle_out)
            pickle_out.close()


    # load F
    (Flist, Xlist) = load_pickle(experiment, dataset, T, mu)


    it_list = [it2 for i in Flist]
    for i in range(3):
        it_list[i] = it1


    # plot
    alphas = None#
    visualize(Flist, it_list, "vr_acc992_bits_", dataset, labels, linestyles=linestyles, markers=markers,
              colors=colors, alphas=alphas, muT=mu/T, ppe=n/T)



