# -*- coding: utf-8 -*-



import Gappletron
import scalefreeMD
import loss
import runclass
import classifiers
import Gaptron

import numpy as np


#%%



def runfullinfo(y, X, dataname, gaprep = 10, save = True):
    
    K = len(np.unique(y))
    xnorm = np.max(np.linalg.norm(X, axis = 1))
    
    reg = scalefreeMD.L2reg()
    algW = scalefreeMD.scalefreeMD(reg, 1, dim = X.shape[1], K = K, eta = 'ada', project = False)
    algWhin = scalefreeMD.scalefreeMD(reg, 1, dim = X.shape[1], K = K, eta = 'constant', project = False, lada = (1 - 1/K)/(K * xnorm ** 2))
    algWsmhin = scalefreeMD.scalefreeMD(reg, 1, dim = X.shape[1], K = K, eta = 'constant', project = False, lada = 1/(4 * K * xnorm ** 2))
    algWlog = scalefreeMD.scalefreeMD(reg, 1, dim = X.shape[1], K = K, eta = 'constant', project = False, lada = (np.log(2))/(2 * K * xnorm ** 2))
    
    
    Gaphinge = Gappletron.Gappletron(loss.hinge(1/2).minloss, algW, 0, 1, list(range(K)), domset = list(range(K)), reveal = list(range(K)), domsetdict = [])
    Gapsmoothhinge = Gappletron.Gappletron(loss.smoothhinge().minloss, algW, 0, 1, list(range(K)), domset = list(range(K)), reveal = list(range(K)), domsetdict = [])
    Gaplogistic = Gappletron.Gappletron(loss.logistic(base = K).minloss, algW, 0, 1, list(range(K)), domset = list(range(K)), reveal = list(range(K)), domsetdict = [])
    per = classifiers.perceptron(dim = X.shape[1], K = len(np.unique(y)))
    sop = classifiers.sodiagperceptron(dim = X.shape[1], K = len(np.unique(y)))
    PA = classifiers.perceptron(dim = X.shape[1], K = len(np.unique(y)), PA = True)
    

    Gaptronhinge = Gaptron.Gaptron(loss.hinge(1/K).minloss, algWhin, 0, 1, list(range(K)), domset = list(range(K)), reveal = list(range(K)), domsetdict = [])
    Gaptronsmoothhinge = Gaptron.Gaptron(loss.smoothhinge().minloss, algWsmhin, 0, 1, list(range(K)), domset = list(range(K)), reveal = list(range(K)), domsetdict = [])
    Gaptronlogistic = Gaptron.Gaptron(Gaptron.logmap, algWlog, 0, 1, list(range(K)), domset = list(range(K)), reveal = list(range(K)), domsetdict = [])

    
    mistakesgaphinge = runclass.runclassifier(Gaphinge, loss.hinge(1/2), y, X, rep = gaprep, dataname = dataname, save = save)
    mistakesgapsmoothhinge = runclass.runclassifier(Gapsmoothhinge, loss.smoothhinge(), y, X, rep = gaprep, dataname = dataname, save = save)
    mistakesgaplogistic = runclass.runclassifier(Gaplogistic, loss.logistic(base = K), y, X, rep = gaprep, dataname = dataname, save = save)
    
    mistakesgaptronhinge = runclass.runclassifier(Gaptronhinge, loss.hinge(1/K), y, X, rep = gaprep, dataname = dataname, save = save)
    mistakesgaptronsmoothhinge = runclass.runclassifier(Gaptronsmoothhinge, loss.smoothhinge(), y, X, rep = gaprep, dataname = dataname, save = save)
    mistakesgaptronlogistic = runclass.runclassifier(Gaptronlogistic, loss.logistic(base = 2), y, X, rep = gaprep, dataname = dataname, save = save)
    
    
    mistakesper = runclass.runclassifier(per, loss.hinge(), y, X, dataname = dataname, save = save)
    mistakessop = runclass.runclassifier(sop, loss.hinge(), y, X, dataname = dataname, save = save)
    mistakesPA = runclass.runclassifier(PA, loss.hinge(), y, X, dataname = dataname, save = save)
    
#%%    
def runbandit(y, X, dataname, rep = 10, save = True, gamma = "theo") :
    K = len(np.unique(y))
    xnorm = np.max(np.linalg.norm(X, axis = 1))
    Ti = X.shape[0]
    
    reg = scalefreeMD.L2reg()
    diameter = 2 #fix diameter = 2 and do not project to give advantage/disadvantage to SOBA or Banditron. 
    algW = scalefreeMD.scalefreeMD(reg, diameter, dim = X.shape[1], K = K, eta = 'ada', project = False)
    
    if gamma == "theo":
        Gapgamma = 1/2 * xnorm * K *0.5 * diameter
        Gaphingamma = np.min([1, np.sqrt(K**3 * xnorm**2/(2 * (1 - 1/K) * (K - 1) * Ti))])
        etascalehin = 1
        Gapsmhingamma = np.min([1, np.sqrt(4 * K**2 * xnorm**2/(Ti))])
        etascalesmhin = 1
        Gaploggamma = np.min([1, np.sqrt(K**2 * xnorm**2/(np.log(2) * Ti))])
        etascalelog=1
        btrongamma = np.min([0.5, (K * xnorm**2 * (0.5 * diameter)**2 /X.shape[0])**(1/3)])
        sobagamma = np.min([0.5, (K**2 * X.shape[1] * np.log(X.shape[0])/X.shape[0])**(1/2)])
        sobaada = True
        sobaalpha = xnorm ** 2
        alpha = 10
        if alpha > 1/(6 * xnorm * 0.5 * diameter) * np.log(X.shape[0]):
            Newtgamma = np.min([0.5, (K**2 * X.shape[1] * (0.5*diameter) ** 2 * xnorm ** 2 * alpha ** 2 * np.log(X.shape[0]) /(np.log(K)**2 * X.shape[0]))**(1/3)])
        else:
            Newtgamma = 1/X.shape[0]
    
    if gamma == "onlyT":
        Gapgamma = 1/2
        Gaphingamma = np.min([1, np.sqrt(1/(2 * Ti))]) 
        etascalehin = 1/((1 - 1/K)/(K * xnorm ** 2))
        Gapsmhingamma = np.min([1, np.sqrt(4 /(Ti))])
        etascalesmhin =  (4 * K * xnorm ** 2)
        Gaploggamma = np.min([1, np.sqrt(1/(np.log(2) * Ti))])
        etascalelog = 1/((np.log(2))/(2 * K * xnorm ** 2))
        btrongamma = 1 / (X.shape[0])**(1/3)
        np.min([0.5, (np.log(X.shape[0])/X.shape[0])**(1/2)])
        sobaada = False
        sobaalpha = 1
        alpha = 10
        sobagamma = np.min([0.5, (np.log(X.shape[0])/X.shape[0])**(1/2)])
        if alpha > 1/6 * np.log(X.shape[0]):
            Newtgamma = np.min([0.5, (np.log(X.shape[0])/X.shape[0])**(1/3)])
        else:
            Newtgamma = 1/X.shape[0]
        xnorm = 1
    
    if type(gamma) == float or type(gamma) == int:
        Gapgamma = gamma
        btrongamma = gamma
        sobagamma = gamma
        sobaalpha = 1
        alpha = 10
        Newtgamma = gamma
    
    algWhin = scalefreeMD.scalefreeMD(reg, 1, dim = X.shape[1], K = K, eta = 'constant', project = False, lada = Gaphingamma * etascalehin * (1 - 1/K)/(K * xnorm ** 2))
    algWsmhin = scalefreeMD.scalefreeMD(reg, 1, dim = X.shape[1], K = K, eta = 'constant', project = False, lada = Gapsmhingamma * etascalesmhin/(4 * K * xnorm ** 2))
    algWlog = scalefreeMD.scalefreeMD(reg, 1, dim = X.shape[1], K = K, eta = 'constant', project = False, lada = Gaploggamma * etascalelog * (np.log(2))/(2 * K * xnorm ** 2))

    
    rep = rep
    Gaphinge = Gappletron.Gappletron(loss.hinge(1/2).minloss, algW, Gapgamma, 1, list(range(K)), domset = [], reveal = [], domsetdict = [])
    Gapsmoothhinge = Gappletron.Gappletron(loss.smoothhinge().minloss, algW, Gapgamma, 1, list(range(K)), domset = [], reveal = [], domsetdict = [])
    Gaplogistic = Gappletron.Gappletron(loss.logistic(base = K).minloss, algW, Gapgamma, 1, list(range(K)), domset = [], reveal = [], domsetdict = [])
    
    
    Gaptronhinge = Gaptron.Gaptron(loss.hinge(1/K).minloss, algWhin, Gaphingamma, 1, list(range(K)), domset = [], reveal = [], domsetdict = [])
    Gaptronsmoothhinge = Gaptron.Gaptron(loss.smoothhinge().minloss, algWsmhin, Gapsmhingamma, 1, list(range(K)), domset = [], reveal = [], domsetdict = [])
    Gaptronlogistic = Gaptron.Gaptron(Gaptron.logmap, algWlog, Gaploggamma, 1, list(range(K)), domset = [], reveal = [], domsetdict = [])

    
    
    Banditron = classifiers.IWBanditron(dim = X.shape[1], K = K, gamma = btrongamma)
    SOBA = classifiers.SOBAdiag(dim = X.shape[1], K = K, alpha = sobaalpha, gamma = sobagamma, gamma_adaptive = sobaada)
    
    
    
    Newtron = classifiers.PNewtron(dim = X.shape[1], K = len(np.unique(y)), D = 1, alpha = alpha, gamma = Newtgamma, project = True, FI = False, greedy = False)
    
    mistakesgaphinge = runclass.runclassifier(Gaphinge, loss.hinge(1/2), y, X, rep = rep, dataname = dataname, save = save, bandit = True, gamma = gamma)
    mistakesgapsmoothhinge = runclass.runclassifier(Gapsmoothhinge, loss.smoothhinge(), y, X, rep = rep, dataname = dataname, save = save, bandit = True, gamma = gamma)
    mistakesgaplogistic = runclass.runclassifier(Gaplogistic, loss.logistic(base = K), y, X, rep = rep, dataname = dataname, save = save, bandit = True, gamma = gamma)
    
    
    mistakesgaptronhinge = runclass.runclassifier(Gaptronhinge, loss.hinge(1/K), y, X, rep = rep, dataname = dataname, save = save, bandit = True, gamma = gamma)
    mistakesgaptronsmoothhinge = runclass.runclassifier(Gaptronsmoothhinge, loss.smoothhinge(), y, X, rep = rep, dataname = dataname, save = save, bandit = True, gamma = gamma)
    mistakesgaptronlogistic = runclass.runclassifier(Gaptronlogistic, loss.logistic(base = 2), y, X, rep = rep, dataname = dataname, save = save, bandit = True, gamma = gamma)
    
    
    mistakesbanditron = runclass.runclassifier(Banditron, loss.hinge(), y, X, rep = rep, dataname = dataname, save = save, bandit = True, gamma = gamma)
    mistakesSOBA = runclass.runclassifier(SOBA, loss.hinge(), y, X, rep = rep, dataname = dataname, save = save, bandit = True, gamma = gamma)
    mistakesNewtron = runclass.runclassifier(Newtron, loss.logistic(), y, X, rep = rep, dataname = dataname, save = save, bandit = True, gamma = gamma)
    
    
#%%
def runreveal(y, X, dataname, reveal, rep = 10, save = True, gamma = "theo"):
    K = len(np.unique(y))
    xnorm = np.max(np.linalg.norm(X, axis = 1))
    domsetdict = {str(i): [reveal] for i in range(K)}
    
    
    reg = scalefreeMD.L2reg()
    diameter = 2 #fix diameter = 2 and do not project to give advantage/disadvantage to SOBA or Banditron. 
    algW = scalefreeMD.scalefreeMD(reg, diameter, dim = X.shape[1], K = K, eta = 'ada', project = False)
    
    if gamma == "theo":
        Gapgamma = 1/2 * xnorm * np.sqrt(K) * 0.5 * diameter
        btrongamma = np.min([0.5, (xnorm**2 * (0.5 * diameter)**2 /X.shape[0])**(1/3)])
        
    
    if gamma == "onlyT":
        Gapgamma = 1/2
        btrongamma = 1 / (X.shape[0])**(1/3) 
        
    
    
    Gaphinge = Gappletron.Gappletron(loss.hinge(1/2).minloss, algW, Gapgamma, 1, list(range(K)), domset = [reveal], reveal = [reveal], domsetdict = domsetdict)
    Gapsmoothhinge = Gappletron.Gappletron(loss.smoothhinge().minloss, algW, Gapgamma, 1, list(range(K)), domset = [reveal], reveal = [reveal], domsetdict = domsetdict)
    Gaplogistic = Gappletron.Gappletron(loss.logistic(base = K).minloss, algW, Gapgamma, 1, list(range(K)), domset = [reveal], reveal = [reveal], domsetdict = domsetdict)
    Banditron = classifiers.RABanditron(dim = X.shape[1], K = K, reveal = reveal, gamma = btrongamma)
    

    mistakesgaphinge = runclass.runRA(Gaphinge, loss.hinge(1/2), y, X, reveal = reveal, rep = rep, dataname = dataname, save = save, RA = True, gamma = gamma)
    mistakesgapsmoothhinge = runclass.runRA(Gapsmoothhinge, loss.smoothhinge(), y, X, reveal = reveal, rep = rep, dataname = dataname, save = save, RA = True, gamma = gamma)
    mistakesgaplogistic = runclass.runRA(Gaplogistic, loss.logistic(base = K), y, X, reveal = reveal, rep = rep, dataname = dataname, save = save, RA = True, gamma = gamma)
    mistakesbanditron = runclass.runRA(Banditron, loss.hinge(), y, X, reveal = reveal, rep = rep, dataname = dataname, save = save, RA = True, gamma = gamma)


#%%
def runLE(y, X, dataname, rep = 10, save = True, gamma = "theo"):
    K = len(np.unique(y))
    xnorm = np.max(np.linalg.norm(X, axis = 1))
    domsetdict = {str(i): [K] for i in range(K)}
    
    
    reg = scalefreeMD.L2reg()
    diameter = 2 #fix diameter = 2 and do not project to give advantage/disadvantage to SOBA or Banditron. 
    algW = scalefreeMD.scalefreeMD(reg, diameter, dim = X.shape[1], K = K + 1, eta = 'ada', project = False)
    
    if gamma == "theo":
        Gapgamma = 1/2 * xnorm * np.sqrt(K + 1) * 0.5 * diameter
        spgamma = xnorm**2 * 0.5 * np.sqrt(1 + 4 / xnorm**2 * X.shape[0] * (1 + xnorm))
        gada = True
    
    if gamma == "onlyT":
        Gapgamma = 1/2
        gada = False
        spgamma = 0.5 * np.sqrt(1 + 8 * X.shape[0])

    
    
    Gaphinge = Gappletron.Gappletron(loss.hinge(1/2).minloss, algW, Gapgamma, 1, list(range(K + 1)), domset = [K], reveal = [K], domsetdict = domsetdict)
    Gapsmoothhinge = Gappletron.Gappletron(loss.smoothhinge().minloss, algW, Gapgamma, 1, list(range(K + 1)), domset = [K], reveal = [K], domsetdict = domsetdict)
    Gaplogistic = Gappletron.Gappletron(loss.logistic(base = K + 1).minloss, algW, Gapgamma, 1, list(range(K + 1)), domset = [K], reveal = [K], domsetdict = domsetdict)
    selPerceptron = classifiers.selPerceptron(X.shape[1], K, gamma = spgamma, gamma_adaptive = gada, beta = 1)
    

    mistakesgaphinge = runclass.runLE(Gaphinge, loss.hinge(1/2), y, X, rep = rep, dataname = dataname, save = save, gamma = gamma)
    mistakesgapsmoothhinge = runclass.runLE(Gapsmoothhinge, loss.smoothhinge(), y, X, rep = rep, dataname = dataname, save = save, gamma = gamma)
    mistakesgaplogistic = runclass.runLE(Gaplogistic, loss.logistic(base = K), y, X, rep = rep, dataname = dataname, save = save, gamma = gamma)
    mistakesselPerceptron = runclass.runLE(selPerceptron, loss.hinge(), y, X, rep = rep, dataname = dataname, save = save, gamma = gamma)

