import numpy as np
import math
import scipy
from numpy import sqrt
import random as rd
from numpy.random import RandomState
from numpy.random import rand, randn
from scipy.linalg import qr
from dppy.finite_dpps import *
import matplotlib.pyplot as plt
from scipy.stats import unitary_group
from scipy.stats import ortho_group
import itertools
from scipy.optimize import minimize, LinearConstraint
from scipy.optimize import rosen
from scipy.optimize import linprog
import seaborn as sb
import time
import copy
rng = np.random.default_rng(7)

items_per_axis = 20
cardinality_constraint = 25
max_iter = 250
n1 = items_per_axis*items_per_axis

L1 = np.zeros((n1,n1))
for i in range(n1):
	for j in range(n1):
		L1[i][j] = np.exp((-(((i%items_per_axis)*1/items_per_axis - (j%items_per_axis)*1/items_per_axis)**2 + ((i//items_per_axis)*1/items_per_axis - (j//items_per_axis)*1/items_per_axis)**2))/(2*0.04**2))


I1 = np.identity(n1)


def gradcal_refined(x, lamb):
	gradient = np.array([0.0 for i in range(n1)])
	for i in range(n1):
		p = 0
		for j in range(n1):
			p = p + L1[i][j]*(x[i] - x[j])
		p = 4*p
		gradient[i] = p
	return((1-lamb)*gradient)


def softext1(x, lamb):
	out = np.diag(x) @ (L1-I1) 
	out = out + I1
	out = np.linalg.det(out)
	out = np.log(out) 
	return(lamb*out)


def coverageconcave1(x, lamb):
	out = 100
	for i in range(n1):
		for j in range(n1):
			out = out - (1*L1[i][j])*((x[i] - x[j])**2)
	return((1-lamb)*out)


def gradsoftext1(x, lamb):
	P1 = np.diag(x) @ (L1-I1) 
	P1 = P1 + I1
	P1 = np.linalg.inv(P1)
	P2 = (L1-I1)
	out = []
	for i in range(n1):
		something = P2[i,:] @ P1[:, i]
		out.append(something)
	out = np.array(out)
	out = out.transpose()
	return(lamb*out)


def fwolfe1(epsilon, softext1, coverageconcave1, y, lamb):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradsoftext1(y, lamb)
		q = gradcal_refined(y, lamb)
		r = p + 2*q
		c = np.array(r)
		
		c = -c
		A = [np.ones(n1)]
		b = []
		b.append(cardinality_constraint)
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((0,1))

		res = linprog(c, A_ub=A, b_ub=b, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		y = np.array(y)

		y = (1 - epsilon)*y + epsilon*x_

		potential_answers.append(y)		
		it = it+1
	final_out = []
	for i in potential_answers:
		final_out.append(softext1(i, lamb) + coverageconcave1(i, lamb))

	maximizing_pt = None
	max_final_out = max(final_out)
	for j in range(len(final_out)):
		if final_out[j] == max_final_out:
			maximizing_pt = potential_answers[j]
	return(maximizing_pt)



plt.figure(figsize=(4*4, 4), dpi = 200)

rd_starting_point = rng.random(n1)



starting_plotting_list_1 = fwolfe1(1/41, softext1, coverageconcave1 , 0.1*rd_starting_point, 1)
starting_plotting_list_1 = np.array(starting_plotting_list_1)
starting_plotting_list_1 = np.reshape(starting_plotting_list_1, (items_per_axis, items_per_axis), order='C')
plt.subplot(1,3,1)
sb.heatmap(starting_plotting_list_1, cmap="YlGnBu", square = True, xticklabels=[], yticklabels=[], cbar = False)
plt.xlabel("Just DR-submodular") 



starting_plotting_list_2 = fwolfe1(1/960, softext1, coverageconcave1 , 0.1*rd_starting_point, 0.972) #972
starting_plotting_list_2 = np.array(starting_plotting_list_2)
starting_plotting_list_2 = np.reshape(starting_plotting_list_2, (items_per_axis, items_per_axis), order='C')
plt.subplot(1,3,2)
sb.heatmap(starting_plotting_list_2, cmap="YlGnBu", square = True, xticklabels=[], yticklabels=[], cbar = False)
plt.xlabel("Combination of Both") 



starting_plotting_list_3 = fwolfe1(1/3, softext1, coverageconcave1 , 0.1*rd_starting_point, 0)
starting_plotting_list_3 = np.array(starting_plotting_list_3)
starting_plotting_list_3 = np.reshape(starting_plotting_list_3, (items_per_axis, items_per_axis), order='C')
plt.subplot(1,3,3)
sb.heatmap(starting_plotting_list_3, cmap="YlGnBu", square = True, xticklabels=[], yticklabels=[], cbar = False)
plt.xlabel("Just Concave") 



plt.savefig("interpolate_fig.png")



