import  numpy as np



def chisq_pdf_distance(bins, prob, tgt_dist):
    '''
    distance between two distributions, one specified as an empirical distribution
    at bin points given in 'bin' along with the associated probability masses in 'prob',
    while the other is specified as a distn, which can be queried for its pdf.
    '''
    
    tcdf=tgt_dist.cdf(bins)
    tpdf = tcdf[1:]-tcdf[0:-1]
    diff = prob - tpdf
    
    
    dist = np.sum(diff * diff / tpdf)
    return dist


