import csv
from math import isnan, isinf


import logging
_LOGGER = logging.getLogger('util.csv')

def get_excelcsv_writer(filepre):
    fp=open(filepre+'.csv', "a",  encoding="utf-8") # 'ab' appends to the current file 
    wr = csv.writer(fp, dialect='excel')
    return wr,fp

class csv_data_reader:

    def __init__(self, cols):
        r'''
        Reads data as required. Will need a valid filename. All other input params
        need to be placed within the initialization of the reader.
        '''

        self._cols_to_read=cols

        self.skip_first_line = False
        if self._cols_to_read is not None:
            self.skip_first_line=True

        
    def __trim_all(self,rs):
        for r in range(len(rs)):
            rs[r] = rs[r].strip()
        
    def read_data_from_file(self, csvname, out):
        r'''
        The main functionality, this will push all data into the 'out' dict.
        Data will be retrievable by out['colname'] where the col names are provided
        at the initialization of this method. 
        
        All csv files are ordered assumed in iteration number sequence. We will 
        re-sort by the 'sort_by' index provided in the initialization. 
        '''

        badlines=[]
        linenum=0
        
        with open(csvname, newline='') as csvfile:
            try:
                dialect = csv.Sniffer().sniff(csvfile.read(1024))
            except csv.Error as e:
                _LOGGER.error("Skipping file '{}' because it produced error: {}".format(csvname, e))
                return
            csvfile.seek(0)
            # this does all the heavy lifting! 
            #dict_reader = csv.DictReader(csvfile)
            flrdr = csv.reader(csvfile, dialect, skipinitialspace=True)
            
            # get set with the col indices etc. from the first line
            cols2read_ndxs=[]

            try:
                row = flrdr.__next__()
                n_cols = len(row)
                # skipinitialspace doesn't work on quoted strings!
                self.__trim_all(row)
                
                if self.skip_first_line:
                    # we will need to figure out the index of the cols 
                    for cln in range(len(self._cols_to_read)):
                        cl=self._cols_to_read[cln]
                        ntfnd=True
                        for n in range(n_cols):                       
                            if row[n] == cl:
                                cols2read_ndxs.append(n)
                                ntfnd=False
                                # start output 
                                out[cl] = []                           
                                break
                        if ntfnd:
                            _LOGGER.error("File '{}' has no col named '{}'. line 1: \n\t{}".format(
                                    csvname,cl,row))
                else:
                    # read all
                    cols2read_ndxs= range(n_cols)
                    self._cols_to_read=[]
                    for cl in cols2read_ndxs:
                        self._cols_to_read.append(cl)
                        out[cl] = []
                        out[cl].append(row[cl])
                linenum+=1                        
            except StopIteration:
                _LOGGER.warn("File '{}' is empty.".format(csvname))
                return 
            
            n_cols2read=len(cols2read_ndxs)
            
            while True:
                try:
                    row = flrdr.__next__()
                    n_cols = len(row)
                    # skipinitialspace doesn't work on quoted strings!
                    self.__trim_all(row)


                    # we first try to determine if we should continue with reading this line
                    ok2read=True
                    readvals=[]
                    for cln in range(n_cols2read):
                        try:
                            readval=float(row[cols2read_ndxs[cln]])
                            if isnan(readval) or isinf(readval):
                                raise ValueError("value is nan/inf : '{}'".format(row[cl]))
                            readvals.append(readval)
                        except ValueError as e:
                            _LOGGER.info("Skipping csvfile '{}' linenum {} col '{}' value was '{}', not a float.".format(
                                    csvname, linenum, cln, row[cln]))
                            _LOGGER.info("Error mesg: {}".format(e))
                            badlines.append(linenum)
                            ok2read=False
                            break
                            
                    if ok2read: 
                        for cln in range(n_cols2read):
                            out[self._cols_to_read[cln]].append( readvals[cln] )
    
                    linenum+=1

                except StopIteration:
                    break


            #print("total lines is {} and out {}".format(linenum, out))            
            if len(badlines)  > 0 :
                print("File : {} has {} bad rows".format(csvfile, len(badlines)))

        
