# Quantifying the Empirical Wasserstein Distance to a Set of Measures: Beating the Curse of Dimensionality

This code implements the numerical experiments described in the NeurIPS 2020
submisstion with the title above.

The code requires python3, numpy and matplotlib. 

The experiment requires computing R_N^{\ast} and R_N^{alt}. This is implemented 
in 'run_experiment.py'. Call this script as:
   python3 run_experiment.py

Read the "__main__" body of the script to see what parameters can be set and 
how the P_star and P_alt distributions are constructed. The implementation of
the inner maximization problem defining f^c can use multiple threads in parallel.
The ability to spawn multiple processes is useful when using a large number of
re-starts for the inner non-concave maximization problem. 

Once the script has run to completion, the sample paths have been written to disk, 
the two plots in the paper can be generated using these two commands:

   python3 plot_fig1_left.py
   python3 plot_fig1_right.py
   
   
