import matplotlib.pyplot as plt
from matplotlib import rcParams
import numpy as np
import argparse

#first version of code for plots

colors = rcParams['axes.prop_cycle'].by_key()["color"]

parser = argparse.ArgumentParser(description='ReLU Experiment Plotter')
parser.add_argument('--nx', type=int, default=20, metavar='N')
parser.add_argument('--ny', type=int, default=20, metavar='N')
parser.add_argument('--convex', type=int, default=False, metavar='N')

args = parser.parse_args()

nx = args.nx
ny = args.ny
if not convex:
	filestring = "nx={:04d}_ny={:04d}".format(nx, ny)
else:
	filestring = "nx={:04d}_ny={:04d}_cv".format(nx, ny)

n_col = 4
n_row = 1
fig, axs = plt.subplots(n_row, n_col, figsize=(n_col * 3, n_row * 3))

# parse the log file
log_data = np.loadtxt("time_log_" + filestring + ".dat")

time_steps = len(log_data)//12
log_data_list = []
log_data_list.append(log_data[:(3*time_steps),:])
log_data_list.append(log_data[(3*time_steps):(6*time_steps),:])
log_data_list.append(log_data[(6*time_steps):(9*time_steps),:])
log_data_list.append(log_data[(9*time_steps):(12*time_steps),:])

for row in range(4):
    log_data_LGV = log_data_list[row][:time_steps,:]
    log_data_MD = log_data_list[row][time_steps:2*time_steps,:]
    log_data_WFR = log_data_list[row][2*time_steps:,:]

    ts = log_data_LGV[:, 0] 
    axs[row].plot(ts, np.log(np.maximum(log_data_LGV[:, 2],1.0e-10)),
                label=r"$log \ NI_{LGV}$")
    axs[row].plot(ts, np.log(np.maximum(log_data_MD[:, 2],1.0e-10)),
                label=r"$log \ NI_{MD}$")
    axs[row].plot(ts, np.log(np.maximum(log_data_WFR[:, 2],1.0e-10)),
                label=r"$log \ NI_{WFR}$")
    axs[row].set_ylabel(r"$log \ NI \ error$")
    axs[row].set_xlabel(r"$time$")
    axs[row].legend(fontsize=8)

fig.tight_layout()
fig.savefig("plots_" + filestring + ".pdf")
