data=yelp
embeddings="nnlm50 nnlm128 nnlm50_norm nnlm128_norm bert elmo use"

ks=250

for suffix in $embeddings
do
  outputfolder=results/$data/knn_accuracy
  mkdir -p $outputfolder

  cmd="python lib/estimate.py --method knn --features_train matrices/$data/train/features_$suffix.npy --labels_train matrices/$data/train/labels_$suffix.npy --features_test matrices/$data/test/features_$suffix.npy --labels_test matrices/$data/test/labels_$suffix.npy -v 1 --output_file $outputfolder/$suffix.csv --knn_subtest 5000 --knn_subtrain 5000"

  i=1
  until [ $i -gt $ks ]
  do
    cmd="$cmd --knn_k $i"
    ((i=i+1))
  done

  echo "Running $cmd"
  $cmd
  echo "Done $cmd"
done
