data=imdb
embeddings="bow bow_tfidf pca_8 pca_16 pca_32 pca_64 elmo nnlm50 nnlm50_norm nnl128 nnlm128_norm use bert"

ks=250

for suffix in $embeddings
do
  outputfolder=results/$data/knn_accuracy
  mkdir -p $outputfolder

  cmd="python lib/estimate.py --method knn --features_train matrices/$data/train/features_$suffix.npy --labels_train matrices/$data/train/labels_$suffix.npy --features_test matrices/$data/test/features_$suffix.npy --labels_test matrices/$data/test/labels_$suffix.npy -v 1 --output_file $outputfolder/$suffix.csv --knn_subtest 2500 --knn_subtrain 2500"

  i=1
  until [ $i -gt $ks ]
  do
    cmd="$cmd --knn_k $i"
    ((i=i+1))
  done

  echo "Running $cmd"
  $cmd
  echo "Done $cmd"
done
