

import boto3
import botocore.exceptions
import botocore.errorfactory

import logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__file__)

def upload_to_s3(local_path: str, bucket_name: str, key: str, public_read: bool, create_new_bucket: bool = False):
    "If create_new_bucket, then a new bucket is created if the bucket doesn't exist."
    logger.info("Uploading %s to bucket %s with key %s...", local_path, bucket_name, key)

    args = {}
    if public_read:
        args["ACL"] = "public-read"

    bucket = get_s3_bucket(bucket_name)

    def upload():
        bucket.upload_file(local_path, key, ExtraArgs=args)

    try:
        upload()
    except boto3.exceptions.S3UploadFailedError as e:
        if ("NoSuchBucket" in str(e)) and create_new_bucket:
            create_bucket(bucket_name)
            upload()
        else:
            raise

    return {
        "key": key,
        "url": f"https://{bucket_name}.s3.amazonaws.com/{key}"
    }

def new_s3_resource():
    return boto3.resource("s3")
    # return boto3.resource("s3", **get_aws_credentials())

def get_s3_bucket(bucket_name: str):
    # pylint: disable=no-member
    resource = new_s3_resource()
    return resource.Bucket(bucket_name)

def create_bucket(bucket_name: str, client=None):
    logger.info("Creating bucket '%s'.", bucket_name)
    if client is None:
        client = new_s3_client()
    client.create_bucket(Bucket=bucket_name)

def new_s3_client():
    return boto3.client("s3")
    # return boto3.client("s3", **get_aws_credentials())
