import tempfile
import os
import logging

from uuid import uuid4
from flask import Flask, request, jsonify, make_response
from app_driver import visualize_component
from aws import upload_to_s3

app = Flask(__name__)

if __name__ != "__main__":
    gunicorn_logger = logging.getLogger("gunicorn.error")
    app.logger.handlers = gunicorn_logger.handlers
    app.logger.setLevel(gunicorn_logger.level)

@app.route('/generate', methods=["POST"])
def generate():
    app.logger.info("Generating GANSpace video...")

    json = request.json
    assert json["password"] == "helmholtz-is-cool"
    assert "args" in json
    assert "bucket" in json
    assert "key" in json

    with tempfile.TemporaryDirectory() as out_dir:
        output_file = os.path.join(out_dir, json["key"])
        visualize_component(output_file=output_file, **json["args"])

        app.logger.info("Video generated successfully. Uploading to S3...")

        return jsonify(upload_to_s3(
            output_file,
            json["bucket"],
            json["key"],
            public_read=True,
            create_new_bucket=True
        ))

if __name__ == "__main__":
    app.run(host="0.0.0.0", port=5000)

# sudo systemctl start ganspace
