Code for paper "Residual Distillation: Towards Portable Deep Neural Networks without Shortcuts"


## Training the baseline

The joint training framework requires the pre-trained teacher model. We first need to train the baseline resnet model. Note: please change the dataset dir in the related file.
To train a resnet on the ImageNet dataset: 
     `bash ./script/resnet_imagenet.sh num_of_layers 0.0 RES_NMT 1e-4`
     num_of_layers = 18/34/50, the number of layers of the resnet model
     
 To train a resnet on the CIFAR dataset:
     `bash ./script/resnet_icifar.sh`num_of_layers 0.0 RES_NMT seed
     seed= the random seed you want to set

## Training the plain-CNN baseline
To train the plain-CNN model on the ImageNet dataset:
`bash ./script/imagenet_plaincnn.sh num_of_layers 0.0 CNN_NMT `

To train the plain-CNN model on the CIFAR dataset:
`bash ./script/CIFAR_plaincnn.sh num_of_layers 0.0 CNN_NMT seed`


## Training the joint training network
After getting the pre-trained resnet teacher model, we could train the joint training network in the ImageNet dataset
plain-CNN34
`bash ./script/resnet_imagenet.sh 34 5e-3 TA 1e-4`
plain-CNN50
`bash ./script/resnet_imagenet.sh 50 5e-3 TA 1e-5`

To train the joint training network on the CIFAR-dataset:
`bash ./script/CIFAR_plaincnn.sh num_of_layers 0.5 TA seed`
