#!/bin/bash

# Used to run distillation benchmark on one instance. This script takes same ordered args as run_dataset:
# 1 = dataset_name, 2 = profile, 3 = methods, 4 = tag (not optional here!)

set -e

export ARGS="$*"

PATH_TO_RUN_DATASET="/home/ubuntu/autogluon-utils/autogluon_utils/benchmarking/distill_benchmark/run_dataset.py"
LOGFILE="python_output.log"
PYTHON_COMMAND="python -u $PATH_TO_RUN_DATASET $ARGS"
S3LOC="s3://gibbsdist/results/"$1"/"$2"/"$4"/"$LOGFILE

echo "Now running $0 with args: $ARGS"
echo "Logs will be stored in: $S3LOC"


echo "Running command:"
echo $PYTHON_COMMAND

$PYTHON_COMMAND 2>&1 | tee $LOGFILE

echo "Command completed. Copying output log to s3..."

aws s3 cp $LOGFILE $S3LOC

echo "Finished job. Logs copied to: $S3LOC"

exit 0

