""" Helper functions to convert pandas DataFrame into entirely numerical matrix (stored in DataFrame)
    Performs same data preprocessing as for tabular neural network model (missing value imputation, one-hot encoding of categoricals, handling of high-cardinality categoricals). 
"""

def table2matrix(df, preprocessor = None):
    """ Converts dataframe entirely to numerical values.
    
    Args: 
        df : pandas DataFrame
        preprocessor : object that can preprocess new data if we have already processed previous data.
            Default = None for processing training data. In this case, the preprocessor will be constructed 
            as well as returned for processing future data.
    
    Returns:
        DataFrame containing only numerical values.
        If preprocessor = None originally, then tuple is returned of processed dataframe together with preprocessor object.
    """
    is_train = False
    if preprocessor is None:
        is_train = True
    
    
    
    if is_train:
        return (processed_df, preprocessor)
    return processed_df

