import numpy as np
import matplotlib.pyplot as plt
import matplotlib
import pickle

font = {'size': 16}
matplotlib.rc('font', **font)

dat = pickle.load(open('CIFAR_pruned_matrices.pkl', 'rb'))
CIFAR_pruned = dat['Xs'][0]

dat = pickle.load(open('CIFAR_raw_matrices.pkl', 'rb'))
CIFAR_raw = dat['Xs'][0]

(n,d) = CIFAR_pruned.shape
gaussian = np.random.normal(size=(n,d))/np.sqrt(d)

def cross(X):
  return np.dot(np.transpose(X),X)

def hist_offdiag(X,xlim=None,ylim=None,title=None,fname=None):
  Sigma = cross(X)
  f, ax = plt.subplots(1,1)
  ax.hist(Sigma[np.triu_indices(X.shape[1],1)],bins=100)
  ax.set_title(title)
  ax.set_xlabel('Pairwise inner-products')
  plt.tight_layout()
  plt.savefig('%s_offdiag.png' % fname)

hist_offdiag(CIFAR_pruned,title='CIFAR-10 w/ 10 PCs removed',fname='CIFAR_pruned')
hist_offdiag(CIFAR_raw,title='CIFAR-10',fname='CIFAR_raw')
hist_offdiag(gaussian,title='IID Gaussian inputs',fname='gaussian')

