from __future__ import absolute_import, division, print_function, unicode_literals

# general
from abc import abstractmethod
import collections
import random
import time
import tqdm
import datetime
import argparse
import os

# images  / display
import glob
import PIL
import imageio
import matplotlib.pyplot as plt
from IPython import display

# machine learning / graphs
import gym
import gym.spaces
import networkx as nx
import numpy as np
import scipy.sparse.csgraph
import tensorflow as tf

# RL agents
from tf_agents import specs
from tf_agents.agents import tf_agent
from tf_agents.agents.ddpg import actor_network
from tf_agents.agents.ddpg import critic_network
from tf_agents.drivers import dynamic_step_driver
from tf_agents.drivers import py_driver
from tf_agents.environments import gym_wrapper
from tf_agents.environments import tf_py_environment
from tf_agents.environments import wrappers
from tf_agents.eval import metric_utils
from tf_agents.metrics import tf_metrics
from tf_agents.networks import utils
from tf_agents.policies import actor_policy
from tf_agents.policies import epsilon_greedy_policy
from tf_agents.policies import greedy_policy
from tf_agents.policies import ou_noise_policy
from tf_agents.policies import q_policy
from tf_agents.policies import random_tf_policy
from tf_agents.policies import tf_policy
from tf_agents.replay_buffers import tf_uniform_replay_buffer
from tf_agents.trajectories import time_step
from tf_agents.trajectories import trajectory
from tf_agents.utils import common

tf.compat.v1.enable_v2_behavior()
# only allocate GPU memory as needed https://stackoverflow.com/questions/34199233/how-to-prevent-tensorflow-from-allocating-the-totality-of-a-gpu-memory
opts = tf.compat.v1.GPUOptions(allow_growth=True)
conf = tf.compat.v1.ConfigProto(gpu_options=opts)
tf.compat.v1.enable_eager_execution(config=conf)
# only occupy a fraction of GPU memory
#opts = tf.GPUOptions(per_process_gpu_memory_fraction=0.2)
#conf = tf.ConfigProto(gpu_options=opts)
#tf.enable_eager_execution(config=conf)
#tf.compat.v1.enable_eager_execution()
tf.compat.v1.logging.set_verbosity(tf.compat.v1.logging.INFO)
