import torch
import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import imageio

def plot_gif(before_project, after_project, arrow, name = '0'):
    def generate_one_frame(data, pred, arrow, xy_max = 2.5):

        fig, ax = plt.subplots(figsize=(10,10))

        X, Y, U, V = zip(*[arrow])
        ax.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

        ax.scatter(data[:,0], data[:,1], c = 'y')
        ax.scatter(pred[:,0], pred[:,1], c = 'b')       
        ax.grid()
        ax.set(xlabel='X', ylabel='Y', title='yellow: points before projection; blue: after projection.')
        ax.set_xlim(-xy_max, xy_max)
        ax.set_ylim(-xy_max, xy_max)
        fig.canvas.draw()     
        # fig.show()

        image = np.frombuffer(fig.canvas.tostring_rgb(), dtype='uint8')
        image  = image.reshape(fig.canvas.get_width_height()[::-1] + (3,))


        return image
    
    imageio.mimsave('./visulization_' + name + '.gif', [
        generate_one_frame(before_project[i], after_project[i], arrow[i]) 
        for i in range(len(before_project))
        ], fps=10)

def show_one_frame(data, pred, arrow, xy_max = 1):
    X, Y, U, V = zip(*[arrow])
    plt.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

    plt.scatter(data[:,0], data[:,1], c = 'y')
    plt.scatter(pred[:,0], pred[:,1], c = 'b')       
    plt.grid()
    plt.title('yellow: points before projection; blue: after projection.')
    plt.xlim(-xy_max, xy_max)
    plt.ylim(-xy_max, xy_max)
    plt.show()


class Proj():
    def __init__(self):
        model_path = 'models/checkpoint _612.pt'
        self.model = torch.load(model_path).cpu()
    def project(self, data):
        d = torch.Tensor(data[None, :, :])
        pred = self.model(d)
        pred = pred[0,:,:]
        return pred.detach().numpy()

def test(te = 0):
    data = np.zeros([10,2])
    dx = 0.2
    timestamp = 0.1

    for i in range(data.shape[0]-3):
        data[i, 0] = i * dx
        data[i, 1] = 0
    data[7,0] = data[6,0] + .35; data[7,1] = data[6,1] + (-.1); 
    data[8,0] = data[6,0] + .55; data[8,1] = data[6,1] + .4; 
    data[9,0] = data[6,0] + .15; data[9,1] = data[6,1] + .45; 


    if te == 0:
        force = lambda t: np.array([0.5, np.cos(t)]) * 0 
        g = np.array([0, -10])
    elif te == 1:
        force = lambda t: np.array([0.5, np.cos(t)]) * 25
        g = np.array([0, 0])
    elif te == 2:
        force = lambda t: np.array([1, np.cos(t)]) * 20
        g = np.array([0, 0])

    vel = np.array(data)*0
    data_list = []
    proj_list = []
    force_list = []
    pr = Proj()
    for ite in range(100):
        new_data = np.array(data)
        f_8 = force(ite * timestamp)
        vel[8, :] += f_8 * timestamp
        for i in range (1, len(data)):
            vel[i, :] += timestamp * g
            new_data[i, :] = data[i,:] + vel[i,:] * timestamp 

        data_list.append(np.array(new_data))
        force_list.append(np.array([new_data[8,0], new_data[8,1], f_8[0]/50, f_8[1]/50]))

        new_data = pr.project(new_data) # new_data*0.5 + 0.5 * 
        

        proj_list.append(np.array(new_data))
        
        for i in range (len(data)):
           vel[i,:] =  (new_data[i,:] - data[i,:]) / timestamp # vel[i,:] * 0.5 + 0.5 *
        # print(new_data); print(data); print(vel)
        # show_one_frame(data_list[-1], proj_list[-1], force_list[-1])

        data = (np.array(new_data))
        # aaaaaaaaaaaaaaaaaaaa

    plot_gif(data_list, proj_list, force_list, str(te))




if __name__ == '__main__':
    test(0)
    test(1)
    test(2)