%%
% Fig 19 in Sec C.5
% Showing that when f_0 have multiple potential wells, multiple invariant
% distributions may exist.
% f_0=k(x^2-1) for k=5
% f_1,eps=eps*sin(x/eps)


%%
k=5;        % parameter in f_0
eta=0.05;
epsilon=0.0001;
f_0=@(x)k*(x.^2-1).^2;      % f_0, the object function with 2 potential wells
f_1=@(x)epsilon*sin(x/epsilon);
f=@(x)f_0(x)+f_1(x);
grad_0=@(x)k*4*x.*(x.^2-1); % gradient of f_0
grad_1=@(x)cos(x/epsilon);  % gradient of f_1
pts_init=1.2:0.00001:1.3;   % distribution of initial ensemble
pts=pts_init;
MAX=10000;                  % number of steps for evolving the ensemble
MAX_Orbit=10000;            % number of steps for evolving a single orbit
orbit_1=[];
orbit_2=[];
%%
for i=1:MAX
    %pts=pts-eta*grad_0(pts)-eta*grad_1(pts);
    pts=pts-eta*grad_0(pts)-eta*grad_1(pts);    % evolving to get invariant distribution
end

% Both orbits are trapped in their own potential well, but the orbit in
% right potential well will converge to the invariant distribution in the
% right potential well, which is also plotted in this script.
x_1=1.1;        % initial conditions in the right well of illustrative orbits
for i=1:MAX_Orbit
    x_1=x_1-eta*grad_0(x_1)-eta*grad_1(x_1);    % evolving for a single orbit
    orbit_1=[orbit_1,x_1];                      % save results for plotting
end
x_2=-1.1;       % initial conditions in the left well of illustrative orbits
for i=1:MAX_Orbit
    x_2=x_2-eta*grad_0(x_2)-eta*grad_1(x_2);    % evolving for a single orbit
    orbit_2=[orbit_2,x_2];                      % save results for plotting
end
%% plot the result
xbins=0.7:0.02:1.35;
histogram(pts_init,xbins,'Normalization','pdf');
hold on;
histogram(pts,xbins,'Normalization','pdf');
set(gca,'FontSize',16);
xlabel('x')
ylabel('pdf');
ylim([0,10]);
title('evolution of ensemble empirical distribution');
legend('initial distri.',['@ iteration #',num2str(MAX)]);
set(gcf,'Position',[400 300 800 600]);

figure
histogram(orbit_1,xbins,'Normalization','pdf');
set(gca,'FontSize',16);
title(['hist of an orbit over time (IC=',num2str(orbit_1(1)),')']);
xlabel('x')
ylabel('pdf')
ylim([0,10]);
set(gcf,'Position',[400 300 800 600]);

figure
histogram(orbit_2,-1.35:0.02:-0.7,'Normalization','pdf');
set(gca,'FontSize',16);
title(['hist of another orbit over time (IC=',num2str(orbit_2(1)),')']);
xlabel('x')
ylabel('pdf')
ylim([0,10])
set(gcf,'Position',[400 300 800 600]);

figure
plot(orbit_1);
set(gca,'FontSize',16);
title(['one orbit (IC=',num2str(orbit_1(1)),')']);
xlabel('# of iteration');
ylabel('x');
axis([0 MAX_Orbit 0.7 1.35]);
set(gcf,'Position',[400 300 800 600]);

figure
pts_plot=-1.7:0.01:1.7;
plot(pts_plot,f_0(pts_plot));
set(gca,'FontSize',16);
title('landscape of f_0(x)');
xlabel('x');
ylabel('f_0(x)');
set(gcf,'Position',[400 300 800 600]);