%% 
% Fig 16 in Sec C.4.1
% Momentum added to GD
% Heavy ball method
% f_0=x^2/2
% f_1,eps=eps cos(x/eps)
%%
epsilon=0.0001;
h=0.1;              % step size

xIC=[1:0.0001:2];   % distribution of initial ensemble
bins=[-2:0.1:2];    % bins for plot

TimeSteps=10000;    % number of steps for evolving the ensemble

gamma=0.9;          % parameter in heavy ball method

%%
x=xIC;  

Y=0.*x; % initial condition for momentum

orbit=zeros(1,TimeSteps+1);
orbit(1)=x(1);
for i=1:TimeSteps
    % a discrete version known as Heavy Ball Method; a reference: Boris T Polyak. Some methods of speeding up the convergence of iteration methods. USSR Computational Mathematics and Mathematical Physics, 4(5):1?17, 1964.
    % iteration for heavy ball method
    Y=gamma*Y-h*(x-sin(x/epsilon));    
    x=x+Y;

    orbit(i+1)=x(1);    % Take x(1) as an orbit and show the system is ergodic
end

%% plot the result
figure
histogram(xIC,bins,'Normalization','pdf');
hold on
histogram(x,bins,'Normalization','pdf');
title('\fontsize{32}hist of ensemble at final time');
set(gca,'FontSize',24);
xlabel('evolution of ensemble empirical distribution');
ylabel('pdf');
legend('initial distri.',['@ iteration #',num2str(TimeSteps)]);
set(gcf,'Position',[400 300 800 600]);

figure
histogram(orbit,bins,'Normalization','pdf');
set(gca,'FontSize',24);
ylim([0,1.2])
xlabel('x');
ylabel('pdf');
title(['\fontsize{32}hist of an orbit over time (IC=',num2str(orbit(1)),')']);
set(gcf,'Position',[400 300 800 600]);

figure
plot(orbit);
set(gca,'FontSize',24);
xlabel('# of iteration');
ylabel('x');
axis([0 TimeSteps -1.8 1.8]);
title(['\fontsize{32}one orbit (IC=',num2str(orbit(1)),')']);
set(gcf,'Position',[400 300 800 600]);

