%%
% Fig 13(b) in Sec C.3.2
% Test the expression for Lyap Exp in Thm 9 for non-periodic function given
% in Example 2
% This script plots the dependence of Lyap exp on epsilon
% f_0=x^4/4
% f_1=eps*sin(x/eps)+eps*sin(sqrt(2)x/eps)
%%
eta=0.1;                        % fixed eta
epsilon=0.00001:0.00001:0.01;   % range of eta to be tested
MAX=1000;               % number of steps for iteration then estimating Lyap exp
grad=@(x)cos(x./epsilon)+sqrt(2)*cos(sqrt(2)*x./epsilon)+x.^3;  % gradient of f_0+f_1
d_grad=@(x)-sin(x./epsilon)./epsilon-2*sin(sqrt(2)*x./epsilon)./epsilon+3*x.^2; % 2-order gradient of f_0+f_1 
L_memory=epsilon;
x=rand(1,length(epsilon));  % ramdom initial values
d_memory=zeros(1,length(epsilon));
%% evolving
for j=1:MAX
    x=x-eta*grad(x);
    d_memory=d_memory+log(abs(1-eta*d_grad(x)));    % calsulte the sum of ln(phi'')
end
%% calculate the theoretical value of m in cond 2
temp=@(x)log(abs(-sin(x)-2*sin(sqrt(2)*x)));
m=integral(temp,0,100)/100;



%% plot the result
figure
plot(epsilon,d_memory/MAX);
set(gca,'FontSize',24);
ylabel('Lyap Exp \lambda(x)')
xlabel('\epsilon')
set(gcf,'Position',[400 300 800 600]);


figure
plot(epsilon,d_memory/MAX-log(eta./epsilon));
title(["\fontsize{32}Lyap Exp against \epsilon (\eta=0.1)"])
set(gca,'FontSize',24);
ylabel('\lambda(x)-ln(\eta/\epsilon)')
xlabel('\epsilon')
ylim([-7,1.5])
set(gcf,'Position',[400 300 800 600]);
