%%
% Fig 9 in Sec C.2
% Test for explicit expression for Lyap exp in Thm 8
% This script plots the dependent of Lyap exp on eta
% f_0=(x^2-1)^2
% f_1=eps*sin(x/eps)
%%
epsilon=0.00001;    % fixed eps
MAX=1000;           % number of steps for iteration then estimating Lyap exp
grad=@(x)cos(x/epsilon)+4*x.*(x.^2-1);  % gradient of f_0+f_1
d_grad=@(x)sin(x/epsilon)/epsilon+12*x.^2-4;    % 2-order gradient of f_0+f_1 
eta=0.0002:0.0001:0.1;  % range of eta to be tested
L_memory=eta;
x=rand(1,length(eta));  % ramdom initial values
d_memory=zeros(1,length(eta));
%% evolving
for j=1:MAX
    x=x-eta.*grad(x);
    d_memory=d_memory+log(abs(eta.*d_grad(x)));	% calsulte the sum of ln(phi'')
end
%%
figure
plot(eta,d_memory/MAX); % d_memory/MAX is the Lyap exp
xlabel('\eta')
ylabel('Lyap Exp \lambda(x)')
set(gca,'FontSize',16);
set(gcf,'Position',[400 300 800 600]);

figure
plot(eta,d_memory/MAX-log(eta/epsilon));
xlabel('\eta')
ylabel('\lambda(x)-ln(\eta/\epsilon)')
set(gca,'FontSize',16);
set(gcf,'Position',[400 300 800 600]);