%%
% Fig 10 in Sec C.2
% Test for explicit expression for Lyap exp in Thm 8
% This script plots the dependent of Lyap exp on epslion
% f_0=(x^2-1)^2
% f_1=eps*sin(x/eps)
%%
eta=0.1;    % fixed eta
epsilon=0.00001:0.00001:0.01;   % range of eps to be tested
MAX=1000;                       % number of steps for iteration then estimating Lyap exp
grad=@(x)cos(x/epsilon)+4*x.*(x.^2-1);  % gradient of f_0+f_1
d_grad=@(x)sin(x./epsilon)./epsilon+12*x.^2-4;  % 2-order gradient of f_0+f_1 
L_memory=epsilon;
x=rand(1,length(epsilon));      % randomly chosen initial condition
d_memory=zeros(1,length(epsilon));
%% evolving
for j=1:MAX
    x=x-eta*grad(x);                            % evolving
    d_memory=d_memory+log(abs(eta*d_grad(x)));  % calsulte the sum of ln(phi'')
end
%% plot the result
figure
plot(epsilon,d_memory/MAX); % d_memory/MAX is the Lyap exp
ylabel('Lyap Exp \lambda(x)')
set(gca,'FontSize',16);
xlabel('\epsilon')
set(gcf,'Position',[400 300 800 600]);


figure
plot(epsilon,d_memory/MAX-log(eta./epsilon));
ylabel('\lambda(x)-ln(\eta/\epsilon)')
xlabel('\epsilon')
set(gca,'FontSize',16);
set(gcf,'Position',[400 300 800 600]);
