%%
% Fig 8 in Sec C.2
% Showing that the deterministic map phi and the related stochastic have
% the same invariant distribution in 2-dim as Thm 4 shows.
% f_0 is Matyas function and f_1,eps is periodic


%%
epsilon=0.00001;    % eps<<eta need to be satisfied
eta=0.01;
N=50000;    % number of points in the ensemble
MAX=10000;  % number of steps for evolving the ensemble

f_0=@(x)0.26*(x(1,:).^2+x(2,:).^2)+0.48*x(2,:).*x(1,:);
f_1=@(x)epsilon*(sin(x(1,:)/epsilon)+cos(x(2,:)/epsilon));

%%
x_0=(rand(2,N)-0.5)*2;  % distribution of initial ensemble
x_chaos=x_0;            % both deterministic and stochastic map have the same initial condition
x_stoch=x_0;
U=zeros(size(x_0));
for i=1:MAX
    x_chaos=x_chaos-eta*(grad_0(x_chaos)+grad_1(x_chaos));  % deterministic iteration (phi)
    U=rand(size(x_0))*epsilon*(2*pi);
    x_stoch=x_stoch-eta*(grad_0(x_stoch)+grad_1(U));        % related stochastic iteration (\hat{\phi})
end
%% plot the result
figure
histogram2(x_0(1,:),x_0(2,:),'XBinEdges',[-1:0.01:1],'YBinEdges',[-1:0.01:1],'Normalization','pdf');
hold on
% histogram of invariant distribution of the deterministic map
histogram2(x_chaos(1,:),x_chaos(2,:),'XBinEdges',[-1:0.01:1],'YBinEdges',[-1:0.01:1],'Normalization','pdf');
title('Deterministic map');
legend('initial distri.',['@ iteration #',num2str(MAX)]);
set(gca,'FontSize',16);
xlabel('x')
ylabel('y')
zlabel('pdf')
zlim([0,18])
set(gcf,'Position',[400 300 800 600]);

figure
histogram2(x_0(1,:),x_0(2,:),'XBinEdges',[-1:0.01:1],'YBinEdges',[-1:0.01:1],'Normalization','pdf');
hold on
% histogram of invariant distribution of the stochastic map
histogram2(x_stoch(1,:),x_stoch(2,:),'XBinEdges',[-1:0.01:1],'YBinEdges',[-1:0.01:1],'Normalization','pdf');
title('Stochastic map');
set(gca,'FontSize',16);
xlabel('x')
zlabel('pdf')
ylabel('y')
zlim([0,18])
legend('initial distri.',['@ iteration #',num2str(MAX)]);
set(gcf,'Position',[400 300 800 600]);


%%

%gradient of f_0
function g=grad_0(x)
g=zeros(size(x));
g(1,:)=0.52*x(1,:)+0.48*x(2,:);
g(2,:)=0.52*x(2,:)+0.48*x(1,:);
end

%gradient of f_1,eps
function g=grad_1(x)
epsilon=0.0000001;
g=zeros(size(x));
g(1,:)=cos(x(1,:)/epsilon);
g(2,:)=-sin(x(2,:)/epsilon);
end
