%%
% Fig 10 in Sec C.2
% let f_0 be Matyas function and f_1,eps be periodic
% Observe that the system is mixing

%%
epsilon=0.0000001;
eta=0.01;
MAX=10000;              % number of steps for evolving the ensemble
MAX_Orbit=10000000;     % number of steps for evolving a single orbit
f_0=@(x)0.26*(x(1,:).^2+x(2,:).^2)+0.48*x(2,:).*x(1,:);     % Matyas function
f_1=@(x)epsilon*(sin(x(1,:)/epsilon)+cos(x(2,:)/epsilon));


%%
orbit=zeros(2,MAX_Orbit);   % 1st row is x, 2st
x_orbit_0=[0.01;0.01];      % initial conditions of the illustrative orbits (in 2-dim)
orbit(:,1)=x_orbit_0;
for i=1:MAX_Orbit+1
    temp_x=orbit(:,i);
    temp_x=temp_x-eta*(grad_0(temp_x)+grad_1(temp_x));  % iterating
    orbit(:,i+1)=temp_x;
end
%% plot the result
figure
histogram2(orbit(1,:),orbit(2,:),'XBinEdges',[-1:0.01:1],'YBinEdges',[-1:0.01:1],'Normalization','pdf');
title('hist of one orbit over time (IC=(0.01,0.01))');
zlim([0,18])
xlabel('x')
ylabel('y')
zlabel('density')
set(gca,'FontSize',16);
set(gcf,'Position',[400 300 800 600]);

orbit_label=1:10000;
figure
plot(orbit_label,orbit(1,orbit_label));
title('x value of one orbit (IC=(0.01,0.01))');
set(gca,'FontSize',16);
xlabel('# of iteration');
ylabel('x');
xlim([0,10000])
set(gcf,'Position',[400 300 800 600]);

figure
plot(orbit_label,orbit(2,orbit_label));
title('y value of one orbit (IC=(0.01,0.01))');
set(gca,'FontSize',16);
xlabel('# of iteration');
ylabel('y');
xlim([0,10000])
set(gcf,'Position',[400 300 800 600]);

function g=grad_0(x)
g=zeros(size(x));
g(1,:)=0.52*x(1,:)+0.48*x(2,:);
g(2,:)=0.52*x(2,:)+0.48*x(1,:);
end

function g=grad_1(x)
epsilon=0.0000001;
g=zeros(size(x));
g(1,:)=cos(x(1,:)/epsilon);
g(2,:)=-sin(x(2,:)/epsilon);
end
