%%
% Fig 3 in Sec 3.1
% Test the ergodicity, mixing and explicit expression for invariant
% distribution for periodic f_1,eps
% f=x^4/4+eps sin(x/eps)
% f_0=x^4/4
% f_1=sin(x)
%%
epsilon=1E-6;
h=0.1;

xIC1=-1*[0.5:0.000001:1.5];		% distribution of initial ensemble
xIC2=[0.5; 1.5];				% initial conditions of two illustrative orbits
bins=[-2:0.1:2];				% bins for plotting the histogram

TimeSteps1=1000;				% number of steps for evolving the ensemble
TimeSteps2=1000000;				% number of steps for evolving a single orbit
plotFrequency=TimeSteps2+1;
figure

%%
for idx=1:2						% idx==1 -> evolve the ensemble;	idx==2 -> evolve a single orbit
    if (idx==1)
        x=xIC1;
        TimeSteps=TimeSteps1;
    else
        x=xIC2;
        TimeSteps=TimeSteps2;
    end
    orbit=zeros(2,TimeSteps+1);		% only store the entire histories of the first two orbits in the ensemble for the sake of memory
    orbit(:,1)=x(1:2)';
    for i=1:TimeSteps
        if mod(i,plotFrequency)==0
            histogram(x,bins,'Normalization','pdf');
            axis([min(bins) max(bins) 0 1.2]);
            title(['hist of ensemble at iteration #',num2str(i),' (',num2str(i/TimeSteps),')']);
            drawnow
        end
        x=x-h*(x.^3+cos(x/epsilon));               % convex but not strongly convex potential, evolve the ensemble according to GD
        orbit(:,i+1)=x(1:2)';
    end
    if (idx==1)
        x1=x;		% save results for plotting
    else
        x2=x;		% save results for plotting
    end
end

%% plot the results
%close all

figure;
histogram(xIC1,bins,'Normalization','pdf');
hold on
histogram(x1,bins,'Normalization','pdf');
xSpan=linspace(bins(1),bins(end),1001);
ySpan=exp(-xSpan.^4*2^2/4/h)/1.01942;		% our theoretical prediction: rescaled Gibbs distribution
plot(xSpan,ySpan,'r','LineWidth',4);
set(gca,'FontSize',16);
axis([min(bins) max(bins) 0 1.2]);
xlabel('x');
ylabel('pdf');
legend('initial distri.',['@ iteration #',num2str(TimeSteps1)],'rescaled Gibbs');
title('evolution of ensemble empirical distribution');
set(gcf,'Position',[400 300 800 600]);

figure;
histogram(orbit(1,:),bins,'Normalization','pdf');
set(gca,'FontSize',16);
axis([min(bins) max(bins) 0 1.2]);
xlabel('x');
ylabel('pdf');
title(['hist of an orbit over time (IC=',num2str(orbit(1,1)),')']);
set(gcf,'Position',[400 300 800 600]);


figure;
histogram(orbit(2,:),bins,'Normalization','pdf');
set(gca,'FontSize',16);
axis([min(bins) max(bins) 0 1.2]);
xlabel('x');
ylabel('pdf');
title(['hist of another orbit over time (IC=',num2str(orbit(2,1)),')']);
set(gcf,'Position',[400 300 800 600]);

figure;
plot(orbit(1,:));
set(gca,'FontSize',16);
xlabel('# of iteration');
ylabel('x');
axis([0 TimeSteps -1 1]);
title(['one orbit (IC=',num2str(orbit(1,1)),')']);
set(gcf,'Position',[400 300 800 600]);
