def get_dct(img):
    """ Get 2D Cosine Transform of Image
    """
    return fftpack.dct(fftpack.dct((img*255.0).T, norm='ortho').T, norm='ortho')

def get_2d_idct(coefficients):
    """ Get 2D Inverse Cosine Transform of Image
    """
    return fftpack.idct(fftpack.idct(coefficients.T, norm='ortho').T, norm='ortho')

def get_reconstructed_image(raw):
    img = raw.clip(0, 255)
    img = img.astype('uint8')
    return img

def get_idct(coefficients):
    a = get_2d_idct(coefficients)
    return get_reconstructed_image(a)/255.0


def take_topk(x, k): #WITH ABSOLUTE VALUES
    y = x
    eps = np.partition(np.abs(x).flatten(), -k)[-k]
    small_indices = y < eps
    small_indices2 = y > -eps
    y[(small_indices & small_indices2)] = 0
    return y

def solve_l1(y, max_iter=100, bit=bits_corruptible, k=top_k):    #IHT
    x = np.zeros_like(y)
    e = np.zeros_like(y)
    for iter in range(max_iter):
        x = take_topk(get_dct(y-e), k)
        zze = np.random.random_sample(y.shape)/1000000 + y-get_idct(x)
        e = take_topk(zze, bit)
    return get_idct(x)
    
def solve_all(X, chng, max_iter=100, bit=bits_corruptible, k=top_k):   #Iterating over all images
    Y = np.zeros_like(X)
    for i in range(len(X)):
        print(chng[i])
        Y[i,:,:,0] = solve_l1(X[i,:,:,0], max_iter, int(chng[i]), k)
    return Y
    


